/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.esmatrix.db.AbstractEnrichmentDbMulti;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbMulti;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnrichmentDbMultiImpl
extends AbstractEnrichmentDbMulti {
    private EnrichmentDb[] fEdbs;
    private Map fEdbNameEdbMap;

    public EnrichmentDbMultiImpl(String string, EnrichmentDb[] enrichmentDbArray) {
        if (enrichmentDbArray == null || enrichmentDbArray.length == 0) {
            throw new IllegalArgumentException("Param edbs cannot be null not zero: " + enrichmentDbArray);
        }
        String[] stringArray = new String[enrichmentDbArray.length];
        for (int i2 = 0; i2 < enrichmentDbArray.length; ++i2) {
            stringArray[i2] = enrichmentDbArray[i2].getName();
        }
        List list = enrichmentDbArray[0].getGeneSetNames();
        this.initHere(string, enrichmentDbArray, list.toArray(new String[list.size()]), stringArray);
    }

    public EnrichmentDbMultiImpl(String string, EnrichmentDb[] enrichmentDbArray, String[] stringArray, String[] stringArray2) {
        this.initHere(string, enrichmentDbArray, stringArray, stringArray2);
    }

    private void initHere(String string, EnrichmentDb[] enrichmentDbArray, String[] stringArray, String[] stringArray2) {
        int n;
        if (enrichmentDbArray == null) {
            throw new IllegalArgumentException("Param edbs_all cannot be null");
        }
        HashMap<String, EnrichmentDb> hashMap = new HashMap<String, EnrichmentDb>();
        for (n = 0; n < enrichmentDbArray.length; ++n) {
            if (hashMap.containsKey(enrichmentDbArray[n].getName())) {
                throw new IllegalArgumentException("Duplicate edb with name: " + enrichmentDbArray[n].getName());
            }
            hashMap.put(enrichmentDbArray[n].getName(), enrichmentDbArray[n]);
        }
        this.fEdbs = new EnrichmentDb[stringArray2.length];
        this.fEdbNameEdbMap = new HashMap();
        for (n = 0; n < stringArray2.length; ++n) {
            String string2 = stringArray2[n];
            Object v = hashMap.get(string2);
            if (v == null) {
                throw new IllegalArgumentException("No such edb: " + string2);
            }
            this.fEdbs[n] = (EnrichmentDb)v;
            this.fEdbNameEdbMap.put(this.fEdbs[n].getName(), this.fEdbs[n]);
        }
        super.init(string, stringArray, stringArray2);
    }

    @Override
    public final EnrichmentDbMulti cloneDeep(String string, String[] stringArray) {
        EnrichmentDb[] enrichmentDbArray = new EnrichmentDb[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            enrichmentDbArray[i2] = this.getEdb(stringArray[i2]);
        }
        return new EnrichmentDbMultiImpl(this.getName() + "_" + stringArray.length, enrichmentDbArray);
    }

    @Override
    public final EnrichmentDbMulti cloneDeep_gs(String string, String[] stringArray) {
        return new EnrichmentDbMultiImpl(string, this.fEdbs, stringArray, this.getEdbNamesArray());
    }

    @Override
    public final EnrichmentDbMulti cloneDeep(String[] stringArray) {
        return this.cloneDeep(this.getName() + "_" + stringArray.length, stringArray);
    }

    @Override
    public final EnrichmentDbMulti cloneDeep(String string, String[] stringArray, String[] stringArray2) {
        return new EnrichmentDbMultiImpl(string, this.fEdbs, stringArray, stringArray2);
    }

    @Override
    public final EnrichmentDbMulti cloneDeep(Dataset dataset) {
        return new EnrichmentDbMultiImpl(dataset.getName(), this.fEdbs, dataset.getRowNamesArray(), dataset.getColumnNamesArray());
    }

    @Override
    public final EnrichmentDb getEdb(int n) {
        return this.fEdbs[n];
    }

    @Override
    public final EnrichmentDb getEdb(String string) {
        Object v = this.fEdbNameEdbMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such edb: " + string + " \nAvailable: " + this.fEdbNameEdbMap.keySet());
        }
        return (EnrichmentDb)v;
    }
}

