/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.esmatrix.db.GeneSetSignalImpl;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import edu.mit.broad.vdb.chip.Chip;
import org.apache.log4j.Logger;

public class EnrichmentResultImpl
implements EnrichmentResult {
    private EnrichmentScore fScore;
    private Vector fRndESS;
    private RankedList fRankedList;
    private Template fTemplate_opt;
    private GeneSet fGeneSet;
    private Chip fChip;
    private FdrStruc fFdr;
    private static final Logger klog = XLogger.getLogger(EnrichmentResultImpl.class);
    private GeneSetSignal fSignal;

    public EnrichmentResultImpl(RankedList rankedList, Template template, GeneSet geneSet, Chip chip, EnrichmentScore enrichmentScore, Vector vector) {
        this.init(rankedList, template, geneSet, chip, enrichmentScore, vector, null);
    }

    public EnrichmentResultImpl(RankedList rankedList, Template template, GeneSet geneSet, Chip chip, EnrichmentScore enrichmentScore, Vector vector, FdrStruc fdrStruc) {
        this.init(rankedList, template, geneSet, chip, enrichmentScore, vector, fdrStruc);
    }

    private void init(RankedList rankedList, Template template, GeneSet geneSet, Chip chip, EnrichmentScore enrichmentScore, Vector vector, FdrStruc fdrStruc) {
        if (enrichmentScore == null) {
            throw new IllegalArgumentException("Param esStruc cannot be null");
        }
        if (geneSet == null) {
            throw new IllegalArgumentException("Param gset cannot be null");
        }
        this.fTemplate_opt = template;
        this.fRankedList = rankedList;
        this.fGeneSet = geneSet;
        this.fChip = chip;
        this.fScore = enrichmentScore;
        this.fRndESS = vector;
        this.fGeneSet = geneSet;
        this.fFdr = fdrStruc;
    }

    @Override
    public final GeneSetSignal getSignal() {
        if (this.fSignal == null) {
            this.fSignal = new GeneSetSignalImpl(this);
        }
        return this.fSignal;
    }

    @Override
    public final Vector getRndESS() {
        return this.fRndESS;
    }

    @Override
    public final FdrStruc getFDR() {
        return this.fFdr;
    }

    @Override
    public final EnrichmentScore getScore() {
        return this.fScore;
    }

    @Override
    public final RankedList getRankedList() {
        return this.fRankedList;
    }

    @Override
    public final Template getTemplate() {
        return this.fTemplate_opt;
    }

    @Override
    public final GeneSet getGeneSet() {
        return this.fGeneSet;
    }

    @Override
    public final String getGeneSetName() {
        return this.fGeneSet.getName(true);
    }

    @Override
    public final Chip getChip() {
        return this.fChip;
    }

    @Override
    public final int getNumPerms() {
        return this.fRndESS.getSize();
    }
}

