/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore$Type;

public class EnrichmentScoreImpl
implements EnrichmentScore {
    private int fNumHits;
    private float fES;
    private int fRankAtES;
    private float fRankScoreAtES;
    private float fNES;
    private float fNP;
    private float fFWER;
    private float fFDR;
    private Vector fESProfile;
    private Vector fESProfile_point_by_point;
    private int[] fHitIndices;

    public EnrichmentScoreImpl(float f2, int n, float f3, float f4, float f5, float f6, float f7, int n2, int[] nArray, Vector vector, Vector vector2) {
        this.init(f2, n, f3, f4, f5, f6, f7, n2, nArray, vector, vector2);
    }

    public EnrichmentScoreImpl(EnrichmentScore enrichmentScore, float f2, float f3, float f4, float f5) {
        this.init(enrichmentScore.getES(), enrichmentScore.getRankAtES(), enrichmentScore.getRankScoreAtES(), f2, f3, f4, f5, enrichmentScore.getNumHits(), enrichmentScore.getHitIndices(), enrichmentScore.getESProfile(), enrichmentScore.getESProfile_point_by_point_opt());
    }

    protected final void init(float f2, int n, float f3, float f4, float f5, float f6, float f7, int n2, int[] nArray, Vector vector, Vector vector2) {
        this.fES = f2;
        this.fRankAtES = n;
        this.fRankScoreAtES = f3;
        this.fNES = f4;
        this.fNP = f5;
        this.fFDR = f6;
        this.fFWER = f7;
        this.fNumHits = n2;
        this.fHitIndices = nArray;
        this.fESProfile = vector;
        this.fESProfile_point_by_point = vector2;
    }

    @Override
    public final boolean hasDeepInfo() {
        return this.fESProfile != null;
    }

    @Override
    public final float getES() {
        return this.fES;
    }

    @Override
    public final int getRankAtES() {
        return this.fRankAtES;
    }

    @Override
    public final float getRankScoreAtES() {
        return this.fRankScoreAtES;
    }

    @Override
    public final float getNES() {
        return this.fNES;
    }

    @Override
    public final float getNP() {
        return this.fNP;
    }

    @Override
    public final float getFWER() {
        return this.fFWER;
    }

    @Override
    public final float getFDR() {
        return this.fFDR;
    }

    @Override
    public final Vector getESProfile() {
        if (this.fESProfile != null) {
            this.fESProfile.setImmutable();
        }
        return this.fESProfile;
    }

    @Override
    public final Vector getESProfile_point_by_point_opt() {
        return this.fESProfile_point_by_point;
    }

    @Override
    public final int getNumHits() {
        return this.fNumHits;
    }

    @Override
    public final int[] getHitIndices() {
        return this.fHitIndices;
    }

    @Override
    public final float getScore(EnrichmentScore$Type enrichmentScore$Type) {
        if (enrichmentScore$Type == ES) {
            return this.getES();
        }
        if (enrichmentScore$Type == NES) {
            return this.getNES();
        }
        if (enrichmentScore$Type == FDR) {
            return this.getFDR();
        }
        if (enrichmentScore$Type == NP) {
            return this.getNP();
        }
        throw new IllegalArgumentException("Unknown Type: " + enrichmentScore$Type);
    }

    private void ensureDeep() {
        if (!this.hasDeepInfo()) {
            throw new IllegalStateException("KSScore was NOT consructed in deep mode -- info not available");
        }
    }
}

