/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.DefaultRankedFeature;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.RankedFeature;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import gnu.trove.TIntArrayList;
import java.util.HashSet;

public class GeneSetSignalImpl
implements GeneSetSignal {
    private TIntArrayList fCoreRanks;
    private EnrichmentResult fEr;
    private GeneSet fCoreGeneSet;

    public GeneSetSignalImpl(EnrichmentResult enrichmentResult) {
        this.fEr = enrichmentResult;
        this.fCoreRanks = new TIntArrayList();
        int[] nArray = enrichmentResult.getScore().getHitIndices();
        int n = enrichmentResult.getScore().getRankAtES();
        float f2 = enrichmentResult.getScore().getES();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (XMath.isPositive(f2)) {
                if (nArray[i2] > n) continue;
                this.fCoreRanks.add(nArray[i2]);
                continue;
            }
            if (nArray[i2] < n) continue;
            this.fCoreRanks.add(nArray[i2]);
        }
    }

    @Override
    public final String getName() {
        return this.fEr.getGeneSetName() + "_signal";
    }

    @Override
    public final int getSize() {
        return this.fCoreRanks.size();
    }

    public final RankedFeature getRankedMember(int n) {
        RankedList rankedList = this.fEr.getRankedList();
        return new DefaultRankedFeature(rankedList.getRankName(n), n, rankedList.getScore(n));
    }

    @Override
    public final GeneSet getAsGeneSet() {
        if (this.fCoreGeneSet == null) {
            RankedList rankedList = this.fEr.getRankedList();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i2 = 0; i2 < this.fCoreRanks.size(); ++i2) {
                hashSet.add(rankedList.getRankName(this.fCoreRanks.get(i2)));
            }
            this.fCoreGeneSet = new FSet(this.getName(), hashSet);
        }
        return this.fCoreGeneSet;
    }

    @Override
    public final int getRankAtMax() {
        float f2 = this.fEr.getScore().getES();
        if (XMath.isPositive(f2)) {
            return this.fEr.getScore().getRankAtES();
        }
        return this.fEr.getRankedList().getSize() - this.fEr.getScore().getRankAtES();
    }

    @Override
    public final float getMetricAtMax() {
        return this.fEr.getRankedList().getScore(this.getRankAtMax());
    }

    @Override
    public final float getTagFraction() {
        return (float)this.getSize() / (float)this.fEr.getGeneSet().getNumMembers();
    }

    @Override
    public final float getListFraction() {
        return (float)this.getRankAtMax() / (float)this.fEr.getRankedList().getSize();
    }

    @Override
    public final float getSignalStrength() {
        float f2 = this.getTagFraction();
        float f3 = this.getListFraction();
        float f4 = f2 / (1.0f - f3);
        float f5 = this.fEr.getRankedList().getSize();
        float f6 = this.fEr.getGeneSet().getNumMembers();
        float f7 = f5 / (f5 - f6);
        return f4 / f7;
    }
}

