/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import org.apache.log4j.Logger;

public class DefaultMetricWeightStruc
implements MetricWeightStruc {
    private float fTotalPosWeight;
    private float fTotalNegWeight;
    private int fTotalPosLength;
    private int fTotalNegLength;
    private String fMetricName;
    private static final Logger klog = XLogger.getLogger(DefaultMetricWeightStruc.class);

    public DefaultMetricWeightStruc(String string, RankedList rankedList) {
        if (rankedList == null) {
            throw new IllegalArgumentException("Param rl cannot be null");
        }
        this.fMetricName = string;
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            float f2 = rankedList.getScore(i2);
            if (XMath.isNegative(f2)) {
                this.fTotalNegWeight += f2;
                ++this.fTotalNegLength;
                continue;
            }
            this.fTotalPosWeight += f2;
            ++this.fTotalPosLength;
        }
    }

    public DefaultMetricWeightStruc(String string, LabelledVector labelledVector) {
        if (labelledVector == null) {
            throw new IllegalArgumentException("Param lv cannot be null");
        }
        for (int i2 = 0; i2 < labelledVector.getSize(); ++i2) {
            float f2 = labelledVector.getScore(i2);
            if (XMath.isNegative(f2)) {
                this.fTotalNegWeight += f2;
                ++this.fTotalNegLength;
                continue;
            }
            this.fTotalPosWeight += f2;
            ++this.fTotalPosLength;
        }
        this.fMetricName = string;
    }

    public DefaultMetricWeightStruc(String string, Vector vector) {
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f2 = vector.getElement(i2);
            if (XMath.isNegative(f2)) {
                this.fTotalNegWeight += f2;
                ++this.fTotalNegLength;
                continue;
            }
            this.fTotalPosWeight += f2;
            ++this.fTotalPosLength;
        }
        this.fMetricName = string;
    }

    @Override
    public final String getMetricName() {
        return this.fMetricName;
    }

    @Override
    public final void setMetricName(String string) {
        if (this.fMetricName != null) {
            klog.warn("Overwriting metric: " + this.fMetricName + " with: " + string);
            TraceUtils.showTrace();
        }
        this.fMetricName = string;
    }

    @Override
    public final float getTotalPosWeight() {
        return this.fTotalPosWeight;
    }

    @Override
    public final float getTotalNegWeight() {
        return this.fTotalNegWeight;
    }

    @Override
    public final int getTotalPosLength() {
        return this.fTotalPosLength;
    }

    @Override
    public final int getTotalNegLength() {
        return this.fTotalNegLength;
    }

    @Override
    public final float getDeltaWeight() {
        return this.getTotalPosWeight() - Math.abs(this.getTotalNegWeight());
    }

    @Override
    public final float getDeltaLength() {
        return this.getTotalPosLength() - this.getTotalNegLength();
    }

    @Override
    public final float getTotalWeight() {
        return this.getTotalPosWeight() + Math.abs(this.getTotalNegWeight());
    }

    @Override
    public final float getDeltaWeight_frac() {
        return Math.abs(this.getDeltaWeight() / this.getTotalWeight());
    }

    @Override
    public final float getDeltaLength_frac() {
        return Math.abs(this.getDeltaLength() / (float)this.getTotalLength());
    }

    @Override
    public final int getTotalLength() {
        return this.getTotalPosLength() + this.getTotalNegLength();
    }

    @Override
    public final float getTotalNegLength_frac() {
        return (float)this.getTotalNegLength() / (float)this.getTotalLength();
    }

    @Override
    public final float getTotalPosLength_frac() {
        return (float)this.getTotalPosLength() / (float)this.getTotalLength();
    }

    @Override
    public final float getTotalNegWeight_frac() {
        return Math.abs(this.getTotalNegWeight() / this.getTotalWeight());
    }

    @Override
    public final float getTotalPosWeight_frac() {
        return this.getTotalPosWeight() / this.getTotalWeight();
    }
}

