/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.DatasetModed;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.FdrStruc;

public class SkewCorrectedFdrStruc
implements FdrStruc {
    private String name;
    private float nominalP;
    private float realScore;
    private float realScoreNorm;
    private float fdr;
    private int totRealCnt;
    private int totRndCnt;
    private int moreRealThan;
    public int numSetsUsed;
    private float numr;
    private float denr;
    private int moreRndThan;
    public int totRndCnt_used;

    public SkewCorrectedFdrStruc(String string, float f2, RankedList rankedList, Vector vector, DatasetModed datasetModed, DatasetModed datasetModed2, boolean bl) {
        float f3;
        float f4;
        if (vector == null) {
            throw new IllegalArgumentException("Param rnd_scores_of_name_only cannot be null");
        }
        if (datasetModed == null) {
            throw new IllegalArgumentException("Param all_rnd_scores_norm_by_col_pos cannot be null");
        }
        if (datasetModed2 == null) {
            throw new IllegalArgumentException("Param all_rnd_scores_norm_by_col_neg cannot be null");
        }
        if (datasetModed.getNumCol() != datasetModed2.getNumCol()) {
            throw new MismatchedSizeException("num_cols pos", datasetModed.getNumCol(), "num cols neg", datasetModed2.getNumCol());
        }
        if (vector.getSize() != datasetModed.getNumCol()) {
            throw new MismatchedSizeException("calc_all", vector.getSize(), "num_col", datasetModed.getNumCol());
        }
        if (vector.getSize() != datasetModed2.getNumCol()) {
            throw new MismatchedSizeException("calc_all", vector.getSize(), "num_col", datasetModed2.getNumCol());
        }
        float f5 = rankedList.getScore(string);
        boolean bl2 = XMath.isPositive(f2);
        float f6 = bl2 ? (float)XMath.getPValue(f2, vector) : (float)XMath.getPValueLessThan(f2, vector);
        int n = rankedList.getRank(string) + 1;
        int n2 = rankedList.getSize();
        float f7 = datasetModed.getNumCol();
        float f8 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while ((float)n6 < f7) {
            Vector vector2;
            if (bl2) {
                vector2 = datasetModed.getColumn_sorted(n6);
                f4 = vector2.getSize();
                f3 = XMath.getMoreThanCount(f5, vector2);
            } else {
                vector2 = datasetModed2.getColumn_sorted(n6);
                f4 = vector2.getSize();
                f3 = XMath.getLessThanCount(f5, vector2);
            }
            n3 = (int)((float)n3 + f4);
            n4 = (int)((float)n4 + f3);
            if (f4 != 0.0f) {
                float f9 = f3 / f4;
                if (Float.isNaN(f9)) {
                    System.out.println("col_mean: " + f9 + " moreOrLessThan: " + f3 + " size: " + f4 + " pos: " + bl2);
                    throw new IllegalArgumentException();
                }
                f8 += f9;
                ++n5;
            }
            ++n6;
        }
        float f10 = f8 / (float)n5;
        f3 = bl2 ? (float)rankedList.getSize(ScoreMode.POS_ONLY) : (float)rankedList.getSize(ScoreMode.NEG_ONLY);
        f4 = (float)n / f3;
        float f11 = f10 / f4;
        if (!bl || !bl2) {
            if (bl && !bl2) {
                f11 = 1.0f;
            } else if (bl2) {
                f11 = 1.0f;
            }
        }
        this.init(string, f2, f5, f6, (int)f3, n, n4, n2, n3, datasetModed.getDim_orig(), f11, f10, f4);
    }

    private void init(String string, float f2, float f3, float f4, int n, int n2, int n3, int n4, int n5, int n6, float f5, float f6, float f7) {
        this.name = string;
        this.realScore = f2;
        this.realScoreNorm = f3;
        this.moreRealThan = n2;
        this.nominalP = f4;
        this.totRealCnt = n4;
        this.totRndCnt = n6;
        this.fdr = f5;
        this.moreRndThan = n3;
        this.totRndCnt_used = n5;
        this.numSetsUsed = n;
        this.denr = f7;
        this.numr = f6;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final float getRealScore() {
        return this.realScore;
    }

    @Override
    public final float getRealNormalizedScore() {
        return this.realScoreNorm;
    }

    @Override
    public final int getMoreRndThanCnt() {
        return this.moreRndThan;
    }

    @Override
    public final int getMoreRealThanCnt() {
        return this.moreRealThan;
    }

    @Override
    public final float getNumr() {
        return this.numr;
    }

    @Override
    public final float getDenr() {
        return this.denr;
    }

    @Override
    public final float getFdr() {
        return this.fdr;
    }

    @Override
    public final int getTotalRealCnt() {
        return this.totRealCnt;
    }

    @Override
    public final int getTotalRndCnt() {
        return this.totRndCnt;
    }

    public final float getNominalPValue() {
        return this.nominalP;
    }

    @Override
    public final float getTotalRndSkew() {
        throw new NotImplementedException();
    }
}

