/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.FileInMemoryChip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.chip.SimpleProbe;
import edu.mit.broad.vdb.chip.SimpleProbe2;
import edu.mit.broad.vdb.chip.SimpleProbe3;
import edu.mit.broad.vdb.meg.AliasDb;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ChipParser
extends AbstractParser {
    private static final String PROBE_SET_ID = "Probe Set ID";
    private static final String GENE_TITLE = "Gene Title";
    private static final String GENE_SYMBOL = "Gene Symbol";
    private static final String ALIASES = "Aliases";
    private static final String TAXON = "Taxon ID";

    public ChipParser() {
        super(Chip.class);
    }

    public static final void export_gene_symbol_chip(Gene[] geneArray, File file) {
        int n;
        String[] stringArray = new String[]{PROBE_SET_ID, GENE_SYMBOL, GENE_TITLE, ALIASES};
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < geneArray.length; ++n) {
            Gene gene = geneArray[n];
            String string = gene.getSymbol();
            String string2 = gene.getTitle();
            Set set = gene.getAliases();
            printWriter.print(string);
            printWriter.print('\t');
            printWriter.print(string);
            printWriter.print('\t');
            printWriter.print(string2);
            printWriter.print('\t');
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                stringBuffer.append(e2.toString().toUpperCase());
                if (!iterator.hasNext()) continue;
                stringBuffer.append('\u001c');
            }
            printWriter.print(stringBuffer.toString());
            printWriter.println();
        }
        printWriter.close();
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        this.export((Chip)persistentObject, file, true);
    }

    public final void export(Chip chip, File file, boolean bl) {
        int n;
        String[] stringArray = bl ? new String[]{PROBE_SET_ID, GENE_SYMBOL, GENE_TITLE} : new String[]{PROBE_SET_ID, GENE_SYMBOL};
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            if (n == stringArray.length) continue;
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < chip.getNumProbes(); ++n) {
            Probe probe = chip.getProbe(n);
            printWriter.print(probe.getName());
            printWriter.print('\t');
            Gene gene = probe.getGene();
            String string = null;
            String string2 = null;
            if (gene != null) {
                string = gene.getSymbol();
                string2 = gene.getTitle();
            }
            if (string == null) {
                string = "NULL";
            }
            if (string2 == null) {
                string2 = "NULL";
            }
            printWriter.print(string);
            if (bl) {
                printWriter.print('\t');
                printWriter.print(string2);
            }
            printWriter.println();
        }
        printWriter.close();
        this.doneExport();
    }

    public final void export(Chip chip, File file) {
        int n;
        String[] stringArray = new String[]{PROBE_SET_ID, GENE_SYMBOL, GENE_TITLE};
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < chip.getNumProbes(); ++n) {
            Probe probe = chip.getProbe(n);
            printWriter.print(probe.getName());
            printWriter.print('\t');
            Gene gene = probe.getGene();
            String string = null;
            String string2 = null;
            if (gene != null) {
                string = gene.getSymbol();
                string2 = gene.getTitle();
            }
            if (string == null) {
                string = "NULL";
            }
            if (string2 == null) {
                string2 = "NULL";
            }
            printWriter.print(string);
            printWriter.print('\t');
            printWriter.print(string2);
            printWriter.println();
        }
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        String string2 = string.toUpperCase();
        if (string2.indexOf("UNIGENE") != -1 || string2.indexOf("GENE_SYMBOL") != -1) {
            return this._parse_from_unigene_or_gene_symbol(string, inputStream);
        }
        if (string2.indexOf("SEQ_ACCESSION") != -1) {
            return this._parse_from_seq_accession(string, inputStream);
        }
        if (string.endsWith("chip")) {
            return this._parse_from_dot_chip(string, inputStream);
        }
        if (string.endsWith("csv")) {
            return this._parse_from_csv(string, inputStream);
        }
        throw new IllegalArgumentException("Unknown chip file type for parsing: " + string);
    }

    private List _parse_from_csv(String string, InputStream inputStream) {
        Object object;
        Object[] objectArray;
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList_csv(string2);
        int n = ChipParser.indexOf(PROBE_SET_ID, list, true);
        int n2 = ChipParser.indexOf(GENE_SYMBOL, list, true);
        int n3 = ChipParser.indexOf(GENE_TITLE, list, true);
        THashSet tHashSet = new THashSet();
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            objectArray = ParseUtils.string2strings_csv(string2);
            object = objectArray[n2];
            String string3 = objectArray[n3];
            object = NamingConventions.symbolize((String)object);
            if (string3.equals("---")) {
                string3 = null;
            }
            SimpleProbe simpleProbe = new SimpleProbe((String)objectArray[n], (String)object, string3);
            tHashSet.add(simpleProbe);
            string2 = this.nextLine(bufferedReader);
        }
        objectArray = tHashSet.toArray((T[])new Probe[tHashSet.size()]);
        object = new FileInMemoryChip(FileUtils.removePath(string), string, (Probe[])objectArray);
        bufferedReader.close();
        this.doneImport();
        return ChipParser.unmodlist((PersistentObject)object);
    }

    private boolean isSymbolProbes(String string) {
        return string.indexOf("Gene_Symbol") != -1;
    }

    private List _parse_from_unigene_or_gene_symbol(String string, InputStream inputStream) {
        Object[] objectArray;
        this.startImport(string);
        boolean bl = this.isSymbolProbes(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        int n = ChipParser.indexOf(PROBE_SET_ID, list, true);
        int n2 = ChipParser.indexOf(GENE_SYMBOL, list, true);
        int n3 = ChipParser.indexOf(GENE_TITLE, list, true);
        int n4 = ChipParser.indexOf(ALIASES, list, false);
        ArrayList<SimpleProbe3> arrayList = new ArrayList<SimpleProbe3>();
        string2 = this.nextLine(bufferedReader);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (string2 != null) {
            objectArray = ParseUtils.string2stringsV2(string2);
            if (objectArray.length != 3 && objectArray.length != 4) {
                throw new ParserException("Bad format expecting 3 or 4 fields but found: " + objectArray.length + "\nOn line >" + string2 + "<");
            }
            String string3 = objectArray[n];
            if (bl) {
                string3 = NamingConventions.symbolize(string3);
            }
            if (string3 != null && !hashSet.contains(string3)) {
                Object object = objectArray[n2];
                Object object2 = objectArray[n3];
                object = NamingConventions.symbolize((String)object);
                if (object2 != null && ((String)object2).equals("---")) {
                    object2 = null;
                }
                Set set = null;
                if (n4 != -1 && n4 < objectArray.length) {
                    set = ParseUtils.string2stringsSet((String)objectArray[n4], "\u001c", false);
                }
                SimpleProbe3 simpleProbe3 = new SimpleProbe3((String)object, (String)object2, set);
                arrayList.add(simpleProbe3);
                hashSet.add(object);
            }
            string2 = this.nextLine(bufferedReader);
        }
        objectArray = arrayList.toArray(new SimpleProbe3[arrayList.size()]);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((SimpleProbe3)objectArray[i2]).removeAnyAliasesThatMatch(hashSet);
        }
        FileInMemoryChip fileInMemoryChip = new FileInMemoryChip(FileUtils.removePath(string), string, (Probe[])objectArray);
        bufferedReader.close();
        this.log.info("Parsed from unigene / gene symbol: " + objectArray.length);
        this.doneImport();
        return ChipParser.unmodlist(fileInMemoryChip);
    }

    private List _parse_from_dot_chip(String string, InputStream inputStream) {
        Object object;
        Object[] objectArray;
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        int n = ChipParser.indexOf(PROBE_SET_ID, list, true);
        int n2 = ChipParser.indexOf(GENE_SYMBOL, list, true);
        int n3 = ChipParser.indexOf(GENE_TITLE, list, true);
        ArrayList<SimpleProbe> arrayList = new ArrayList<SimpleProbe>();
        string2 = this.nextLine(bufferedReader);
        HashSet<String> hashSet = new HashSet<String>();
        while (string2 != null) {
            objectArray = ParseUtils.string2strings(string2, "\t", true);
            object = objectArray[n];
            if (object != null && !hashSet.contains(object)) {
                Object object2 = objectArray[n2];
                object2 = NamingConventions.symbolize((String)object2);
                Object object3 = null;
                try {
                    object3 = objectArray[n3];
                    if (object3 != null && ((String)object3).equals("---")) {
                        object3 = null;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SimpleProbe simpleProbe = new SimpleProbe((String)object, (String)object2, (String)object3);
                arrayList.add(simpleProbe);
            }
            if (object != null) {
                hashSet.add((String)object);
            }
            string2 = this.nextLine(bufferedReader);
        }
        objectArray = arrayList.toArray(new Probe[arrayList.size()]);
        object = new FileInMemoryChip(FileUtils.removePath(string), string, (Probe[])objectArray);
        bufferedReader.close();
        this.log.info("Parsed from dotchip : " + objectArray.length);
        this.doneImport();
        return ChipParser.unmodlist((PersistentObject)object);
    }

    private List _parse_from_seq_accession(String string, InputStream inputStream) {
        Object object;
        Probe[] probeArray;
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        int n = ChipParser.indexOf(PROBE_SET_ID, list, true);
        int n2 = ChipParser.indexOf(GENE_SYMBOL, list, true);
        Chip chip = VdbRuntimeResources.getChip_Gene_Symbol();
        ArrayList<Probe> arrayList = new ArrayList<Probe>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < chip.getNumProbes(); ++i2) {
            arrayList.add(chip.getProbe(i2));
            hashSet.add(chip.getProbe(i2).getName());
        }
        this.log.debug("# of seq probes (from symbol): " + arrayList.size());
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            String[] stringArray = ParseUtils.string2strings(string2, "\t", true);
            probeArray = NamingConventions.symbolize(stringArray[n2]);
            String string3 = stringArray[n];
            if (!hashSet.contains(string3)) {
                hashSet.add(string3);
                object = new SimpleProbe2(string3, (String)probeArray, chip);
                arrayList.add((Probe)object);
            }
            string2 = this.nextLine(bufferedReader);
        }
        this.log.debug("# of seq probes: " + arrayList.size());
        AliasDb aliasDb = VdbRuntimeResources.getAliasDb();
        probeArray = aliasDb.getAliasesAsProbes();
        for (int i3 = 0; i3 < probeArray.length; ++i3) {
            if (hashSet.contains(probeArray[i3].getName())) continue;
            arrayList.add(probeArray[i3]);
        }
        this.log.debug("FINAL # of seq probes: " + arrayList.size());
        Probe[] probeArray2 = arrayList.toArray(new Probe[arrayList.size()]);
        object = new FileInMemoryChip(FileUtils.removePath(string), string, probeArray2);
        bufferedReader.close();
        this.log.info("Parser from Seq_Accession: " + probeArray2.length);
        this.doneImport();
        return ChipParser.unmodlist((PersistentObject)object);
    }
}

