/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.PreTemplateImpl;
import edu.mit.broad.genome.objects.PreTemplateImpl$NumPair;
import edu.mit.broad.genome.objects.PreTemplateImpl$Pair;
import edu.mit.broad.genome.objects.PreTemplateImpl$StringPair;
import edu.mit.broad.genome.objects.ProbePreTemplate;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImpl$ClassImpl;
import edu.mit.broad.genome.objects.TemplateImpl$ItemImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.utils.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class ClsParser
extends AbstractParser
implements Constants {
    private int[] fHdrInts;
    private int fItemCnt;

    public ClsParser() {
        super(Template.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        PrintWriter printWriter = this.startExport(persistentObject, file);
        printWriter.println(((Template)persistentObject).getAsString(false));
        printWriter.close();
        this.doneExport();
    }

    public final void export(PersistentObject persistentObject, boolean bl, File file) {
        PrintWriter printWriter = this.startExport(persistentObject, file);
        printWriter.println(((Template)persistentObject).getAsString(bl));
        printWriter.close();
        this.doneExport();
    }

    private boolean isNumericLine(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No content in cls file");
        }
        boolean bl = (string = string.trim()).equalsIgnoreCase("#numeric");
        if (!bl) {
            bl = string.equalsIgnoreCase("# numeric");
        }
        return bl;
    }

    private boolean isProbesLine(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No content in cls file");
        }
        string = string.trim();
        return string.equalsIgnoreCase("#probes");
    }

    private List parseContinuousTemplate(String string, BufferedReader bufferedReader) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.nextNonEmptyLine(bufferedReader);
        while (string2 != null) {
            if (string2.startsWith("#")) {
                object = this.nextNonEmptyLine(bufferedReader);
                if (object == null) {
                    throw new ParserException("Bad cls data format - missing profile line for: " + string2);
                }
                if (((String)object).length() == 0 || ((String)object).startsWith("#")) {
                    throw new ParserException("Bad cls data format - missing profile line for: " + string2);
                }
                hashMap.put(string2, object);
            }
            string2 = this.nextNonEmptyLine(bufferedReader);
        }
        object = hashMap.keySet().iterator();
        ArrayList<Template> arrayList = new ArrayList<Template>();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            String string4 = (String)hashMap.get(string3);
            float[] fArray = ParseUtils.string2floats(string4);
            string3 = string3.substring(1, string3.length());
            Template template = TemplateFactory.createContinuousTemplate(string + "#" + string3, new Vector(fArray));
            arrayList.add(template);
        }
        this.log.info("Completed parsing NUMERIC CLS file");
        return Collections.unmodifiableList(arrayList);
    }

    private List parseProbeTemplate(String string, BufferedReader bufferedReader) {
        String string2 = this.nextNonEmptyLine(bufferedReader);
        ArrayList<ProbePreTemplate> arrayList = new ArrayList<ProbePreTemplate>();
        while (string2 != null) {
            arrayList.add(new ProbePreTemplate(string, string2));
            string2 = this.nextNonEmptyLine(bufferedReader);
        }
        return arrayList;
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextNonEmptyLine(bufferedReader);
        if (string2 == null) {
            throw new ParserException("Bad format for cls fike - check lines 1 and 2 --- they seem to have no content");
        }
        if (this.isProbesLine(string2)) {
            return this.parseProbeTemplate(string, bufferedReader);
        }
        if (this.isNumericLine(string2)) {
            return this.parseContinuousTemplate(string, bufferedReader);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
        boolean bl = false;
        try {
            if (stringTokenizer.countTokens() == 3) {
                Float.parseFloat(stringTokenizer.nextToken());
                Float.parseFloat(stringTokenizer.nextToken());
                Float.parseFloat(stringTokenizer.nextToken());
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl) {
            return this._parse_genecluster_style_categorical(string, bufferedReader, string2);
        }
        return this._parse_new_style(string, bufferedReader, string2);
    }

    private List _parse_genecluster_style_categorical(String string, BufferedReader bufferedReader, String string2) {
        String string3 = string2;
        boolean bl = false;
        this.fHdrInts = this.parseHeaderLine(string3);
        string3 = this.nextNonEmptyLine(bufferedReader);
        Template$Class[] template$ClassArray = this.generateClasses(string3);
        string3 = this.nextLine(bufferedReader);
        Template$Item[] template$ItemArray = this.generateItems(string3);
        Template template = TemplateFactory.createTemplate(string, template$ItemArray, template$ClassArray, bl);
        template.addComment(this.fComment.toString());
        this.doSanityChecks(template);
        this.doneImport();
        return ClsParser.unmodlist(template);
    }

    private List _parse_new_style(String string, BufferedReader bufferedReader, String string2) {
        StringDataframe stringDataframe = new StringDataframeParser().parseSdf(string, bufferedReader, string2);
        String[] stringArray = stringDataframe.getRowNamesArray();
        ArrayList<PreTemplateImpl> arrayList = new ArrayList<PreTemplateImpl>();
        for (int i2 = 0; i2 < stringDataframe.getNumCol(); ++i2) {
            String string3 = stringDataframe.getColumnName(i2);
            if (string3 == null || string3.length() == 0) {
                throw new ParserException("Bad column identifier (it was null or empty) >" + string3 + "< at column: " + (i2 + 1));
            }
            if (ClsParser.isCommentColumn(string3)) continue;
            if (ClsParser.isNumericColumn(string3)) {
                arrayList.add(ClsParser._createNumericPreTemplate(string, string3, stringArray, stringDataframe.getColumn(i2)));
                continue;
            }
            arrayList.add(ClsParser._createCategoricalPreTemplate(string, string3, stringArray, stringDataframe.getColumn(i2)));
        }
        this.doneImport();
        return arrayList;
    }

    private int[] parseHeaderLine(String string) {
        char c2 = ParseUtils.getDelim(string);
        int[] nArray = new int[3];
        try {
            ParseUtils.splitIntegers(string, c2, nArray);
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException);
        }
        if (nArray.length != 3) {
            throw new ParserException("Missing data in header " + string + " found only " + nArray.length + " fields .. expecting 3");
        }
        return nArray;
    }

    private Template$Class[] generateClasses(String string) {
        if (string.startsWith("#")) {
            string = string.substring(1, string.length());
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            Template$Class[] template$ClassArray = new Template$Class[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                template$ClassArray[n++] = new TemplateImpl$ClassImpl(stringTokenizer.nextToken().trim());
            }
            return template$ClassArray;
        }
        throw new ParserException("Bad format in cls file - expected the line to be of the form '# foo bar ...'");
    }

    private Template$Item[] generateItems(String string) {
        this.fItemCnt = 0;
        if (string == null) {
            throw new NullPointerException("Bad cls data format -- check the item descriptor line (line 2)");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        Template$Item[] template$ItemArray = new Template$Item[stringTokenizer.countTokens()];
        if (!this.isSilentMode()) {
            this.log.debug("# of items = " + stringTokenizer.countTokens());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            template$ItemArray[this.fItemCnt] = TemplateImpl$ItemImpl.createItem(string2, this.fItemCnt);
            ++this.fItemCnt;
        }
        return template$ItemArray;
    }

    private void doSanityChecks(Template template) {
        if (template.getNumItems() != this.fHdrInts[0]) {
            throw new ParserException("Number of items found in cls data " + this.fItemCnt + " is not equal to the number specified on the header line " + this.fHdrInts[0]);
        }
        if (template.getNumClasses() != this.fHdrInts[1]) {
            throw new ParserException("Number of classes found in cls data " + template.getNumClasses() + " is not equal to the number of classes specified on the header line " + this.fHdrInts[1]);
        }
    }

    private static PreTemplateImpl _createNumericPreTemplate(String string, String string2, String[] stringArray, String[] stringArray2) {
        ArrayList<PreTemplateImpl$NumPair> arrayList = new ArrayList<PreTemplateImpl$NumPair>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray2[i2] == null) continue;
            arrayList.add(new PreTemplateImpl$NumPair(stringArray[i2], stringArray2[i2]));
        }
        return new PreTemplateImpl(string, string2, arrayList.toArray(new PreTemplateImpl$Pair[arrayList.size()]), true);
    }

    private static PreTemplateImpl _createCategoricalPreTemplate(String string, String string2, String[] stringArray, String[] stringArray2) {
        ArrayList<PreTemplateImpl$StringPair> arrayList = new ArrayList<PreTemplateImpl$StringPair>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray2[i2] == null) continue;
            arrayList.add(new PreTemplateImpl$StringPair(stringArray[i2], stringArray2[i2]));
        }
        return new PreTemplateImpl(string, string2, arrayList.toArray(new PreTemplateImpl$Pair[arrayList.size()]), false);
    }

    private static boolean isCommentColumn(String string) {
        return string.equalsIgnoreCase("COMMENT") || string.equalsIgnoreCase("COMMENTS");
    }

    private static boolean isNumericColumn(String string) {
        return string.equalsIgnoreCase("NUMERIC") || string.equalsIgnoreCase("FLOAT");
    }
}

