/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DChipDatasetParser
extends AbstractParser {
    public DChipDatasetParser() {
        super(Dataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        int n;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        Dataset dataset = (Dataset)persistentObject;
        FeatureAnnot featureAnnot = dataset.getAnnot().getFeatureAnnot();
        printWriter.print("NAME\t");
        printWriter.print("DESCRIPTION\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print(dataset.getColumnName(n));
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataset.getNumRow(); ++n) {
            String string = dataset.getRowName(n);
            printWriter.print(string);
            printWriter.print('\t');
            printWriter.print(featureAnnot.getNativeDesc(string));
            printWriter.print('\t');
            printWriter.println(dataset.getRow(n).toString('\t'));
        }
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.startImport(string);
        int n = FileUtils.countLines(string, true);
        int n2 = n - 1;
        this.log.debug("Number of float lines = " + n2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, " \t");
        int n3 = list.size();
        list.remove(0);
        list.remove(0);
        this.log.debug("Number of columns = " + list.size());
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        Matrix matrix = new Matrix(n2, list.size());
        int n4 = 0;
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            object4 = ParseUtils.string2stringsList(string2, "\t");
            if (object4.size() != n3) {
                throw new ParserException("Invalid format on line: " + string2 + " expected # fields = " + n3 + " but found: " + object4.size());
            }
            object3 = (String)object4.get(0);
            arrayList.add(((String)object3).trim());
            object2 = (String)object4.get(1);
            arrayList2.add(((String)object2).trim());
            object = object4.subList(2, object4.size());
            if (object.size() != list.size()) {
                throw new ParserException("# of floats: " + object.size() + " on line: " + n4 + " not equal to # of columns in header: " + list.size());
            }
            for (int i2 = 0; i2 < object.size(); ++i2) {
                matrix.setElement(n4, i2, Float.parseFloat((String)object.get(i2)));
            }
            ++n4;
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        object4 = new File(string).getName();
        object3 = new FeatureAnnotImpl((String)object4, arrayList, arrayList2);
        object2 = new SampleAnnotImpl((String)object4, list, null);
        object3.addComment(this.fComment.toString());
        object = new DefaultDataset((String)object4, matrix, arrayList, list, true, (Annot)new AnnotImpl((FeatureAnnot)object3, (SampleAnnot)object2));
        object.addComment(this.fComment.toString());
        this.doneImport();
        return DChipDatasetParser.unmodlist(new PersistentObject[]{object});
    }
}

