/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListJITImpl;
import edu.mit.broad.genome.objects.ScoredDatasetImpl;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImpl_one_shared_rl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResultImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScoreImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.EdbFolderParser$Struc;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class EdbFolderParser
extends AbstractParser {
    private static final char DELIM = ' ';
    private static final String EDB = "EDB";
    private static final String DTG = "DTG";
    private static final String ES = "ES";
    private static final String RND_ES = "RND_ES";
    private static final String NP = "NP";
    private static final String FDR = "FDR";
    private static final String NES = "NES";
    private static final String FWER = "FWER";
    private static final String CHIP = "CHIP";
    private static final String HIT_INDICES = "HIT_INDICES";
    private static final String RANK_AT_ES = "RANK_AT_ES";
    private static final String RANK_SCORE_AT_ES = "RANK_SCORE_AT_ES";
    private static final String ES_PROFILE = "ES_PROFILE";
    private static final String EDB_FILE_NAME = "results.edb";
    private Map fPobidFileMap;
    private Map rankedListNameRankedListObject;

    public EdbFolderParser() {
        super(EnrichmentDb.class);
    }

    protected final EnrichmentDbImpl_one_shared_rl parseEdb(File file) {
        EnrichmentResult[] enrichmentResultArray;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        File file2 = EdbFolderParser._getEdbDir(file);
        File file3 = new File(file2, EDB_FILE_NAME);
        if (!file3.exists()) {
            throw new IllegalArgumentException("edb file not found: " + file3);
        }
        FileInputStream fileInputStream = new FileInputStream(file3);
        SAXReader sAXReader = new SAXReader();
        Document document = sAXReader.read(fileInputStream);
        Element element = document.getRootElement();
        LabelledVectorProcessor labelledVectorProcessor = LabelledVectorProcessors.lookupProcessor(element.attribute("LC_PROC").getValue());
        SortMode sortMode = SortMode.lookup(element.attribute("SORT_MODE").getValue());
        Order order = Order.lookup(element.attribute("ORDER").getValue());
        Metric metric = Metrics.lookupMetric(element.attribute("METRIC").getValue());
        int n = Integer.parseInt(element.attribute("NUM_PERMS").getValue());
        ArrayList<EnrichmentResultImpl> arrayList = new ArrayList<EnrichmentResultImpl>();
        int n2 = 0;
        Object object2 = element.elementIterator(DTG);
        while (object2.hasNext()) {
            object = (Element)object2.next();
            serializable2 = null;
            try {
                serializable2 = ParserFactory.readTemplate(EdbFolderParser._toFile("TEMPLATE", (Element)object, file2), true, false, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            serializable = ParserFactory.readGeneSet(EdbFolderParser._toFile("GENESET", (Element)object, file2), true, false);
            enrichmentResultArray = this._readRankedList((Element)object, file2);
            float f2 = Float.parseFloat(object.attribute(ES).getValue());
            float f3 = Float.parseFloat(object.attribute(NES).getValue());
            float f4 = Float.parseFloat(object.attribute(NP).getValue());
            float f5 = Float.parseFloat(object.attribute(FDR).getValue());
            float f6 = Float.parseFloat(object.attribute(FWER).getValue());
            float f7 = Float.parseFloat(object.attribute(RANK_SCORE_AT_ES).getValue());
            int n3 = (int)Float.parseFloat(object.attribute(RANK_AT_ES).getValue());
            Vector vector = EdbFolderParser._toVectorReqd(RND_ES, (Element)object);
            Vector vector2 = EdbFolderParser._toVectorReqd(ES_PROFILE, (Element)object);
            int[] nArray = ParseUtils.string2ints(object.attribute(HIT_INDICES).getValue(), ' ');
            Chip chip = null;
            Attribute attribute = object.attribute(CHIP);
            if (attribute != null && attribute.getValue() != null && attribute.getValue().length() > 0) {
                chip = VdbRuntimeResources.getChip(attribute.getValue());
            }
            EnrichmentScoreImpl enrichmentScoreImpl = new EnrichmentScoreImpl(f2, n3, f7, f3, f4, f5, f6, nArray.length, nArray, vector2, null);
            arrayList.add(new EnrichmentResultImpl((RankedList)enrichmentResultArray, (Template)serializable2, (GeneSet)serializable, chip, enrichmentScoreImpl, vector));
            if (n2 % 500 == 0) {
                System.out.println("read in from edb dtg: " + (n2 + 1));
            }
            ++n2;
        }
        object2 = new HashMap();
        object = EdbFolderParser._boolean(element, "USE_MEDIAN");
        if (object != null) {
            object2.put("USE_MEDIAN", object);
        }
        if ((serializable2 = EdbFolderParser._boolean(element, "FIX_LOW")) != null) {
            object2.put("FIX_LOW", serializable2);
        }
        if ((serializable = EdbFolderParser._boolean(element, "USE_BIASED")) != null) {
            object2.put("USE_BIASED", serializable);
        }
        enrichmentResultArray = arrayList.toArray(new EnrichmentResult[arrayList.size()]);
        EnrichmentDbImpl_one_shared_rl enrichmentDbImpl_one_shared_rl = new EnrichmentDbImpl_one_shared_rl(NamingConventions.removeExtension(file3.getName()), enrichmentResultArray, null, labelledVectorProcessor, metric, (Map)object2, sortMode, order, n, file);
        enrichmentDbImpl_one_shared_rl.addComment(this.fComment.toString());
        this.doneImport();
        return enrichmentDbImpl_one_shared_rl;
    }

    public final EnrichmentDbImpl_one_shared_rl parseEdb_just(File file, File file2, GeneSetMatrix geneSetMatrix, Dataset dataset) {
        Object object;
        EnrichmentResult[] enrichmentResultArray;
        Serializable serializable;
        Boolean bl;
        Object object2;
        FileInputStream fileInputStream = new FileInputStream(file);
        SAXReader sAXReader = new SAXReader();
        Document document = sAXReader.read(fileInputStream);
        Element element = document.getRootElement();
        LabelledVectorProcessor labelledVectorProcessor = LabelledVectorProcessors.lookupProcessor(element.attribute("LC_PROC").getValue());
        SortMode sortMode = SortMode.lookup(element.attribute("SORT_MODE").getValue());
        Order order = Order.lookup(element.attribute("ORDER").getValue());
        Metric metric = Metrics.lookupMetric(element.attribute("METRIC").getValue());
        int n = Integer.parseInt(element.attribute("NUM_PERMS").getValue());
        ArrayList<EnrichmentResultImpl> arrayList = new ArrayList<EnrichmentResultImpl>();
        int n2 = 0;
        Object object3 = element.elementIterator(DTG);
        while (object3.hasNext()) {
            object2 = (Element)object3.next();
            bl = null;
            serializable = geneSetMatrix.getGeneSet(object2.attribute("GENESET").getValue());
            enrichmentResultArray = new RankedListJITImpl(file2, true);
            object = dataset != null ? new ScoredDatasetImpl((RankedList)enrichmentResultArray, dataset) : enrichmentResultArray;
            float f2 = Float.parseFloat(object2.attribute(ES).getValue());
            float f3 = Float.parseFloat(object2.attribute(NES).getValue());
            float f4 = Float.parseFloat(object2.attribute(NP).getValue());
            float f5 = Float.parseFloat(object2.attribute(FDR).getValue());
            float f6 = Float.parseFloat(object2.attribute(FWER).getValue());
            float f7 = Float.parseFloat(object2.attribute(RANK_SCORE_AT_ES).getValue());
            int n3 = (int)Float.parseFloat(object2.attribute(RANK_AT_ES).getValue());
            Vector vector = EdbFolderParser._toVectorReqd(RND_ES, (Element)object2);
            Vector vector2 = EdbFolderParser._toVectorReqd(ES_PROFILE, (Element)object2);
            int[] nArray = ParseUtils.string2ints(object2.attribute(HIT_INDICES).getValue(), ' ');
            Chip chip = null;
            Attribute attribute = object2.attribute(CHIP);
            if (attribute != null && attribute.getValue() != null && attribute.getValue().length() > 0) {
                chip = VdbRuntimeResources.getChip(attribute.getValue());
            }
            EnrichmentScoreImpl enrichmentScoreImpl = new EnrichmentScoreImpl(f2, n3, f7, f3, f4, f5, f6, nArray.length, nArray, vector2, null);
            arrayList.add(new EnrichmentResultImpl((RankedList)object, (Template)((Object)bl), (GeneSet)serializable, chip, enrichmentScoreImpl, vector));
            if (n2 % 500 == 0) {
                System.out.println("read in from edb dtg: " + (n2 + 1));
            }
            ++n2;
        }
        object3 = new HashMap();
        object2 = EdbFolderParser._boolean(element, "USE_MEDIAN");
        if (object2 != null) {
            object3.put("USE_MEDIAN", object2);
        }
        if ((bl = EdbFolderParser._boolean(element, "FIX_LOW")) != null) {
            object3.put("FIX_LOW", bl);
        }
        if ((serializable = EdbFolderParser._boolean(element, "USE_BIASED")) != null) {
            object3.put("USE_BIASED", serializable);
        }
        enrichmentResultArray = arrayList.toArray(new EnrichmentResult[arrayList.size()]);
        object = new EnrichmentDbImpl_one_shared_rl(NamingConventions.removeExtension(file.getName()), enrichmentResultArray, null, labelledVectorProcessor, metric, (Map)object3, sortMode, order, n, null);
        ((AbstractObject)object).addComment(this.fComment.toString());
        this.doneImport();
        return object;
    }

    private static File _getEdbDir(File file) {
        File file2;
        if (!file.exists() || !file.isDirectory()) {
            throw new ParserException("Invalid gsea dir for parsing ... expecting a dir, got: " + file);
        }
        if (file.getName().equals("edb")) {
            file2 = file;
        } else {
            file2 = new File(file, "edb");
            if (!file2.exists()) {
                throw new IllegalArgumentException("edb dir not found: " + file2);
            }
        }
        return file2;
    }

    private static Vector _toVectorReqd(String string, Element element) {
        EdbFolderParser.barfIfMissing(string, element);
        return ParseUtils.string2Vector(element.attribute(string).getValue(), ' ');
    }

    private static void barfIfMissing(String string, Element element) {
        if (element.attribute(string).getValue() == null || element.attribute(string).getValue().length() == 0) {
            throw new ParserException("Missing attribute " + string + " in element: " + element.getName());
        }
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        EnrichmentDbImpl_one_shared_rl enrichmentDbImpl_one_shared_rl = this.parseEdb(new File(string));
        return EdbFolderParser.unmodlist(enrichmentDbImpl_one_shared_rl);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        boolean bl;
        boolean bl2;
        if (persistentObject == null) {
            throw new IllegalArgumentException("Param pob_edb cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Param foo cannot be null: " + file);
        }
        if (!file.exists() && !(bl2 = file.mkdir())) {
            throw new IllegalArgumentException("Could not make gsea result dir: " + file);
        }
        File file2 = new File(file, "edb");
        if (!file2.exists() && !(bl = file2.mkdir())) {
            throw new IllegalArgumentException("Could not make edb dir: " + file2);
        }
        this.export(persistentObject, file2, EDB_FILE_NAME, null, true, true);
    }

    public final void export(PersistentObject persistentObject, File file, String string, String string2, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        GeneSet geneSet;
        String string3;
        GeneSet geneSet2;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (persistentObject == null) {
            throw new IllegalArgumentException("Param pob_edb cannot be null");
        }
        EnrichmentDb enrichmentDb = (EnrichmentDb)persistentObject;
        EdbFolderParser$Struc edbFolderParser$Struc = new EdbFolderParser$Struc(enrichmentDb.getNumResults());
        if (bl2) {
            cloneable2 = new HashSet();
            cloneable = new ArrayList();
            for (int i2 = 0; i2 < enrichmentDb.getNumResults(); ++i2) {
                geneSet2 = enrichmentDb.getResult(i2).getGeneSet();
                string3 = geneSet2.getName(true);
                if (cloneable2.contains(string3)) continue;
                geneSet = geneSet2.cloneShallow(string3);
                cloneable.add(geneSet);
                cloneable2.add(string3);
            }
            object4 = new DefaultGeneSetMatrix("gene_sets", (List)((Object)cloneable));
            edbFolderParser$Struc.gmFile = NamingConventions.createSafeFile(file, object4.getName() + ".gmt");
            ParserFactory.saveGmt((GeneSetMatrix)object4, edbFolderParser$Struc.gmFile, false);
        } else {
            edbFolderParser$Struc.gmFile = new File(file, "gene_sets.gmt");
        }
        cloneable2 = DocumentHelper.createDocument();
        cloneable = cloneable2.addElement(EDB);
        cloneable.addAttribute("LC_PROC", enrichmentDb.getRankedListProcessor().toString());
        cloneable.addAttribute("SORT_MODE", enrichmentDb.getSortMode().toString());
        cloneable.addAttribute("ORDER", enrichmentDb.getOrder().toString());
        cloneable.addAttribute("METRIC", enrichmentDb.getMetric().toString());
        cloneable.addAttribute("NUM_PERMS", enrichmentDb.getNumPerm() + "");
        object4 = enrichmentDb.getMetricParams();
        geneSet2 = object4.get("USE_MEDIAN");
        if (geneSet2 != null) {
            cloneable.addAttribute("USE_MEDIAN", geneSet2.toString());
        }
        if ((string3 = object4.get("FIX_LOW")) != null) {
            cloneable.addAttribute("FIX_LOW", string3.toString());
        }
        if ((geneSet = object4.get("USE_BIASED")) != null) {
            cloneable.addAttribute("USE_BIASED", geneSet.toString());
        }
        for (int i3 = 0; i3 < enrichmentDb.getNumResults(); ++i3) {
            object3 = enrichmentDb.getResult(i3);
            object2 = object3.getScore();
            object = cloneable.addElement(DTG);
            String string4 = string2 != null ? EdbFolderParser._fixExt(string2, "rnk") : EdbFolderParser._fixExt(object3.getRankedList().getName(), "rnk");
            edbFolderParser$Struc.rankedListFiles[i3] = this.saveIfNeeded(string4, object3.getRankedList(), file);
            object.addAttribute("RANKED_LIST", string4);
            if (bl && object3.getTemplate() != null) {
                String string5 = AuxUtils.getBaseNameOnly(object3.getTemplate().getName());
                string4 = EdbFolderParser._fixExt(string5, "cls");
                edbFolderParser$Struc.templateFiles[i3] = this.saveIfNeeded(string4, object3.getTemplate(), file);
                object.addAttribute("TEMPLATE", string4);
            } else {
                object.addAttribute("TEMPLATE", "na_as_pre_ranked");
            }
            object.addAttribute("GENESET", edbFolderParser$Struc.gmFile.getName() + "#" + object3.getGeneSet().getName(true));
            object.addAttribute(ES, "" + Printf.format(object2.getES()));
            object.addAttribute(NES, "" + Printf.format(object2.getNES()));
            object.addAttribute(NP, "" + Printf.format(object2.getNP()));
            object.addAttribute(FDR, "" + Printf.format(object2.getFDR()));
            object.addAttribute(FWER, "" + Printf.format(object2.getFWER()));
            if (object3.getChip() != null) {
                object.addAttribute(CHIP, object3.getChip().getName());
            }
            object.addAttribute(RND_ES, Printf.format(object3.getRndESS(), ' '));
            object.addAttribute(HIT_INDICES, Printf.format(object2.getHitIndices(), ' '));
            object.addAttribute(ES_PROFILE, Printf.format(object2.getESProfile(), ' '));
            object.addAttribute(RANK_AT_ES, "" + Printf.format(object2.getRankAtES()));
            object.addAttribute(RANK_SCORE_AT_ES, "" + Printf.format(object2.getRankScoreAtES()));
        }
        if (!string.endsWith("edb")) {
            string = string + ".edb";
        }
        File file2 = new File(file, string);
        object3 = new PrintWriter(new FileOutputStream(file2));
        object2 = OutputFormat.createPrettyPrint();
        ((OutputFormat)object2).setEncoding("UTF-8");
        object = new XMLWriter(new FileOutputStream(file2), (OutputFormat)object2);
        ((XMLWriter)object).write((Document)cloneable2);
        ((XMLWriter)object).close();
        ((PrintWriter)object3).close();
        this.doneExport();
    }

    private static String _fixExt(String string, String string2) {
        if (!string.endsWith("." + string2)) {
            string = string + "." + string2;
        }
        return string;
    }

    private RankedList _readRankedList(Element element, File file) {
        String string;
        if (this.rankedListNameRankedListObject == null) {
            this.rankedListNameRankedListObject = new HashMap();
        }
        if ((string = element.attribute("RANKED_LIST").getValue()) == null || string.length() == 0) {
            throw new IllegalArgumentException("No ranked list element in the xml: " + element);
        }
        Object object = this.rankedListNameRankedListObject.get(string);
        if (object == null) {
            File file2 = new File(file, NamingConventions.createSafeFileName(string));
            object = new RankedListJITImpl(file2, false);
        }
        this.rankedListNameRankedListObject.put(string, object);
        return (RankedList)object;
    }

    private File saveIfNeeded(String string, PersistentObject persistentObject, File file) {
        String string2;
        if (this.fPobidFileMap == null) {
            this.fPobidFileMap = new HashMap();
        }
        if (this.fPobidFileMap.containsKey(string2 = string + "." + persistentObject.getClass().getName())) {
            return (File)this.fPobidFileMap.get(string2);
        }
        File file2 = NamingConventions.createSafeFile(file, string);
        if (file2.exists()) {
            this.log.warn("Overwriting extant file: " + file2);
        }
        if (persistentObject instanceof RankedList) {
            ParserFactory.save((RankedList)persistentObject, file2, false);
        } else if (persistentObject instanceof Template) {
            ParserFactory.save((Template)persistentObject, file2, false);
        } else {
            throw new IllegalArgumentException("Unknown object: " + persistentObject);
        }
        this.fPobidFileMap.put(string2, file2);
        return file2;
    }

    private static Boolean _boolean(Element element, String string) {
        Attribute attribute = element.attribute(string);
        if (attribute == null) {
            return null;
        }
        return Boolean.valueOf(attribute.getValue());
    }

    private static File _toFile(String string, Element element, File file) {
        return new File(file, element.attribute(string).getValue());
    }
}

