/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.vdb.Organism;
import java.io.File;

public class EntrezGeneDbParser$EntrezFileSet {
    private File fBaseDir;
    private File geneInfoFile;
    private File gene2accessionFile;
    private File gene2refseqFile;
    private File gene2unigeneFile;
    private Organism[] fOrgs;

    public EntrezGeneDbParser$EntrezFileSet(File file, Organism organism) {
        this(file, new Organism[]{organism});
    }

    public EntrezGeneDbParser$EntrezFileSet(File file, Organism[] organismArray) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Does not exist or null: " + file);
        }
        this.fBaseDir = file;
        this.fOrgs = organismArray;
        Errors errors = new Errors();
        this.geneInfoFile = new File(this.getBaseDir(), "gene_info");
        this.gene2accessionFile = new File(this.getBaseDir(), "gene2accession");
        this.gene2refseqFile = new File(this.getBaseDir(), "gene2refseq");
        this.gene2unigeneFile = new File(this.getBaseDir(), "gene2unigene");
        if (!this.geneInfoFile.exists()) {
            errors.add(this.geneInfoFile.getPath());
        }
        if (!this.gene2accessionFile.exists()) {
            errors.add(this.gene2accessionFile.getPath());
        }
        if (!this.gene2refseqFile.exists()) {
            errors.add(this.gene2refseqFile.getPath());
        }
        if (!this.gene2unigeneFile.exists()) {
            errors.add(this.gene2unigeneFile.getPath());
        }
        errors.barfIfNotEmpty();
    }

    public final File getBaseDir() {
        return this.fBaseDir;
    }

    public final Organism[] getOrganisms() {
        return this.fOrgs;
    }

    static final /* synthetic */ File access$000(EntrezGeneDbParser$EntrezFileSet entrezGeneDbParser$EntrezFileSet) {
        return entrezGeneDbParser$EntrezFileSet.geneInfoFile;
    }

    static final /* synthetic */ File access$100(EntrezGeneDbParser$EntrezFileSet entrezGeneDbParser$EntrezFileSet) {
        return entrezGeneDbParser$EntrezFileSet.gene2accessionFile;
    }

    static final /* synthetic */ File access$200(EntrezGeneDbParser$EntrezFileSet entrezGeneDbParser$EntrezFileSet) {
        return entrezGeneDbParser$EntrezFileSet.gene2refseqFile;
    }

    static final /* synthetic */ File access$300(EntrezGeneDbParser$EntrezFileSet entrezGeneDbParser$EntrezFileSet) {
        return entrezGeneDbParser$EntrezFileSet.gene2unigeneFile;
    }
}

