/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.AuxUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class FSetParser
extends AbstractParser {
    public FSetParser() {
        super(GeneSet.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        if (persistentObject instanceof GeneSetMatrix) {
            GeneSetMatrix geneSetMatrix = (GeneSetMatrix)persistentObject;
            File file2 = file.getParentFile();
            for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
                String string = AuxUtils.getAuxNameOnlyNoHash(geneSetMatrix.getGeneSet(i2).getName());
                this._export(geneSetMatrix.getGeneSet(i2), new File(file2, string));
            }
        } else {
            this._export((GeneSet)persistentObject, file);
        }
        this.doneExport();
    }

    private void _export(GeneSet geneSet, File file) {
        PrintWriter printWriter = this.startExport(geneSet, file);
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            printWriter.println(geneSet.getMember(i2));
        }
        printWriter.close();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        FSet fSet = this.parse(string, new BufferedReader(new InputStreamReader(inputStream)));
        this.doneImport();
        return FSetParser.unmodlist(fSet);
    }

    protected final FSet parse(String string, BufferedReader bufferedReader) {
        String string2 = this.nextLine(bufferedReader);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string2 != null) {
            arrayList.add(string2);
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return new FSet(string, null, stringArray);
    }
}

