/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GctParser
extends AbstractParser {
    public GctParser() {
        super(Dataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        this._export(persistentObject, this.startExport(persistentObject, file));
    }

    @Override
    public final void export(PersistentObject persistentObject, OutputStream outputStream) {
        this._export(persistentObject, this.startExport(persistentObject, outputStream, null));
    }

    private void _export(PersistentObject persistentObject, PrintWriter printWriter) {
        int n;
        Dataset dataset = (Dataset)persistentObject;
        FeatureAnnot featureAnnot = null;
        if (dataset.getAnnot() != null) {
            featureAnnot = dataset.getAnnot().getFeatureAnnot();
        }
        printWriter.println("#1.2");
        printWriter.println(dataset.getNumRow() + "\t" + dataset.getNumCol());
        printWriter.print("NAME\tDESCRIPTION\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print(dataset.getColumnName(n));
            if (n == dataset.getNumCol() - 1) continue;
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataset.getNumRow(); ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = dataset.getRowName(n);
            stringBuffer.append(string).append('\t');
            String string2 = "na";
            if (featureAnnot != null) {
                if (featureAnnot.hasNativeDescriptions()) {
                    string2 = featureAnnot.getNativeDesc(string);
                } else {
                    String string3 = featureAnnot.getGeneSymbol(string);
                    if (string3 != null) {
                        string2 = string3 + ":" + featureAnnot.getGeneTitle(string);
                    }
                }
            }
            if (string2 == null) {
                string2 = "na";
            }
            stringBuffer.append(string2).append('\t');
            stringBuffer.append(dataset.getRow(n).toString('\t'));
            printWriter.println(stringBuffer.toString());
        }
        printWriter.close();
        this.doneExport();
    }

    public final List parse(String string, String string2) {
        StringReader stringReader = new StringReader(string2);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        return this._parse(string, bufferedReader, true);
    }

    public final List parse(String string) {
        String string2 = NamingConventions.generateName("res");
        return this.parse(string2, string);
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse(string, bufferedReader, true);
    }

    public final List parseFlippedNameDesc(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse(string, bufferedReader, false);
    }

    private List _parse(String string, BufferedReader bufferedReader, boolean bl) {
        string = NamingConventions.removeExtension(string);
        String string2 = this.nextLine(bufferedReader);
        int[] nArray = ParseUtils.string2ints(string2, " \t");
        if (nArray.length != 2) {
            throw new ParserException("Gct file with bad row/col info on line: " + string2);
        }
        int n = nArray[0];
        int n2 = nArray[1];
        string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        list.remove(0);
        list.remove(0);
        if (list.size() != n2) {
            throw new ParserException("Bad gct format -- expected ncols from specification on header line: " + n2 + " but found in data: " + list.size());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string2 = this.nextLineTrimless(bufferedReader);
        while (string2 != null) {
            arrayList.add(string2);
            string2 = this.nextLineTrimless(bufferedReader);
        }
        if (arrayList.size() != n) {
            throw new ParserException("Bad gct format -- exepcted nrows from specification on header line: " + n + " but found in data: " + arrayList.size());
        }
        bufferedReader.close();
        return this._parseHasDesc(string, arrayList, list, bl);
    }

    public final List[] parseRowAndColNamesOnly(File file) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = this.nextLine(bufferedReader);
        int[] nArray = ParseUtils.string2ints(string, " \t");
        if (nArray.length != 2) {
            throw new ParserException("Gct file with bad row/col info on line: " + string);
        }
        int n = nArray[0];
        int n2 = nArray[1];
        string = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string, "\t");
        list.remove(0);
        list.remove(0);
        if (list.size() != n2) {
            throw new ParserException("Bad gct format -- expected ncols from specification on header line: " + n2 + " but found in data: " + list.size());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string = this.nextLineTrimless(bufferedReader);
        while (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            arrayList.add(stringTokenizer.nextToken());
            string = this.nextLineTrimless(bufferedReader);
        }
        if (arrayList.size() != n) {
            throw new ParserException("Bad gct format -- exepcted nrows from specification on header line: " + n + " but found in data: " + arrayList.size());
        }
        bufferedReader.close();
        return new List[]{arrayList, list};
    }

    private List _parseHasDesc(String string, List list, List list2, boolean bl) {
        Object object;
        Object object2;
        string = NamingConventions.removeExtension(string);
        Matrix matrix = new Matrix(list.size(), list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = (String)list.get(i2);
            object = GctParser.string2stringsV2((String)object2, list2.size() + 2);
            if (object.size() != list2.size() + 1 + 1) {
                throw new ParserException("Bad format - expect ncols: " + (list2.size() + 1 + 1) + " but found: " + object.size() + " on line >" + (String)object2 + "<\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String string2 = object.get(0).toString().trim();
            if (string2.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + i2 + " >" + (String)object2);
            }
            String string3 = object.get(1).toString().trim();
            if (string3.length() == 0) {
                string3 = "na";
            }
            if (!bl) {
                String string4 = string2;
                string2 = string3;
                string3 = string4;
            }
            arrayList2.add(string3);
            arrayList.add(string2);
            for (int i3 = 2; i3 < object.size(); ++i3) {
                float f2;
                String string5 = object.get(i3).toString().trim();
                if (string5.length() == 0) {
                    f2 = Float.NaN;
                } else {
                    try {
                        f2 = Float.parseFloat(string5);
                    }
                    catch (Exception exception) {
                        System.out.println(">" + string5 + "<");
                        throw exception;
                    }
                }
                matrix.setElement(i2, i3 - 2, f2);
            }
        }
        FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl(string, arrayList, arrayList2);
        featureAnnotImpl.addComment(this.fComment.toString());
        object2 = new SampleAnnotImpl(string, list2, null);
        object = new DefaultDataset(string, matrix, arrayList, list2, true, (Annot)new AnnotImpl(featureAnnotImpl, (SampleAnnot)object2));
        object.addComment(this.fComment.toString());
        this.doneImport();
        return GctParser.unmodlist(new PersistentObject[]{object});
    }
}

