/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class GmxParser
extends AbstractParser {
    private boolean fCheckForDuplicates = true;

    public GmxParser() {
        super(GeneSetMatrix.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        int n;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        GeneSetMatrix geneSetMatrix = (GeneSetMatrix)persistentObject;
        StringBuffer stringBuffer = new StringBuffer();
        GeneSet[] geneSetArray = geneSetMatrix.getGeneSets();
        for (n = 0; n < geneSetArray.length; ++n) {
            stringBuffer.append(geneSetArray[n].getName()).append('\t');
        }
        stringBuffer.append('\n');
        for (n = 0; n < geneSetArray.length; ++n) {
            String string = geneSetArray[n].getNameEnglish();
            if (this.isNullorNa(string)) {
                string = "na";
            }
            stringBuffer.append(string).append('\t');
        }
        stringBuffer.append('\n');
        n = geneSetMatrix.getMaxGeneSetSize();
        printWriter.print(stringBuffer.toString());
        printWriter.flush();
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer = new StringBuffer();
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (i2 < geneSetArray[i3].getNumMembers()) {
                    stringBuffer.append(geneSetArray[i3].getMember(i2)).append('\t');
                    continue;
                }
                stringBuffer.append("\t");
            }
            stringBuffer.append('\n');
            printWriter.print(stringBuffer.toString());
            printWriter.flush();
        }
        this.doneExport();
        printWriter.close();
    }

    protected final void setCheckForDuplicates(boolean bl) {
        this.fCheckForDuplicates = bl;
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        int n;
        GeneSet[] geneSetArray;
        int n2;
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = this.nextLine(bufferedReader);
        String[] stringArray = this.parseNames(string2);
        string2 = this.nextLine(bufferedReader);
        String[] stringArray2 = this.parseNames(string2);
        ArrayList[] arrayListArray = new ArrayList[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            arrayListArray[n2] = new ArrayList();
        }
        string2 = this.nextLine(bufferedReader);
        n2 = 3;
        int n3 = stringArray.length;
        while (string2 != null) {
            geneSetArray = GmxParser.string2stringsV2(string2, stringArray.length);
            if (geneSetArray.size() != n3) {
                throw new ParserException("Bad format on line: " + string2 + "< # names expected: " + n3 + " but found fields on this line: " + geneSetArray.size() + " approx line#: " + n2);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (this.isNull(geneSetArray.get(n))) continue;
                arrayListArray[n].add(geneSetArray.get(n));
            }
            string2 = this.nextLineTrimless(bufferedReader);
            ++n2;
        }
        bufferedReader.close();
        geneSetArray = new GeneSet[arrayListArray.length];
        for (n = 0; n < arrayListArray.length; ++n) {
            String string3 = string.concat("#").concat(stringArray[n].toUpperCase());
            geneSetArray[n] = new FSet(string3, stringArray2[n], arrayListArray[n], this.fCheckForDuplicates);
        }
        this.doneImport();
        return GmxParser.unmodlist(new DefaultGeneSetMatrix(string, geneSetArray));
    }

    private String[] parseNames(String string) {
        return ParseUtils.string2strings(string, "\t", false);
    }
}

