/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.vdb.meg.DefaultGene;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.vdb.meg.GeneDb;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HugoDbParser
extends AbstractParser {
    public HugoDbParser() {
        super(GeneDb.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        throw new NotImplementedException();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        return HugoDbParser.unmodlist(this.parseHugoDb(new File(string)));
    }

    public final GeneDb parseHugoDb(File file) {
        StringDataframe stringDataframe = ParserFactory.readStringDataframe(file, false);
        ArrayList<DefaultGene> arrayList = new ArrayList<DefaultGene>();
        for (int i2 = 0; i2 < stringDataframe.getNumRow(); ++i2) {
            String string = stringDataframe.getElement(i2, "Approved Symbol");
            String string2 = stringDataframe.getElement(i2, "Approved Name");
            String string3 = stringDataframe.getElement(i2, "Status");
            String string4 = stringDataframe.getElement(i2, "Chromosome");
            if (!string3.equalsIgnoreCase("Approved")) continue;
            Set set = ParseUtils.string2stringsSet(stringDataframe.getElement(i2, "Aliases"), ",", false);
            Set set2 = ParseUtils.string2stringsSet(stringDataframe.getElement(i2, "Accession Numbers"), ",", false);
            Set set3 = ParseUtils.string2stringsSet(stringDataframe.getElement(i2, "RefSeq IDs"), ",", false);
            HashSet hashSet = new HashSet();
            hashSet.addAll(set2);
            hashSet.addAll(set3);
            arrayList.add(new DefaultGene(string, string2, set, string4, hashSet));
        }
        return new GeneDb(file, new Version(1), arrayList.toArray(new Gene[arrayList.size()]));
    }
}

