/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Headers$MSigDB;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotationImpl;
import edu.mit.broad.vdb.msigdb.GeneSetExternalLinks;
import edu.mit.broad.vdb.msigdb.MSigDB;
import edu.mit.broad.vdb.msigdb.MSigDBImpl;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MSigDBParser
extends AbstractParser
implements Headers$MSigDB {
    public MSigDBParser() {
        super(MSigDB.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        this.export((MSigDB)persistentObject, file, true);
    }

    public final void export(MSigDB mSigDB, File file, boolean bl) {
        Object object;
        PrintWriter printWriter = this.startExport(mSigDB, file);
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("MSIGDB");
        element.addAttribute("NAME", mSigDB.getName());
        element.addAttribute("VERSION", mSigDB.getVersion());
        element.addAttribute("BUILD_DATE", mSigDB.getBuildDate());
        for (int i2 = 0; i2 < mSigDB.getNumGeneSets(); ++i2) {
            object = mSigDB.getGeneSetAnnotation(i2);
            MSigDBParser._addGeneSetElement(element, (GeneSetAnnotation)object, bl);
        }
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        object = new XMLWriter(printWriter, outputFormat);
        ((XMLWriter)object).write(document);
        ((XMLWriter)object).close();
        printWriter.close();
        this.doneExport();
    }

    public static final Document createDocument_for_single_set(GeneSetAnnotation geneSetAnnotation, boolean bl) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("MSIGDB");
        element.addAttribute("NAME", geneSetAnnotation.getStandardName());
        element.addAttribute("VERSION", "1");
        element.addAttribute("BUILD_DATE", "1");
        MSigDBParser._addGeneSetElement(element, geneSetAnnotation, bl);
        return document;
    }

    public static final void setGeneSetAttributes(Element element, GeneSetAnnotation geneSetAnnotation, boolean bl) {
        element.addAttribute("STANDARD_NAME", geneSetAnnotation.getStandardName());
        element.addAttribute("SYSTEMATIC_NAME", geneSetAnnotation.getLSIDName());
        element.addAttribute("ORGANISM", geneSetAnnotation.getOrganism().toString());
        GeneSetExternalLinks geneSetExternalLinks = geneSetAnnotation.getExternalLinks();
        MSigDBParser.addAttribute_safe(element, "PMID", geneSetExternalLinks.getPMID());
        MSigDBParser.addAttribute_safe(element, "GEOID", geneSetExternalLinks.getGeoID());
        MSigDBParser.addAttribute_safe(element, "GENESET_LISTING_URL", geneSetExternalLinks.getSpecificGeneSetListingURL());
        MSigDBParser.addAttribute_safe(element, "EXTERNAL_DETAILS_URL", geneSetExternalLinks.getExtDetailsURL());
        element.addAttribute("CHIP", geneSetAnnotation.getChipOriginal_name());
        element.addAttribute("CATEGORY_CODE", geneSetAnnotation.getCategory().getCode());
        element.addAttribute("CONTRIBUTOR", geneSetAnnotation.getContributor().getName());
        element.addAttribute("DESCRIPTION_BRIEF", geneSetAnnotation.getDescription().getBrief());
        element.addAttribute("DESCRIPTION_FULL", geneSetAnnotation.getDescription().getFull());
        element.addAttribute("TAGS", MSigDBParser._toString(geneSetAnnotation.getTags()));
        element.addAttribute("MEMBERS", MSigDBParser.toString(geneSetAnnotation.getGeneSet(true)));
        if (bl) {
            element.addAttribute("MEMBERS_SYMBOLIZED", MSigDBParser.toString(geneSetAnnotation.getGeneSet(false)));
        }
    }

    private static Element _addGeneSetElement(Element element, GeneSetAnnotation geneSetAnnotation, boolean bl) {
        Element element2 = element.addElement("GENESET");
        MSigDBParser.setGeneSetAttributes(element2, geneSetAnnotation, bl);
        return element2;
    }

    private static void addAttribute_safe(Element element, String string, String string2) {
        if (string2 != null) {
            element.addAttribute(string, string2);
        }
    }

    private static String toString(GeneSet geneSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            stringBuffer.append(geneSet.getMember(i2));
            if (i2 == geneSet.getNumMembers() - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        SAXReader sAXReader = new SAXReader();
        Document document = sAXReader.read(inputStream);
        Element element = document.getRootElement();
        String string2 = element.attribute("NAME").getValue();
        String string3 = element.attribute("VERSION").getValue();
        String string4 = element.attribute("BUILD_DATE").getValue();
        ArrayList<GeneSetAnnotation> arrayList = new ArrayList<GeneSetAnnotation>();
        int n = 0;
        Object object = element.elementIterator("GENESET");
        while (object.hasNext()) {
            Element element2 = (Element)object.next();
            arrayList.add(this._parseOneGsa(element2));
            if (n % 500 == 0) {
                System.out.println("read in from gsetann: " + (n + 1));
            }
            ++n;
        }
        object = new MSigDBImpl(string2, string3, string4, arrayList.toArray(new GeneSetAnnotation[arrayList.size()]));
        object.addComment(this.fComment.toString());
        this.doneImport();
        return MSigDBParser.unmodlist((PersistentObject)object);
    }

    private static String attribute_safe(Element element, String string) {
        Attribute attribute = element.attribute(string);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private static String attribute_reqd(Element element, String string) {
        Attribute attribute = element.attribute(string);
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Expected attribute: >" + string + "< was not found");
    }

    private GeneSetAnnotation _parseOneGsa(Element element) {
        FSet fSet = new FSet(element.attribute("STANDARD_NAME").getValue(), MSigDBParser._fromSet(element, "MEMBERS"));
        FSet fSet2 = new FSet(element.attribute("STANDARD_NAME").getValue(), MSigDBParser._fromSet(element, "MEMBERS_SYMBOLIZED"));
        GeneSetAnnotationImpl geneSetAnnotationImpl = new GeneSetAnnotationImpl(fSet, fSet2, MSigDBParser.attribute_reqd(element, "CHIP"), MSigDBParser.attribute_reqd(element, "CONTRIBUTOR"), MSigDBParser.attribute_safe(element, "PMID"), MSigDBParser.attribute_safe(element, "GEOID"), MSigDBParser.attribute_safe(element, "GENESET_LISTING_URL"), MSigDBParser.attribute_safe(element, "EXTERNAL_DETAILS_URL"), MSigDBParser.attribute_reqd(element, "STANDARD_NAME"), MSigDBParser.attribute_reqd(element, "SYSTEMATIC_NAME"), MSigDBParser.attribute_reqd(element, "ORGANISM"), MSigDBParser.attribute_reqd(element, "CATEGORY_CODE"), MSigDBParser.attribute_reqd(element, "DESCRIPTION_BRIEF"), MSigDBParser.attribute_safe(element, "DESCRIPTION_FULL"), MSigDBParser._fromSet(element, "TAGS"));
        return geneSetAnnotationImpl;
    }

    private static Set _fromSet(Element element, String string) {
        Attribute attribute = element.attribute(string);
        if (attribute != null) {
            return ParseUtils.string2stringsSet(attribute.getValue(), ",", false);
        }
        return null;
    }

    private static String _toString(Set set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            stringBuffer.append(e2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }
}

