/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.TxtAffy;
import edu.mit.broad.genome.objects.strucs.TxtAffy$Value;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelLinesColorStruc;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelSdfColorStruc;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.parsers.TxtAffyParser;
import gnu.trove.TFloatArrayList;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.RGB;
import org.apache.log4j.Logger;

public class MiscParsers {
    private static final Logger klog = XLogger.getLogger(MiscParsers.class);

    private MiscParsers() {
    }

    public static final void gct2arff(Dataset dataset, File file) {
    }

    public static final MiscParsers$ExcelSdfColorStruc excel2sdf_and_colors(File file) {
        MiscParsers$ExcelSdfColorStruc miscParsers$ExcelSdfColorStruc = new MiscParsers$ExcelSdfColorStruc();
        miscParsers$ExcelSdfColorStruc.sdf = MiscParsers.excel2sdf(file);
        miscParsers$ExcelSdfColorStruc.stateColorMap = MiscParsers.parseColorMapFromExcel(file);
        return miscParsers$ExcelSdfColorStruc;
    }

    public static final MiscParsers$ExcelSdfColorStruc[] excel2sdf_and_colors_all_worksheets(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        Workbook workbook = Workbook.getWorkbook(fileInputStream);
        MiscParsers$ExcelSdfColorStruc[] miscParsers$ExcelSdfColorStrucArray = new MiscParsers$ExcelSdfColorStruc[workbook.getNumberOfSheets()];
        for (int i2 = 0; i2 < workbook.getNumberOfSheets(); ++i2) {
            Sheet sheet = workbook.getSheet(i2);
            miscParsers$ExcelSdfColorStrucArray[i2] = new MiscParsers$ExcelSdfColorStruc();
            miscParsers$ExcelSdfColorStrucArray[i2].sdf = MiscParsers.excel2sdf(file.getPath(), sheet);
            miscParsers$ExcelSdfColorStrucArray[i2].stateColorMap = MiscParsers.parseColorMapFromExcel(file.getPath(), sheet);
            miscParsers$ExcelSdfColorStrucArray[i2].sheetName = sheet.getName();
        }
        return miscParsers$ExcelSdfColorStrucArray;
    }

    public static final MiscParsers$ExcelLinesColorStruc[] excel2lines_and_colors_all_worksheets(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        Workbook workbook = Workbook.getWorkbook(fileInputStream);
        MiscParsers$ExcelLinesColorStruc[] miscParsers$ExcelLinesColorStrucArray = new MiscParsers$ExcelLinesColorStruc[workbook.getNumberOfSheets()];
        for (int i2 = 0; i2 < workbook.getNumberOfSheets(); ++i2) {
            Sheet sheet = workbook.getSheet(i2);
            miscParsers$ExcelLinesColorStrucArray[i2] = new MiscParsers$ExcelLinesColorStruc();
            miscParsers$ExcelLinesColorStrucArray[i2].lines = MiscParsers.excel2LinesList(file.getPath(), sheet);
            miscParsers$ExcelLinesColorStrucArray[i2].valueColorMap = MiscParsers.parseColorMapFromExcel(file.getPath(), sheet);
            miscParsers$ExcelLinesColorStrucArray[i2].sheetName = sheet.getName();
        }
        return miscParsers$ExcelLinesColorStrucArray;
    }

    public static final StringDataframe excel2sdf(File file) {
        return MiscParsers.excel2sdf(file.getPath(), new FileInputStream(file), 0);
    }

    public static final StringDataframe excel2sdf(String string, InputStream inputStream, int n) {
        Workbook workbook = Workbook.getWorkbook(inputStream);
        return MiscParsers.excel2sdf(string, workbook.getSheet(n));
    }

    public static final StringDataframe excel2sdf(String string, Sheet sheet) {
        int n;
        klog.info("Parsing excel from: " + string);
        int n2 = sheet.getRows();
        int n3 = sheet.getColumns();
        StringMatrix stringMatrix = new StringMatrix(n2 - 1, n3 - 1);
        String[] stringArray = new String[n3 - 1];
        String[] stringArray2 = new String[n2 - 1];
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 1; n < n2; ++n) {
            String string2;
            stringArray2[n - 1] = string2 = MiscParsers._txt(n, 0, sheet, true);
            if (hashSet.contains(string2)) {
                throw new ParserException("Duplicate row_name in excel ss: >" + string2 + "<" + "\n" + hashSet);
            }
            hashSet.add(string2);
        }
        for (n = 1; n < sheet.getColumns(); ++n) {
            for (int i2 = 0; i2 < sheet.getRows(); ++i2) {
                if (i2 == 0) {
                    stringArray[n - 1] = MiscParsers._txt(i2, n, sheet, true);
                    continue;
                }
                stringMatrix.setElement(i2 - 1, n - 1, MiscParsers._txt(i2, n, sheet));
            }
        }
        return new StringDataframe(new File(string).getName(), stringMatrix, stringArray2, stringArray, true);
    }

    public static final List excel2LinesList(String string, Sheet sheet) {
        int n = sheet.getRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n; ++i2) {
            String string2 = MiscParsers._txt_full_row(i2, sheet);
            if (string2 == null || string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static String _txt(int n, int n2, Sheet sheet) {
        return MiscParsers._txt(n, n2, sheet, false);
    }

    private static String _txt(int n, int n2, Sheet sheet, boolean bl) {
        Cell cell = sheet.getCell(n2, n);
        String string = cell.getContents();
        if (string != null) {
            string = string.trim();
        }
        if (bl && (string == null || string.length() == 0)) {
            throw new ParserException("Null or empty for r: " + n + " c: " + n2);
        }
        return string;
    }

    private static String _txt_full_row(int n, Sheet sheet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < sheet.getColumns(); ++i2) {
            String string = MiscParsers._txt(n, i2, sheet, false);
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(string).append('\t');
        }
        return stringBuffer.toString().trim();
    }

    public static final Dataset getDatasetFromTxtFiles(String string, File[] fileArray, boolean bl) {
        TxtAffyParser txtAffyParser = new TxtAffyParser();
        TxtAffy txtAffy = (TxtAffy)txtAffyParser.parse(fileArray[0].getName(), fileArray[0]).get(0);
        int n = txtAffy.getNumValues();
        Matrix matrix = new Matrix(n, fileArray.length);
        APMMatrix aPMMatrix = new APMMatrix(n, fileArray.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            TxtAffyParser txtAffyParser2 = new TxtAffyParser();
            TxtAffy txtAffy2 = (TxtAffy)txtAffyParser2.parse(fileArray[i2].getName(), fileArray[i2]).get(0);
            arrayList.add(txtAffy2.getName());
            for (int i3 = 0; i3 < n; ++i3) {
                String string2 = txtAffy.getValue((int)i3).fFeatureName;
                TxtAffy$Value txtAffy$Value = txtAffy2.getValue(string2);
                if (i2 == 0) {
                    arrayList2.add(string2);
                }
                float f2 = bl ? txtAffy$Value.fSignal : txtAffy$Value.fDetectionPValue;
                String string3 = Character.toString(txtAffy$Value.fCall);
                matrix.setElement(i3, i2, f2);
                aPMMatrix.setElement(i3, i2, string3);
            }
        }
        return new DefaultDataset(string, matrix, arrayList2, arrayList, true, null, aPMMatrix);
    }

    public static final Dataset getDatasetFromTxtFiles(String string, File[] fileArray, boolean bl, GeneSet geneSet, boolean bl2) {
        Matrix matrix = new Matrix(geneSet.getNumMembers(), fileArray.length);
        APMMatrix aPMMatrix = new APMMatrix(geneSet.getNumMembers(), fileArray.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            TxtAffyParser txtAffyParser = new TxtAffyParser();
            TxtAffy txtAffy = (TxtAffy)txtAffyParser.parse(fileArray[i2].getName(), fileArray[i2]).get(0);
            arrayList.add(txtAffy.getName());
            for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
                String string2;
                float f2;
                String string3 = geneSet.getMember(i3);
                TxtAffy$Value txtAffy$Value = txtAffy.getValue(string3, bl2);
                if (txtAffy$Value == null) {
                    f2 = 0.0f;
                    string2 = "A";
                } else {
                    f2 = bl ? txtAffy$Value.fSignal : txtAffy$Value.fDetectionPValue;
                    string2 = Character.toString(txtAffy$Value.fCall);
                }
                matrix.setElement(i3, i2, f2);
                aPMMatrix.setElement(i3, i2, string2);
            }
            System.out.println("Done " + (i2 + 1) + " / " + fileArray.length);
        }
        return new DefaultDataset(string, matrix, geneSet.getMembers(), arrayList, true, null, aPMMatrix);
    }

    public static final Map parseColorMapFromExcel(File file) {
        Workbook workbook = Workbook.getWorkbook(file);
        Sheet sheet = workbook.getSheet(0);
        return MiscParsers.parseColorMapFromExcel(file.getPath(), sheet);
    }

    public static final Map parseColorMapFromExcel(String string, Sheet sheet) {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        for (int i2 = 0; i2 < sheet.getColumns(); ++i2) {
            for (int i3 = 0; i3 < sheet.getRows(); ++i3) {
                RGB rGB;
                Color color;
                Cell cell;
                CellFormat cellFormat;
                Colour colour;
                String string2 = MiscParsers._txt(i3, i2, sheet, false);
                if (string2 == null || string2.length() <= 0 || (colour = (cellFormat = (cell = sheet.getCell(i2, i3)).getCellFormat()).getBackgroundColour()) == null || (color = new Color((rGB = colour.getDefaultRGB()).getRed(), rGB.getGreen(), rGB.getBlue())) == Color.WHITE || hashMap.containsKey(string2)) continue;
                hashMap.put(string2, color);
            }
        }
        return hashMap;
    }

    public static final GeneSetMatrix parseXhxMotifFile(File file) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        List list = ParseUtils.slurpIntoList(bufferedReader, false);
        if (list.size() == 0) {
            throw new ParserException("No data in file -- nothing to parse");
        }
        ArrayList<FSet> arrayList = new ArrayList<FSet>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = list.get(i2).toString();
            if (!string.startsWith(">")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = stringTokenizer.nextToken();
            String string3 = list.get(i2 + 1).toString();
            String[] stringArray = ParseUtils.string2strings(string3, " \t", false);
            FSet fSet = new FSet(string2, stringArray);
            arrayList.add(fSet);
            ++i2;
        }
        bufferedReader.close();
        return new DefaultGeneSetMatrix(file.getName(), arrayList);
    }

    public static final Matrix parseMatrix_hackH(File file) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        List list = ParseUtils.slurpIntoList(bufferedReader, false);
        if (list.size() == 0) {
            throw new ParserException("No data in file -- nothing to parse");
        }
        String[] stringArray = ParseUtils.string2strings(list.get(0).toString(), "\t", false);
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].startsWith("V")) continue;
            tFloatArrayList.add(Float.parseFloat(stringArray[i2]));
        }
        float[] fArray = tFloatArrayList.toNativeArray();
        if (fArray.length == 0) {
            throw new ParserException("No data in file -- nothing to parse");
        }
        Matrix matrix = new Matrix(list.size(), fArray.length);
        matrix.setRow(0, fArray);
        for (int i3 = 1; i3 < list.size(); ++i3) {
            float[] fArray2 = ParseUtils.string2floats(list.get(i3).toString(), " \t");
            if (fArray2.length != fArray.length) {
                throw new ParserException("Unequal number of elements in row: " + (i3 + 1) + " found: " + fArray2.length + " but expected: " + fArray.length);
            }
            matrix.setRow(i3, fArray2);
        }
        bufferedReader.close();
        matrix.setImmutable();
        return matrix;
    }

    public static final Matrix parseMatrix(File file, boolean bl) {
        return MiscParsers.parseMatrix(new BufferedReader(new FileReader(file)), bl);
    }

    public static final Matrix parseMatrix(String string, InputStream inputStream, boolean bl) {
        inputStream.close();
        return MiscParsers.parseMatrix(new File(string), bl);
    }

    public static final Matrix parseMatrix(BufferedReader bufferedReader, boolean bl) {
        List list = ParseUtils.slurpIntoList(bufferedReader, false);
        if (list.size() == 0) {
            throw new ParserException("No data in file -- nothing to parse");
        }
        if (bl) {
            throw new NotImplementedException();
        }
        float[] fArray = ParseUtils.string2floats(list.get(0).toString(), " \t");
        if (fArray.length == 0) {
            throw new ParserException("No data in file -- nothing to parse");
        }
        Matrix matrix = new Matrix(list.size(), fArray.length);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            float[] fArray2 = ParseUtils.string2floats(list.get(i2).toString(), " \t");
            if (fArray2.length != fArray.length) {
                throw new ParserException("Unequal number of elements in row: " + (i2 + 1) + " found: " + fArray2.length + " but expected: " + fArray.length);
            }
            matrix.setRow(i2, fArray2);
        }
        bufferedReader.close();
        matrix.setImmutable();
        return matrix;
    }

    public static final void save(Matrix matrix, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i2 = 0; i2 < matrix.getNumRow(); ++i2) {
            printWriter.println(matrix.getRowV(i2).toString('\t'));
        }
        printWriter.close();
    }

    public static final void save(Vector vector, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.println(vector.toString('\t'));
        printWriter.close();
    }

    public static final void exportSvmFu(Dataset dataset, Template template, File file) {
        if (dataset.getNumCol() != template.getNumItems()) {
            throw new IllegalArgumentException("Mismatched da: " + dataset.getNumCol() + " and template: " + template.getNumItems());
        }
        if (template.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates allowed");
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.println(dataset.getNumCol() + " " + dataset.getNumRow());
        String string = template.getClass(1).getName();
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            Vector vector = dataset.getColumn(i2);
            String string2 = template.getClassByProfilePos(i2).getName();
            String string3 = string2.equals(string) ? "1" : "-1";
            String string4 = Printf.format(vector, ' ');
            string4 = string4.trim();
            string4 = string4 + ' ' + string3;
            printWriter.println(string4);
        }
        printWriter.close();
    }
}

