/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.utils.FileUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ParseUtils {
    private static final char DEFAULT_FIELD_SEP_CSV = ',';
    public static final String DEFAULT_DELIMS = " \t\n,;:";
    public static final String COLOR_PKG = "java.awt.Color";
    private static final Logger klog = XLogger.getLogger(ParseUtils.class);
    public static final String NULL_CHAR = "*";
    public static final int MAX_SEARCH_LINES = 20;
    private static final String[] MAGIC_NULLS = new String[]{"NULL", "na", "-", "---"};

    public static final void checkColumnNames(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Parameter got cannot be null");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("Parameter expected cannot be null");
        }
        if (stringArray.length < stringArray2.length) {
            Set set = AlgUtils.subtract(stringArray2, stringArray);
            System.out.println("\nThe expected ones NOT got were\n" + set);
            Printf.out(stringArray);
            Printf.out(stringArray2);
            throw new MismatchedSizeException("got", stringArray.length, "expected", stringArray2.length);
        }
        if (stringArray.length > stringArray2.length) {
            Set set = AlgUtils.subtract(stringArray, stringArray2);
            System.out.println("\nThe UNexpected ones got were\n" + set);
            throw new MismatchedSizeException("got", stringArray.length, "expected", stringArray2.length);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equalsIgnoreCase(stringArray2[i2])) continue;
            throw new IllegalArgumentException("Column names are mismatched at: " + i2 + " " + stringArray[i2] + " and " + stringArray2[i2]);
        }
    }

    public static final void checkColumnNames(StringDataframe stringDataframe, String[] stringArray) {
        if (stringDataframe == null) {
            throw new IllegalArgumentException("Parameter sdf cannot be null");
        }
        ParseUtils.checkColumnNames(stringDataframe.getColumnNamesArray(), stringArray);
    }

    public final List read(File file, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = ParseUtils.nextLine(bufferedReader);
        while (string != null) {
            arrayList.add(string);
            string = ParseUtils.nextLine(bufferedReader);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final String getLastToken(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    public static final String getFirstToken(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return stringTokenizer.nextToken();
    }

    public static final int[] string2ints(String string) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DELIMS);
        return ParseUtils._doIntParse(stringTokenizer);
    }

    public static final float[] string2floats(String string) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DELIMS);
        return ParseUtils._doFloatParse(stringTokenizer);
    }

    public static final Float[] string2Floats(String string) {
        float[] fArray = ParseUtils.string2floats(string);
        Float[] floatArray = new Float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            floatArray[i2] = new Float(fArray[i2]);
        }
        return floatArray;
    }

    public static final Integer[] string2Ints(String string) {
        int[] nArray = ParseUtils.string2ints(string);
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return integerArray;
    }

    public static final int[] string2ints(String string, String string2) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return ParseUtils._doIntParse(stringTokenizer);
    }

    public static final int[] string2ints(String string, char c2) {
        return ParseUtils.string2ints(string, Character.toString(c2));
    }

    public static final float[] string2floats(String string, char c2) {
        return ParseUtils.string2floats(string, Character.toString(c2));
    }

    public static final float[] string2floats(String string, String string2) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return ParseUtils._doFloatParse(stringTokenizer);
    }

    public static final Vector string2Vector(String string, char c2) {
        return new Vector(ParseUtils.string2floats(string, Character.toString(c2)));
    }

    public static final Vector string2Vector(String string, String string2) {
        return new Vector(ParseUtils.string2floats(string, string2));
    }

    private static int[] _doIntParse(StringTokenizer stringTokenizer) {
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            nArray[n] = Integer.parseInt(string);
            ++n;
        }
        return nArray;
    }

    private static float[] _doFloatParse(StringTokenizer stringTokenizer) {
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            fArray[n] = Float.parseFloat(string);
            ++n;
        }
        return fArray;
    }

    public static final String[] string2strings(String string, boolean bl) {
        return ParseUtils.string2strings(string, DEFAULT_DELIMS, bl);
    }

    public static final String[] string2strings(String string, String string2, String[] stringArray) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n] = ParseUtils._magic(stringTokenizer.nextToken().trim(), stringArray, true);
            ++n;
        }
        return stringArray2;
    }

    public static final String[] string2strings(String string, String string2, boolean bl) {
        if (null == string) {
            throw new NullPointerException("Cannot parse on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = ParseUtils._magic(stringTokenizer.nextToken().trim(), bl);
            ++n;
        }
        return stringArray;
    }

    public static final String[] string2stringsV2(String string) {
        List list = ParseUtils.string2stringsV2_list(string);
        return list.toArray(new String[list.size()]);
    }

    public static final List string2stringsV2_list(String string) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals("\t")) {
                arrayList.add(string3);
            }
            if (string3.equals(string2)) {
                arrayList.add("");
            }
            string2 = string3;
        }
        return arrayList;
    }

    public static final Set string2stringsV2_set(String string) {
        return new HashSet(ParseUtils.string2stringsV2_list(string));
    }

    public static final List string2stringsList(String string) {
        return ParseUtils.string2stringsList(string, DEFAULT_DELIMS);
    }

    public static final List string2stringsList(String string, String string2) {
        if (null == string) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    public static final Set string2stringsSet(String string, String string2, boolean bl) {
        if (null == string) {
            return new HashSet();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if ((string3 = ParseUtils._magic(string3, bl)) == null) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private static String _magic(String string, boolean bl) {
        return ParseUtils._magic(string, MAGIC_NULLS, bl);
    }

    private static String _magic(String string, String[] stringArray, boolean bl) {
        if (bl) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string.trim().equalsIgnoreCase(stringArray[i2])) continue;
                return null;
            }
        }
        return string;
    }

    public static final char getDelim(String string) {
        char[] cArray = new char[]{'\t', ' ', ',', '\n'};
        char c2 = '\u0000';
        int n = -1;
        for (int i2 = 0; n == -1 && i2 < cArray.length; ++i2) {
            c2 = cArray[i2];
            n = string.indexOf(c2, 0);
        }
        if (n == -1) {
            c2 = '\u0000';
        }
        return c2;
    }

    public static final int splitIntegers(String string, char c2, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n < n4) {
            n = string.indexOf(c2, n2);
            if (n < 0) {
                n = n4;
            }
            String string2 = string.substring(n2, n).trim();
            nArray[n3] = Integer.valueOf(string2);
            n2 = n + 1;
            if (++n3 != nArray.length) continue;
            break;
        }
        return n3;
    }

    public static final String charToString(char c2) {
        char[] cArray = new char[]{c2};
        return new String(cArray);
    }

    public static final String jdbcUrl2Name(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        if (stringTokenizer.countTokens() == 2) {
            stringTokenizer.nextToken();
            return stringTokenizer.nextToken().trim();
        }
        return string;
    }

    public static final String color2string(Color color) {
        String string = color.toString();
        return string.substring(COLOR_PKG.length());
    }

    public static final List getUniqueTokens(StringTokenizer stringTokenizer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken().trim();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static final void ensureEquals(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Mismatched lengths a: " + stringArray.length + " b: " + stringArray2.length);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equalsIgnoreCase(stringArray2[i2])) continue;
            throw new IllegalArgumentException("Mismatched entries at: " + i2 + " a: " + stringArray[i2] + " and b: " + stringArray2[i2]);
        }
    }

    public static final void ensureEquals(List list, String[] stringArray) {
        if (list.size() != stringArray.length) {
            throw new IllegalArgumentException("Mismatched lengths a: " + list.size() + " b: " + stringArray.length);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).toString().equalsIgnoreCase(stringArray[i2])) continue;
            throw new IllegalArgumentException("Mismatched entries at: " + i2 + " a: " + list.get(i2) + " and b: " + stringArray[i2]);
        }
    }

    public static final void ensureHeader(File file, String[] stringArray) {
        ParseUtils.ensureEquals(ParseUtils.string2strings(ParseUtils.getFirstNonWsLine(file), false), stringArray);
    }

    public static final BufferedReader buf(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        return new BufferedReader(new FileReader(file));
    }

    public static final List readFfn(File file) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ParseUtils.nextLine(bufferedReader);
        while (string != null) {
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            string = ParseUtils.nextLine(bufferedReader);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final Object[] getValues(File file) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        return properties.values().toArray();
    }

    public static final Object[] getKeys(File file) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        return properties.keySet().toArray();
    }

    public static final Map readKeyVal_consolidate_vals_into_list(File file, boolean bl, boolean bl2) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        HashMap<String, List> hashMap = new HashMap<String, List>();
        String string = ParseUtils.nextLine(bufferedReader);
        if (bl) {
            string = ParseUtils.nextLine(bufferedReader);
        }
        int n = 0;
        while (string != null) {
            List list;
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string3 = null;
            if (stringTokenizer.countTokens() == 2) {
                string2 = stringTokenizer.nextToken().trim();
                string3 = stringTokenizer.nextToken().trim();
            } else if (stringTokenizer.countTokens() == 1) {
                string2 = stringTokenizer.nextToken().trim();
            } else {
                throw new IOException("Bad line format: " + string + " # tokens: " + stringTokenizer.countTokens() + " line: " + n);
            }
            if (bl2 && (string3 == null || string3.length() == 0)) {
                throw new RuntimeException("Value must exist. Missing on line: " + n + " val: " + string3);
            }
            if (string2.length() == 0) {
                throw new RuntimeException("Empty key on line: " + n);
            }
            Object object = hashMap.get(string2);
            if (object == null) {
                object = new ArrayList();
            }
            if (!(list = (List)object).contains(string3)) {
                list.add(string3);
            }
            hashMap.put(string2, list);
            string = ParseUtils.nextLine(bufferedReader);
            ++n;
        }
        bufferedReader.close();
        if (n == 0) {
            throw new IllegalArgumentException("Empty input stream!! ");
        }
        return hashMap;
    }

    public static final Properties readKeyVal(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParseUtils.readKeyVal(new BufferedReader(new FileReader(file)), bl, bl2, bl3);
    }

    public static final Properties readKeyVal_from_xls(File file, boolean bl, boolean bl2) {
        StringDataframe stringDataframe = MiscParsers.excel2sdf(file);
        Properties properties = new Properties();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringDataframe.getNumRow(); ++i2) {
            String string = stringDataframe.getRowName(i2);
            String string2 = stringDataframe.getElement(i2, 0);
            if (bl && (string2 == null || string2.length() == 0)) {
                throw new RuntimeException("Value must exist. Missing on line: " + i2 + " val: " + string2);
            }
            if (string.length() == 0) {
                throw new RuntimeException("Empty key on line: " + i2);
            }
            if (properties.containsKey(string) && bl2) {
                arrayList.add(string + "\t" + string2);
            }
            properties.setProperty(string, string2);
        }
        if (!arrayList.isEmpty() && bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                stringBuffer.append(arrayList.get(i3)).append('\n');
            }
            throw new RuntimeException("There are repeated keys:" + arrayList.size() + "\n" + arrayList);
        }
        return properties;
    }

    public static final Properties readKeyVal(URL uRL, boolean bl, boolean bl2, boolean bl3) {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        return ParseUtils.readKeyVal(new BufferedReader(inputStreamReader), bl, bl2, bl3);
    }

    public static final Properties readKeyVal(String string, boolean bl, boolean bl2, boolean bl3) {
        BufferedReader bufferedReader = FileUtils.toBufferedReader(string);
        return ParseUtils.readKeyVal(bufferedReader, bl, bl2, bl3);
    }

    public static final Properties readKeyVal(BufferedReader bufferedReader, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Properties properties = new Properties();
        String string = ParseUtils.nextLine(bufferedReader);
        if (bl) {
            string = ParseUtils.nextLine(bufferedReader);
        }
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string != null) {
            String string2;
            object = new StringTokenizer(string, "\t");
            String string3 = null;
            if (((StringTokenizer)object).countTokens() == 2) {
                string2 = ((StringTokenizer)object).nextToken().trim();
                string3 = ((StringTokenizer)object).nextToken().trim();
            } else if (((StringTokenizer)object).countTokens() == 1) {
                string2 = ((StringTokenizer)object).nextToken().trim();
            } else {
                throw new IOException("Bad line format: " + string + " # tokens: " + ((StringTokenizer)object).countTokens() + " line: " + n);
            }
            if (bl2 && (string3 == null || string3.length() == 0)) {
                throw new RuntimeException("Value must exist. Missing on line: " + n + " val: " + string3);
            }
            if (string2.length() == 0) {
                throw new RuntimeException("Empty key on line: " + n);
            }
            if (properties.containsKey(string2) && bl3) {
                arrayList.add(string);
            }
            properties.setProperty(string2, string3);
            string = ParseUtils.nextLine(bufferedReader);
            ++n;
        }
        bufferedReader.close();
        if (!arrayList.isEmpty() && bl3) {
            object = new StringBuffer();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                ((StringBuffer)object).append(arrayList.get(i2)).append('\n');
            }
            throw new RuntimeException("There are repeated keys:" + arrayList.size() + "\n" + arrayList);
        }
        if (n == 0) {
            throw new IllegalArgumentException("Empty input stream!! ");
        }
        return properties;
    }

    public static final List readKeyVal_listarr(File file, boolean bl, boolean bl2) {
        return ParseUtils.readKeyVal_listarr(new BufferedReader(new FileReader(file)), bl, bl2);
    }

    public static final List readKeyVal_listarr(BufferedReader bufferedReader, boolean bl, boolean bl2) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = ParseUtils.nextLine(bufferedReader);
        if (bl) {
            string = ParseUtils.nextLine(bufferedReader);
        }
        int n = 0;
        while (string != null) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string3 = null;
            if (stringTokenizer.countTokens() == 2) {
                string2 = stringTokenizer.nextToken().trim();
                string3 = stringTokenizer.nextToken().trim();
            } else if (stringTokenizer.countTokens() == 1) {
                string2 = stringTokenizer.nextToken().trim();
            } else {
                throw new IOException("Bad line format: " + string + " # tokens: " + stringTokenizer.countTokens() + " line: " + n);
            }
            if (bl2 && (string3 == null || string3.length() == 0)) {
                throw new RuntimeException("Value must exist. Missing on line: " + n + " val: " + string3);
            }
            if (string2.length() == 0) {
                throw new RuntimeException("Empty key on line: " + n);
            }
            arrayList.add(new String[]{string2, string3});
            string = ParseUtils.nextLine(bufferedReader);
            ++n;
        }
        bufferedReader.close();
        if (n == 0) {
            throw new IllegalArgumentException("Empty input stream!! ");
        }
        return arrayList;
    }

    public static final Properties readKeyValReqd(String string) {
        return ParseUtils.readKeyValReqd(FileUtils.toBufferedReader(string));
    }

    public static final Properties readKeyValReqd(File file) {
        return ParseUtils.readKeyValReqd(new BufferedReader(new FileReader(file)));
    }

    public static final Properties readKeyValReqd(URL uRL) {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        return ParseUtils.readKeyValReqd(new BufferedReader(inputStreamReader));
    }

    public static final Properties readKeyValReqd(BufferedReader bufferedReader) {
        Properties properties = new Properties();
        String string = ParseUtils.nextLine(bufferedReader);
        while (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=\t");
            if (stringTokenizer.countTokens() != 2) {
                throw new IOException("Bad line format: " + string);
            }
            properties.setProperty(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            string = ParseUtils.nextLine(bufferedReader);
        }
        bufferedReader.close();
        return properties;
    }

    public static final List readKeyValReqdIntoList(File file) {
        return ParseUtils.readKeyValReqdIntoList(new BufferedReader(new FileReader(file)));
    }

    public static final List readKeyValReqdIntoList(URL uRL) {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        return ParseUtils.readKeyValReqdIntoList(new BufferedReader(inputStreamReader));
    }

    public static final List readKeyValReqdIntoList(BufferedReader bufferedReader) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = ParseUtils.nextLine(bufferedReader);
        while (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=\t");
            if (stringTokenizer.countTokens() != 2) {
                throw new IOException("Bad line format: " + string);
            }
            arrayList.add(new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken()});
            string = ParseUtils.nextLine(bufferedReader);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final List readColumn(int n, File file, boolean bl) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || bl && string.startsWith("#")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=\t");
            if (stringTokenizer.countTokens() < n + 1) {
                throw new IOException("Bad line format, too few columns " + string + "found=" + stringTokenizer.countTokens() + " expecting: " + (n + 1));
            }
            for (int i2 = 0; i2 < n; ++i2) {
                stringTokenizer.nextToken();
            }
            arrayList.add(stringTokenizer.nextToken());
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final List readTabularFile(File file, boolean bl) {
        return ParseUtils.readTabular(file, bl, "\t");
    }

    public static final List readTabularFile(InputStream inputStream, boolean bl) {
        return ParseUtils.readTabular(inputStream, bl, "\t");
    }

    public static final List readTabular(File file, boolean bl, String string) {
        return ParseUtils.readTabular(new FileInputStream(file), bl, string);
    }

    public static final List readTabular(InputStream inputStream, boolean bl, String string) {
        return ParseUtils.readTabular(new BufferedReader(new InputStreamReader(inputStream)), bl, string);
    }

    public static final List readTabular(BufferedReader bufferedReader, boolean bl, String string) {
        String string2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = -999;
        int n2 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
            ++n2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (n == -999) {
                n = stringTokenizer.countTokens();
            } else if (stringArray.length != n) {
                throw new RuntimeException("Bad line: " + n2 + " found ncols: " + stringTokenizer.countTokens() + " expected: " + n + ParseUtils.tabbed(stringTokenizer));
            }
            int n3 = stringTokenizer.countTokens();
            for (int i2 = 0; i2 < n3; ++i2) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(NULL_CHAR)) {
                    string3 = null;
                }
                if (!bl && string3 == null) {
                    throw new RuntimeException("Empty cols set to not allowed but found empty column in line: " + n2 + " >" + string2 + "<");
                }
                stringArray[i2] = string3;
            }
            arrayList.add(stringArray);
        }
        bufferedReader.close();
        return arrayList;
    }

    private static String tabbed(StringTokenizer stringTokenizer) {
        StringBuffer stringBuffer = new StringBuffer(10).append(stringTokenizer.countTokens()).append('\n');
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(">").append(stringTokenizer.nextToken()).append("<\n");
        }
        return stringBuffer.toString();
    }

    public static final Matrix readMatrixFile(File file) {
        List list = ParseUtils.readTabularFile(file, false);
        int n = ((String[])list.get(0)).length;
        Matrix matrix = new Matrix(list.size(), n);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = (String[])list.get(i2);
            if (stringArray.length != n) {
                throw new RuntimeException("Unequal column lengths: " + n + " and: " + stringArray.length);
            }
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                matrix.setElement(i2, i3, Float.parseFloat(stringArray[i3]));
            }
        }
        return matrix;
    }

    public static final String slurp(File file, boolean bl) {
        return ParseUtils.slurp(ParseUtils._buf(file), bl);
    }

    public static final String slurp(URL uRL, boolean bl) {
        return ParseUtils.slurp(ParseUtils._buf(uRL), bl);
    }

    public static final String slurp(BufferedReader bufferedReader, boolean bl) {
        String string;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (bl && string.startsWith("#")) continue;
            string2 = string2.concat(string).concat("\n");
        }
        bufferedReader.close();
        return string2;
    }

    public static final java.util.Vector slurpIntoVector(File file, boolean bl) {
        return ParseUtils.slurpIntoVector(ParseUtils._buf(file), bl);
    }

    public static final java.util.Vector slurpIntoVector(URL uRL, boolean bl) {
        return ParseUtils.slurpIntoVector(ParseUtils._buf(uRL), bl);
    }

    public static final java.util.Vector slurpIntoVector(BufferedReader bufferedReader, boolean bl) {
        String string;
        java.util.Vector<String> vector = new java.util.Vector<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || bl && string.startsWith("#")) continue;
            vector.addElement(string);
        }
        bufferedReader.close();
        return vector;
    }

    public static final List slurpIntoList(File file, boolean bl) {
        return ParseUtils.slurpIntoList(ParseUtils._buf(file), bl);
    }

    public static final String[] slurpIntoStrings(File file, boolean bl) {
        List list = ParseUtils.slurpIntoList(file, bl);
        return list.toArray(new String[list.size()]);
    }

    public static final String[] slurpIntoStringsUnique(File file, boolean bl) {
        String[] stringArray = ParseUtils.slurpIntoStrings(file, bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (arrayList.indexOf(stringArray[i2]) != -1) continue;
            arrayList.add(stringArray[i2]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final List slurpIntoList(URL uRL, boolean bl) {
        return ParseUtils.slurpIntoList(ParseUtils._buf(uRL), bl);
    }

    public static final Set slurpIntoSet(File file, boolean bl) {
        return ParseUtils.slurpIntoSet(ParseUtils._buf(file), bl);
    }

    public static final Set slurpIntoSet(URL uRL, boolean bl) {
        return ParseUtils.slurpIntoSet(ParseUtils._buf(uRL), bl);
    }

    public static final String[] slurpIntoArray(URL uRL, boolean bl) {
        Set set = ParseUtils.slurpIntoSet(ParseUtils._buf(uRL), bl);
        return set.toArray(new String[set.size()]);
    }

    public static final List slurpIntoList(BufferedReader bufferedReader, boolean bl) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || bl && string.startsWith("#")) continue;
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final Set slurpIntoSet(BufferedReader bufferedReader, boolean bl) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || bl && string.startsWith("#")) continue;
            hashSet.add(string);
        }
        bufferedReader.close();
        return hashSet;
    }

    public static final int countLines(File file, boolean bl) {
        return ParseUtils.countLines(ParseUtils._buf(file), bl);
    }

    public static final int countLines(URL uRL, boolean bl) {
        return ParseUtils.countLines(ParseUtils._buf(uRL), bl);
    }

    public static final int countLines(BufferedReader bufferedReader, boolean bl) {
        int n = 0;
        if (!bl) {
            while (bufferedReader.readLine() != null) {
                ++n;
            }
        } else {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.trim().length() > 0) {
                    ++n;
                }
                string = bufferedReader.readLine();
            }
        }
        bufferedReader.close();
        return n;
    }

    public static final int countColumns(File file, int n, boolean bl) {
        return ParseUtils.countColumns(ParseUtils._buf(file), n, bl);
    }

    public static final int countColumns(URL uRL, int n, boolean bl) {
        return ParseUtils.countColumns(ParseUtils._buf(uRL), n, bl);
    }

    public static final int countColumns(BufferedReader bufferedReader, int n, boolean bl) {
        int n2 = 0;
        if (!bl) {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (++n2 != n) continue;
                return ParseUtils._cntLine(string);
            }
        } else {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.trim().length() > 0) {
                    ++n2;
                }
                if (n2 == n) {
                    return ParseUtils._cntLine(string);
                }
                string = bufferedReader.readLine();
            }
        }
        bufferedReader.close();
        return n2;
    }

    private static int _cntLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        return stringTokenizer.countTokens();
    }

    public static final String nextLine(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        string = string.trim();
        while (string != null && (string.length() == 0 || string.startsWith("#"))) {
            string = bufferedReader.readLine();
            if (string == null) continue;
            string = string.trim();
        }
        return string;
    }

    public static final Map slurpByColumnIntoHashWithValueStringed(File file, boolean bl, String string) {
        return ParseUtils.slurpByColumnIntoHashWithValueStringed(ParseUtils._buf(file), bl, string);
    }

    public static final Map slurpByColumnIntoHashWithValueStringed(URL uRL, boolean bl, String string) {
        return ParseUtils.slurpByColumnIntoHashWithValueStringed(ParseUtils._buf(uRL), bl, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Map slurpByColumnIntoHashWithValueStringed(BufferedReader bufferedReader, boolean bl, String string) {
        List list = ParseUtils.slurpIntoList(bufferedReader, true);
        int n = 1;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2;
            String string3 = list.get(i2).toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string);
            int n2 = stringTokenizer.countTokens();
            String string4 = stringTokenizer.nextToken();
            String string5 = "";
            if (n2 == 1) {
                if (!bl) throw new IllegalArgumentException("Bad format -- missing B column at: " + n);
                klog.warn("Only 1 token on line: " + n + " >" + string4);
            } else {
                if (n2 != 2) throw new IllegalArgumentException("Bad format on line: " + string3 + "< expecting 1 or 2 tokens but got: " + n2);
                string5 = stringTokenizer.nextToken();
            }
            if (!bl) {
                string2 = string4;
                string4 = string5;
                string5 = string2;
            }
            string2 = hashMap.get(string4);
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null) {
                stringBuffer = stringBuffer.append(string2.toString()).append(string);
            }
            stringBuffer.append(string5);
            hashMap.put(string4, stringBuffer.toString());
            ++n;
        }
        return hashMap;
    }

    public static final Map slurpByColumnIntoHashWithValueAsSet(File file, boolean bl, String string) {
        return ParseUtils.slurpByColumnIntoHashWithValueAsSet(ParseUtils._buf(file), bl, string);
    }

    public static final Map slurpByColumnIntoHashWithValueAsSet(URL uRL, boolean bl, String string) {
        return ParseUtils.slurpByColumnIntoHashWithValueAsSet(ParseUtils._buf(uRL), bl, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Map slurpByColumnIntoHashWithValueAsSet(BufferedReader bufferedReader, boolean bl, String string) {
        List list = ParseUtils.slurpIntoList(bufferedReader, true);
        int n = 1;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object;
            String string2 = list.get(i2).toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
            int n2 = stringTokenizer.countTokens();
            String string3 = stringTokenizer.nextToken();
            String string4 = "";
            if (n2 == 1) {
                if (!bl) throw new IllegalArgumentException("Bad format -- missing B column at: " + n);
                klog.warn("Only 1 token on line: " + n + " >" + string3);
            } else {
                if (n2 != 2) throw new IllegalArgumentException("Bad format on line: " + string2 + "< expecting 1 or 2 tokens but got: " + n2);
                string4 = stringTokenizer.nextToken();
            }
            if (!bl) {
                object = string3;
                string3 = string4;
                string4 = object;
            }
            if ((object = hashMap.get(string3)) == null) {
                object = new HashSet();
            }
            ((Set)object).add(string4);
            hashMap.put(string3, object);
            ++n;
        }
        return hashMap;
    }

    private static BufferedReader _buf(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("Parameter url cannot be null");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        return new BufferedReader(inputStreamReader);
    }

    private static BufferedReader _buf(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        return new BufferedReader(new FileReader(file));
    }

    public static final String getFirstNonWsLine(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() > 0) {
            return string;
        }
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            return null;
        } while ((string = string.trim()).length() <= 0);
        return string;
    }

    public static final String getFirstNonWsLine(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        return ParseUtils.getFirstNonWsLine(new BufferedReader(new InputStreamReader(fileInputStream)));
    }

    public static final String findLastCommentLine(File file) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = null;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            if (string.startsWith("#")) {
                string2 = string;
            }
            if (++n <= 20) continue;
        }
        bufferedReader.close();
        return string2;
    }

    public static final String[] string2strings_csv(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        do {
            stringBuffer.setLength(0);
            if (n < string.length() && string.charAt(n) == '\"') {
                ++n;
                n = ParseUtils.advQuoted_for_csv(string, stringBuffer, n);
            } else {
                n = ParseUtils.advPlain_for_csv(string, stringBuffer, n);
            }
            arrayList.add(stringBuffer.toString());
        } while (++n < string.length());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final List string2stringsList_csv(String string) {
        String[] stringArray = ParseUtils.string2strings_csv(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    private static int advQuoted_for_csv(String string, StringBuffer stringBuffer, int n) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3; ++n2) {
            if (string.charAt(n2) == '\"' && n2 + 1 < n3) {
                if (string.charAt(n2 + 1) == '\"') {
                    ++n2;
                } else if (string.charAt(n2 + 1) == ',') {
                    ++n2;
                    break;
                }
            } else if (string.charAt(n2) == '\"' && n2 + 1 == n3) break;
            stringBuffer.append(string.charAt(n2));
        }
        return n2;
    }

    private static int advPlain_for_csv(String string, StringBuffer stringBuffer, int n) {
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            stringBuffer.append(string.substring(n));
            return string.length();
        }
        stringBuffer.append(string.substring(n, n2));
        return n2;
    }
}

