/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ResParser
extends AbstractParser {
    public ResParser() {
        super(Dataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        int n;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        Dataset dataset = (Dataset)persistentObject;
        APMMatrix aPMMatrix = null;
        if (dataset instanceof DefaultDataset) {
            aPMMatrix = ((DefaultDataset)dataset).getAPMMatrix();
        }
        FeatureAnnot featureAnnot = dataset.getAnnot().getFeatureAnnot();
        printWriter.print("DESCRIPTION\tNAME\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print(dataset.getColumnName(n) + '\t');
            if (n == dataset.getNumCol() - 1) continue;
            printWriter.print('\t');
        }
        printWriter.println();
        printWriter.println("");
        printWriter.println(dataset.getNumRow());
        for (n = 0; n < dataset.getNumRow(); ++n) {
            String string = dataset.getRowName(n);
            String string2 = "na";
            if (featureAnnot != null) {
                string2 = featureAnnot.hasNativeDescriptions() ? featureAnnot.getNativeDesc(string) : featureAnnot.getGeneSymbol(string) + ":" + featureAnnot.getGeneTitle(string);
            }
            printWriter.print(string2);
            printWriter.print('\t');
            printWriter.print(string);
            printWriter.print('\t');
            Vector vector = dataset.getRow(n);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < vector.getSize(); ++i2) {
                if (aPMMatrix == null) {
                    stringBuffer.append(vector.getElement(i2)).append('\t').append('P');
                } else {
                    stringBuffer.append(vector.getElement(i2)).append('\t').append(aPMMatrix.getElement_char(n, i2));
                }
                if (i2 == vector.getSize()) continue;
                stringBuffer.append('\t');
            }
            printWriter.println(stringBuffer.toString());
        }
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        Object object;
        Object object2;
        this.startImport(string);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2.startsWith("#")) {
            stringBuffer.append(string2).append('\n');
            string2 = bufferedReader.readLine();
        }
        ++n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 9;
        char[] cArray = new char[1];
        if (string2.length() > 0) {
            cArray[0] = n2 = (int)ParseUtils.getDelim(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, new String(cArray));
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        bufferedReader.readLine();
        ++n;
        string2 = bufferedReader.readLine();
        ++n;
        int n3 = 0;
        int n4 = arrayList.size();
        try {
            object2 = string2.trim();
            n3 = Integer.parseInt((String)object2);
            string2 = bufferedReader.readLine();
            ++n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.info("Found meg data as numRows:" + n3 + " numCols:" + n4);
        object2 = new ArrayList(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            object2.add(arrayList.get(i2));
        }
        Matrix matrix = new Matrix(n3, n4);
        APMMatrix aPMMatrix = new APMMatrix(n3, n4);
        ArrayList<String> arrayList2 = new ArrayList<String>(n3);
        ArrayList<Object> arrayList3 = new ArrayList<Object>(n3);
        int n5 = 0;
        while (string2 != null) {
            if (string2.length() == 0) {
                string2 = bufferedReader.readLine();
                continue;
            }
            int n6 = string2.indexOf(n2);
            this.checkIndex(n6, n);
            object = string2.substring(0, n6);
            int n7 = string2.indexOf(n2, n6 + 1);
            this.checkIndex(n7, n);
            String string3 = string2.substring(n6 + 1, n7);
            arrayList2.add(string3);
            float[] fArray = new float[n4];
            float[] fArray2 = new float[n4];
            n6 = n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                n7 = string2.indexOf(n2, n6 + 1);
                this.checkIndex(n7, n);
                String string4 = string2.substring(n6 + 1, n7);
                fArray[i3] = Float.valueOf(string4).floatValue();
                String string5 = string2.substring(n6 + 1 + string4.length() + 1, n6 + 1 + string4.length() + 1 + 1);
                fArray2[i3] = APMMatrix.valueOf(string5);
                n6 = string2.indexOf(n2, n7 + 1);
            }
            matrix.setRow(n5, fArray);
            aPMMatrix.setRow(n5, fArray2);
            arrayList3.add(object);
            ++n5;
            string2 = bufferedReader.readLine();
            ++n;
        }
        this.doneImport();
        FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl(string, arrayList2, arrayList3);
        featureAnnotImpl.addComment(this.fComment.toString());
        object = new SampleAnnotImpl(string, (List)object2, null);
        DefaultDataset defaultDataset = new DefaultDataset(string, matrix, arrayList2, (List)object2, true, (Annot)new AnnotImpl(featureAnnotImpl, (SampleAnnot)object), aPMMatrix);
        defaultDataset.addComment(this.fComment.toString());
        System.out.println(">>>>> DONE PARSING: " + aPMMatrix.getQuickInfo());
        return ResParser.unmodlist(new PersistentObject[]{defaultDataset});
    }

    private void checkIndex(int n, int n2) {
        if (n < 0) {
            throw new ParserException("Invalid line index=" + n + " . Expecting ind >=0 " + " on line: " + n2);
        }
    }
}

