/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TxtDatasetParser
extends AbstractParser {
    public TxtDatasetParser() {
        super(Dataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        int n;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        Dataset dataset = (Dataset)persistentObject;
        FeatureAnnot featureAnnot = dataset.getAnnot().getFeatureAnnot();
        printWriter.print("NAME\tDESCRIPTION\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print(dataset.getColumnName(n));
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataset.getNumRow(); ++n) {
            String string = dataset.getRowName(n);
            printWriter.print(string);
            printWriter.print('\t');
            String string2 = featureAnnot.getNativeDesc(string);
            if (string2 != null) {
                printWriter.print(string2);
            } else {
                printWriter.print("na");
            }
            printWriter.print('\t');
            printWriter.println(dataset.getRow(n).toString('\t'));
        }
        printWriter.close();
        this.doneExport();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parse(string, bufferedReader);
    }

    public final List parse(String string, BufferedReader bufferedReader) {
        string = NamingConventions.removeExtension(string);
        String string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        list.remove(0);
        boolean bl = false;
        if (list.get(0).toString().equalsIgnoreCase("DESCRIPTION") || list.get(0).toString().equalsIgnoreCase("DESC")) {
            list.remove(0);
            bl = true;
        }
        this.log.debug("HAS DESC: " + bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        string2 = this.nextLineTrimless(bufferedReader);
        while (string2 != null) {
            arrayList.add(string2);
            string2 = this.nextLineTrimless(bufferedReader);
        }
        bufferedReader.close();
        if (bl) {
            return this._parseHasDesc(string, arrayList, list);
        }
        return this._parseNoDesc(string, arrayList, list);
    }

    private List _parseNoDesc(String string, List list, List list2) {
        Object object;
        Object object2;
        string = NamingConventions.removeExtension(string);
        Matrix matrix = new Matrix(list.size(), list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = (String)list.get(i2);
            object = TxtDatasetParser.string2stringsV2((String)object2, list2.size() + 1);
            if (object.size() != list2.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (list2.size() + 1) + " but found: " + object.size() + " on line >" + (String)object2 + "<\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String string2 = object.get(0).toString().trim();
            if (string2.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + i2 + " >" + (String)object2);
            }
            String string3 = "na";
            arrayList2.add(string3);
            arrayList.add(string2);
            int n = 0;
            for (int i3 = 1; i3 < object.size(); ++i3) {
                float f2;
                String string4 = object.get(i3).toString().trim();
                if (string4.length() == 0) {
                    f2 = Float.NaN;
                } else {
                    try {
                        f2 = Float.parseFloat(string4);
                    }
                    catch (Exception exception) {
                        System.out.println(">" + string4 + "<");
                        throw exception;
                    }
                }
                matrix.setElement(i2, n++, f2);
            }
        }
        FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl(string, arrayList, arrayList2);
        featureAnnotImpl.addComment(this.fComment.toString());
        object2 = new SampleAnnotImpl(string, list2, null);
        object = new DefaultDataset(string, matrix, arrayList, list2, true, (Annot)new AnnotImpl(featureAnnotImpl, (SampleAnnot)object2));
        object.addComment(this.fComment.toString());
        this.doneImport();
        return TxtDatasetParser.unmodlist(new PersistentObject[]{object});
    }

    private List _parseHasDesc(String string, List list, List list2) {
        Object object;
        Object object2;
        string = NamingConventions.removeExtension(string);
        Matrix matrix = new Matrix(list.size(), list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = (String)list.get(i2);
            object = TxtDatasetParser.string2stringsV2((String)object2, list2.size() + 2);
            if (object.size() != list2.size() + 2) {
                throw new ParserException("Bad format - expect ncols: " + (list2.size() + 2) + " but found: " + object.size() + " on line >" + (String)object2 + "<\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String string2 = object.get(0).toString().trim();
            if (string2.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + i2 + " >" + (String)object2);
            }
            String string3 = object.get(1).toString().trim();
            if (string3.length() == 0) {
                throw new ParserException("Bad rowname - cant have empty desc at: " + i2 + " >" + (String)object2);
            }
            arrayList2.add(string3);
            arrayList.add(string2);
            int n = 0;
            for (int i3 = 2; i3 < object.size(); ++i3) {
                float f2;
                String string4 = object.get(i3).toString().trim();
                if (string4.length() == 0) {
                    f2 = Float.NaN;
                } else {
                    try {
                        f2 = Float.parseFloat(string4);
                    }
                    catch (Exception exception) {
                        System.out.println(">" + string4 + "<");
                        throw exception;
                    }
                }
                matrix.setElement(i2, n++, f2);
            }
        }
        FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl(string, arrayList, arrayList2);
        featureAnnotImpl.addComment(this.fComment.toString());
        object2 = new SampleAnnotImpl(string, list2, null);
        object = new DefaultDataset(string, matrix, arrayList, list2, true, (Annot)new AnnotImpl(featureAnnotImpl, (SampleAnnot)object2));
        object.addComment(this.fComment.toString());
        this.doneImport();
        return TxtDatasetParser.unmodlist(new PersistentObject[]{object});
    }
}

