/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.charts.XChartUtils;
import edu.mit.broad.genome.math.ColorScheme;
import edu.mit.broad.genome.math.ColorSchemes$BroadCancerBlue;
import edu.mit.broad.genome.math.ColorSchemes$BroadCancerRed;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.models.MiscChartModels$GaddyPlotModel;
import edu.mit.broad.genome.models.MiscChartModels$GaddyPlotModelMulti2;
import edu.mit.broad.genome.models.MiscChartModels$StateFoldChangeByGexPlotModelMulti2;
import edu.mit.broad.genome.models.XChartModelFactory$XYSeriesCollImpl;
import edu.mit.broad.genome.models.XYDatasetProxy;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.reports.api.ToolReport;
import java.io.File;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.statistics.HistogramType;

public class DatasetCharts {
    private static final Logger klog = XLogger.getLogger(DatasetCharts.class);
    static ColorScheme RED = new ColorSchemes$BroadCancerRed();
    static ColorScheme BLUE = new ColorSchemes$BroadCancerBlue();

    private DatasetCharts() {
    }

    public final XChart createGexScatterPlot(Dataset dataset, int n, int n2) {
        XYDatasetProxy xYDatasetProxy = new XYDatasetProxy("Scatter " + dataset.getName(), dataset.getColumn(n), dataset.getColumn(n2));
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(dataset.getName() + " [ " + dataset.getNumRow() + "R x " + dataset.getNumCol() + "C ]", "expression for " + dataset.getColumnName(n), "expression for " + dataset.getColumnName(n2), xYDatasetProxy, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        return new XChartImpl(dataset.getName() + "_scatter_plot", "XY plot for: " + dataset.getName(), jFreeChart);
    }

    public static final XChart createGaddyPlot(String string, Dataset dataset, GeneSet geneSet, ToolReport toolReport, File file) {
        return DatasetCharts.createGaddyPlot(string, dataset, new GeneSet[]{geneSet}, toolReport, file);
    }

    public static final XChart createGaddyPlot(String string, Dataset dataset, GeneSet[] geneSetArray, ToolReport toolReport, File file) {
        MiscChartModels$GaddyPlotModelMulti2 miscChartModels$GaddyPlotModelMulti2 = new MiscChartModels$GaddyPlotModelMulti2(dataset, geneSetArray);
        if (toolReport != null) {
            for (int i2 = 0; i2 < miscChartModels$GaddyPlotModelMulti2.getSeriesCount(); ++i2) {
                toolReport.savePageDF(miscChartModels$GaddyPlotModelMulti2.getSeriesName(i2), miscChartModels$GaddyPlotModelMulti2.getSeriesDF(i2), file);
            }
        }
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(string + " [ " + dataset.getNumRow() + "R x " + dataset.getNumCol() + "C ]", "mean of log2 (expression)", "stdev of log2 expression", miscChartModels$GaddyPlotModelMulti2, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.getRenderer(0).setToolTipGenerator(miscChartModels$GaddyPlotModelMulti2.createXYToolTipGenerator());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        return new XChartImpl(string + "_gaddy_plot", "Gaddy plot for: " + dataset.getName(), jFreeChart);
    }

    public static final XChart createGaddyPlot(String string, Dataset dataset, ToolReport toolReport, File file) {
        MiscChartModels$GaddyPlotModel miscChartModels$GaddyPlotModel = new MiscChartModels$GaddyPlotModel(dataset);
        if (toolReport != null) {
            toolReport.savePageDF(miscChartModels$GaddyPlotModel.getSeriesName(0), miscChartModels$GaddyPlotModel.getSeriesDF(), file);
        }
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(string + " [ " + dataset.getNumRow() + "R x " + dataset.getNumCol() + "C ]", "mean of log2 (expression)", "stdev of log2 expression", miscChartModels$GaddyPlotModel, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.getRenderer(0).setToolTipGenerator(miscChartModels$GaddyPlotModel.createXYToolTipGenerator());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        return new XChartImpl(string + "_gaddy_plot", "Gaddy plot for: " + dataset.getName(), jFreeChart);
    }

    public static final XChart createStateFoldChange_by_gex_plot(String string, Dataset dataset, GeneSet[] geneSetArray, boolean bl, ToolReport toolReport, File file) {
        MiscChartModels$StateFoldChangeByGexPlotModelMulti2 miscChartModels$StateFoldChangeByGexPlotModelMulti2 = new MiscChartModels$StateFoldChangeByGexPlotModelMulti2(dataset, geneSetArray, bl);
        if (toolReport != null) {
            for (int i2 = 0; i2 < miscChartModels$StateFoldChangeByGexPlotModelMulti2.getSeriesCount(); ++i2) {
                toolReport.savePageDF(miscChartModels$StateFoldChangeByGexPlotModelMulti2.getSeriesName(i2), miscChartModels$StateFoldChangeByGexPlotModelMulti2.getSeriesDF(i2), file);
            }
        }
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(string + " [ " + dataset.getNumRow() + "R x " + dataset.getNumCol() + "C ]", "mean of log2 (expression)", "log2 (max/min) expression", miscChartModels$StateFoldChangeByGexPlotModelMulti2, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.getRenderer(0).setToolTipGenerator(miscChartModels$StateFoldChangeByGexPlotModelMulti2.createXYToolTipGenerator());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        return new XChartImpl(string + "_statefc_plot", "State Fold Change plot for: " + dataset.getName(), jFreeChart);
    }

    public static final XChart createNullDistribPlot(String string, float f2, Vector vector) {
        int n = 20;
        JFreeChart jFreeChart = XChartUtils.createHistogram("Null distribution for " + string, false, "Real score", "# of random values", vector, true, n, HistogramType.FREQUENCY);
        return new XChartImpl(string, "Histogram of random scores (real = " + f2 + " )", jFreeChart);
    }

    public static final XChart createAlignmentChart(String string, String string2, String[] stringArray, Vector vector, Vector vector2) {
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
        NumberAxis numberAxis2 = new NumberAxis("y");
        XChartModelFactory$XYSeriesCollImpl xChartModelFactory$XYSeriesCollImpl = new XChartModelFactory$XYSeriesCollImpl(stringArray, vector, vector2);
        XYPlot xYPlot = new XYPlot(xChartModelFactory$XYSeriesCollImpl, numberAxis, numberAxis2, standardXYItemRenderer);
        return new XChartImpl("alignment_chart", string, "some alignment", xYPlot, false);
    }
}

