/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.DatasetStatsCore;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors$None;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.VectorFunctor$Statistic;
import edu.mit.broad.genome.math.VectorFunctors;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GenesOfInterest$Gene;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.DefaultMetricWeightStruc;
import edu.mit.broad.genome.reports.MiscReports$MarkerReportStruc;
import edu.mit.broad.genome.reports.NullSafeStringBuffer;
import edu.mit.broad.genome.reports.RankedListCharts;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.NullSymbolMode;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.xbench.heatmap.GramImager;
import gnu.trove.TIntObjectHashMap;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import xapps.api.vtools.viewers.VizFactory;

public class MiscReports {
    private static final transient Logger klog = XLogger.getLogger(MiscReports.class);

    private MiscReports() {
    }

    public static final StringDataframe createRankedListsReport(String string, RankedList[] rankedListArray, Chip chip) {
        String string2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("GENE");
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            arrayList.add(rankedListArray[i2].getName() + "_score");
            arrayList.add(rankedListArray[i2].getName() + "_rank");
        }
        List list = rankedListArray[0].getRankedNames();
        StringMatrix stringMatrix = new StringMatrix(list.size(), arrayList.size());
        for (n = 0; n < list.size(); ++n) {
            string2 = list.get(n).toString();
            stringMatrix.setElement(n, 0, chip.getSymbol(string2, Chip.OMIT_NULLS));
        }
        for (n = 0; n < list.size(); ++n) {
            string2 = list.get(n).toString();
            int n2 = 1;
            for (int i3 = 0; i3 < rankedListArray.length; ++i3) {
                stringMatrix.setElement(n, n2++, rankedListArray[i3].getScore(string2));
                stringMatrix.setElement(n, n2++, rankedListArray[i3].getRank(string2));
            }
        }
        return new StringDataframe(string, stringMatrix, list, arrayList, true);
    }

    public static final StringDataframe createSizeReport(GeneSetMatrixPair geneSetMatrixPair, Chip chip, NullSymbolMode nullSymbolMode) {
        String[] stringArray = new String[]{"#PROBES_UP", "#PROBES_DN", "#GENES_UP", "#GENES_DN"};
        GeneSetMatrixPair geneSetMatrixPair2 = chip.getSymbols(geneSetMatrixPair, nullSymbolMode);
        StringMatrix stringMatrix = new StringMatrix(geneSetMatrixPair.getSize(), stringArray.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < geneSetMatrixPair.getSize(); ++i2) {
            int n = 0;
            arrayList.add(geneSetMatrixPair.get(i2).getName());
            stringMatrix.setElement(i2, n++, geneSetMatrixPair.get(i2).getUp().getNumMembers());
            stringMatrix.setElement(i2, n++, geneSetMatrixPair.get(i2).getDown().getNumMembers());
            stringMatrix.setElement(i2, n++, geneSetMatrixPair2.get(i2).getUp().getNumMembers());
            stringMatrix.setElement(i2, n, geneSetMatrixPair2.get(i2).getDown().getNumMembers());
        }
        return new StringDataframe("gmp_report", stringMatrix, arrayList, stringArray, true, true);
    }

    public static final String toString(GenesOfInterest$Gene genesOfInterest$Gene, char c2) {
        NullSafeStringBuffer nullSafeStringBuffer = new NullSafeStringBuffer(false);
        return nullSafeStringBuffer.append(genesOfInterest$Gene.getNotes()).toString();
    }

    public static final void appendBpogs(Dataset[] datasetArray, Template[] templateArray, GeneSet geneSet, HtmlPage htmlPage) {
        GramImager gramImager = VizFactory.createGramImager();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            htmlPage.addImage(datasetArray[i2].getName(), "some image", gramImager.createBpogImage(datasetArray[i2], templateArray[i2], geneSet));
        }
    }

    public static final String[] toSymbolStringArray(Set set) {
        return MiscReports.toSymbolStrings(set.toArray(new Gene[set.size()]));
    }

    public static final String[] toTitleStringArray(Set set) {
        return MiscReports.toTitleStrings(set.toArray(new Gene[set.size()]));
    }

    public static final String[] toSymbolStrings(Gene[] geneArray) {
        String[] stringArray = new String[geneArray.length];
        for (int i2 = 0; i2 < geneArray.length; ++i2) {
            stringArray[i2] = geneArray[i2].getSymbol();
        }
        return stringArray;
    }

    public static final String[] toTitleStrings(Gene[] geneArray) {
        String[] stringArray = new String[geneArray.length];
        for (int i2 = 0; i2 < geneArray.length; ++i2) {
            stringArray[i2] = geneArray[i2].getTitle();
        }
        return stringArray;
    }

    public static final String toGeneSymbolTitle(Set set) {
        if (set.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Gene gene : set) {
            stringBuffer.append(gene.getSymbol()).append('\t').append(gene.getTitle()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final MiscReports$MarkerReportStruc createMarkerStatsReport(Dataset dataset, Template template) {
        return MiscReports.createMarkerStatsReport(dataset, template, new LabelledVectorProcessors$None());
    }

    public static final MiscReports$MarkerReportStruc createMarkerStatsReport(Dataset dataset, Template template, LabelledVectorProcessor labelledVectorProcessor) {
        Metric[] metricArray = Metrics.createAllCategoricalMetrics();
        Map map = DatasetMetrics.getDefaultMetricParams();
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        DatasetGenerators datasetGenerators = new DatasetGenerators();
        Dataframe dataframe = datasetMetrics.calcUNSOMetrics(metricArray, map, labelledVectorProcessor, dataset, template);
        MiscReports$MarkerReportStruc miscReports$MarkerReportStruc = new MiscReports$MarkerReportStruc();
        miscReports$MarkerReportStruc.between_class = dataframe;
        miscReports$MarkerReportStruc.within_class = new Dataframe[template.getNumClasses()];
        DatasetStatsCore datasetStatsCore = new DatasetStatsCore();
        VectorFunctor$Statistic[] vectorFunctor$StatisticArray = VectorFunctors.createAllStats();
        for (int i2 = 0; i2 < template.getNumClasses(); ++i2) {
            Dataset dataset2 = datasetGenerators.extract(dataset, template.getClass(i2));
            miscReports$MarkerReportStruc.within_class[i2] = datasetStatsCore.calcRowStatsDf(vectorFunctor$StatisticArray, dataset2);
        }
        return miscReports$MarkerReportStruc;
    }

    public static final HtmlPage createDatasetHeatMapAndCorrelationPlots(Dataset dataset, Template template, RankedList rankedList, int n) {
        String string;
        Object object;
        HtmlPage htmlPage = new HtmlPage("heat_map_corr_plot", "Heat map and correlation plot for " + rankedList.getName());
        htmlPage.addBreak();
        htmlPage.addHtml("&nbsp&nbsp");
        if (dataset != null) {
            try {
                object = MiscReports.createHeatMap(dataset, template, rankedList, n);
                htmlPage.addImage("heat_map", "Heat Map of the top " + n + " features for each phenotype in " + dataset.getName(), (BufferedImage)object);
            }
            catch (Throwable throwable) {
                htmlPage.addError("Trouble making heat map", throwable);
                throwable.printStackTrace();
            }
        }
        htmlPage.addBreak();
        htmlPage.addHtml("&nbsp&nbsp");
        if (template == null) {
            object = "classA";
            string = "classB";
        } else {
            object = template.getClassName(0);
            string = template.getClassName(1);
        }
        XChart xChart = RankedListCharts.createRankedListChart(rankedList, (String)object, string, true);
        htmlPage.addChart(xChart, 500, 400);
        htmlPage.addBreak();
        return htmlPage;
    }

    public static final BufferedImage createHeatMap(Dataset dataset, Template template, RankedList rankedList, int n) {
        List list = rankedList.getNamesOfUpOrDnXRanks(n, true);
        list.addAll(rankedList.getNamesOfUpOrDnXRanks(n, false));
        Dataset dataset2 = new DatasetGenerators().extractRows(dataset, list);
        return VizFactory.createGramImager().createBpogImage(dataset2, template);
    }

    public static final StringDataframe createRandomLengthAndWeightReport(String string, Dataset dataset) {
        String[] stringArray = new String[]{"POS_FRACTION_LENGTH", "POS_WEIGHT_FRACTION"};
        StringMatrix stringMatrix = new StringMatrix(dataset.getNumCol(), stringArray.length);
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            DefaultMetricWeightStruc defaultMetricWeightStruc = new DefaultMetricWeightStruc(string, dataset.getColumn(i2));
            stringMatrix.setElement(i2, 0, defaultMetricWeightStruc.getTotalPosLength_frac());
            stringMatrix.setElement(i2, 1, defaultMetricWeightStruc.getTotalPosWeight_frac());
        }
        return new StringDataframe("rnd_metrics_info", stringMatrix, stringArray, true);
    }

    public static final Dataframe annotateProbesNames(Dataframe dataframe, Chip chip) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(dataframe.getNumRow());
            for (int i2 = 0; i2 < dataframe.getNumRow(); ++i2) {
                String string = dataframe.getRowName(i2);
                if (chip.isProbe(string)) {
                    Gene gene = chip.getHugo(string);
                    string = gene.getSymbol() + "_" + string;
                }
                arrayList.add(string);
            }
            return new Dataframe(dataframe.getName(), dataframe.getMatrix(), arrayList, dataframe.getColumnNames(), true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return dataframe;
        }
    }

    public static final RichDataframe annotateProbesNames(String string, RankedList rankedList, FeatureAnnot featureAnnot) {
        String[] stringArray = new String[]{"DESCRIPTION", "GENE_SYMBOL", "GENE_TITLE", "SCORE"};
        StringMatrix stringMatrix = new StringMatrix(rankedList.getSize(), stringArray.length);
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            int n = 0;
            String string2 = rankedList.getRankName(i2);
            if (featureAnnot != null) {
                stringMatrix.setElement(i2, n++, featureAnnot.getNativeDesc(string2));
                stringMatrix.setElement(i2, n++, featureAnnot.getGeneSymbol(string2));
                stringMatrix.setElement(i2, n++, featureAnnot.getGeneTitle(string2));
            } else {
                n += 3;
            }
            stringMatrix.setElement(i2, n, Float.toString(rankedList.getScore(i2)));
            tIntObjectHashMap.put(stringMatrix.getElementPos(i2, 0), LinkedFactory.createLinkedProbeSet(string2));
            if (featureAnnot == null || featureAnnot.getGeneSymbol(string2) == null) continue;
            tIntObjectHashMap.put(stringMatrix.getElementPos(i2, 1), LinkedFactory.createLinkedGeneSymbol(featureAnnot.getGeneSymbol(string2)));
        }
        StringDataframe stringDataframe = new StringDataframe(string, stringMatrix, rankedList.getRankedNames(), stringArray, true, true);
        return new RichDataframe(stringDataframe, null, null, tIntObjectHashMap);
    }
}

