/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.api;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.Printf$Full;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.distrib.RangeUtils;
import edu.mit.broad.genome.alg.filters.FilteredDataset;
import edu.mit.broad.genome.alg.filters.FilteredDatasetImpl_only_genes;
import edu.mit.broad.genome.alg.gsea.DefaultGseaSignalMatrix;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XComboDomainChart;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.SignalMatrix;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFromAnnot;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ReportWriter;
import edu.mit.broad.genome.reports.api.ToolComments;
import edu.mit.broad.genome.reports.api.ToolReport$Pages;
import edu.mit.broad.genome.reports.api.ToolReportDisplay;
import edu.mit.broad.genome.reports.pages.FileWrapperPage;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.genome.utils.ImageUtils;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.genome.utils.Zipper;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.core.api.Application;
import gnu.trove.TFloatIntHashMap;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TIntFloatHashMap;
import gnu.trove.TIntFloatIterator;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import gnu.trove.TObjectFloatHashMap;
import gnu.trove.TObjectFloatIterator;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ecs.Element;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import xtools.api.Tool;
import xtools.api.param.DataFormatChooser;
import xtools.api.param.GeneSetMatrixFormatParam;
import xtools.api.param.ReportLabelParam;

public class ToolReport
implements Report,
ReportWriter {
    private transient Logger log = XLogger.getLogger(this.getClass());
    private static transient Logger klog = XLogger.getLogger(ToolReport.class);
    private static String COMMON_ERROR_PREFIX = "The Tool ran successfully but at least one part of the reports production failed\nwith the following details\nThe reports is INcomplete";
    private Tool fTool_opt;
    private Class fProducerClass;
    private String fProducerName;
    private File fReportDir;
    private ToolComments fToolComments;
    private final long fTimestamp = System.currentTimeMillis();
    private boolean fClosed = false;
    private int fNumPagesAdded;
    private String fReportName;
    private File fReportParamsFile;
    private List fErrors;
    private ToolReport$Pages fPages;
    private boolean fDoneAddingCss;
    private boolean fRptDirMadeExternally = false;
    private KeyValTable fKvt;
    private HtmlReportIndexPage fHtmlReportIndexPage;
    private File fHtmlIndexPageFile;
    private ReportIndexState fReportIndexState;
    private String fOptWebBase;
    private Element fKvt_key_col_header;
    private Element fKvt_value_col_header;
    private Properties prp;

    public ToolReport(Tool tool, boolean bl, ReportIndexState reportIndexState) {
        if (tool == null) {
            throw new IllegalArgumentException("Parameter reportForTool cannot be null");
        }
        if (tool.getParamSet().getAnalysisDirParam() == null) {
            throw new IllegalArgumentException("Specified tool does not have a declared fAnalysisDirParam(-out) -- cannot generate Report!");
        }
        File file = tool.getParamSet().getAnalysisDirParam().getAnalysisDir();
        File file2 = ToolReport.createIfNeededAndGetReportDir(file, tool, this);
        this.init(tool, bl, file2, reportIndexState);
    }

    public ToolReport(Tool tool, boolean bl, File file, ReportIndexState reportIndexState) {
        this.init(tool, bl, file, reportIndexState);
        this.fRptDirMadeExternally = true;
    }

    private void init(Tool tool, boolean bl, File file, ReportIndexState reportIndexState) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Report dir does not exists!!: " + file.getAbsolutePath());
        }
        this.fReportDir = file;
        this.fToolComments = new ToolComments();
        if (tool != null) {
            this.fProducerClass = tool.getClass();
            this.fProducerName = tool.getName();
            if (bl) {
                this.fTool_opt = tool;
            }
            if (tool.getParamSet().getReportLabelParam() == null) {
                throw new IllegalArgumentException("Specified tool does not have a declared ReportLabelParam -- check Tool!");
            }
            this.fReportName = ToolReport.generateReportName(this, tool);
            this.fReportParamsFile = new File(this.fReportDir, this.fReportName);
        }
        this.fPages = new ToolReport$Pages();
        this.fReportIndexState = reportIndexState;
        if (this.fReportIndexState.makeReportIndexPage()) {
            this.fHtmlReportIndexPage = new HtmlReportIndexPage(this, this.fReportIndexState.getHeader());
        }
    }

    private static String generateReportName(Report report, Tool tool) {
        ReportLabelParam reportLabelParam = tool.getParamSet().getReportLabelParam();
        String string = reportLabelParam.getReportLabel();
        if (string == null) {
            string = "my_report";
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(tool.getName(), ".");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append('.').append(string2).append('.').append(report.getTimestamp()).append('.');
        stringBuffer.append(DataFormat.RPT_FORMAT.getExtension());
        return stringBuffer.toString();
    }

    public final File getZipReportFile() {
        return new File(this.getReportDir(), this.getName() + ".zip");
    }

    public final File zipReport() {
        File file = this.getZipReportFile();
        try {
            File file2 = File.createTempFile(this.getName(), ".zip");
            Zipper zipper = new Zipper();
            zipper.zipIt(this.fReportDir, file2);
            file2.renameTo(file);
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
            FileUtils.writeSafely(throwable.getMessage(), file);
        }
        return file;
    }

    @Override
    public final URI getReportIndex() {
        if (this.fHtmlIndexPageFile == null) {
            return null;
        }
        return this.fHtmlIndexPageFile.toURI();
    }

    public final File getParamsFile() {
        return new File(this.fReportParamsFile.getPath());
    }

    @Override
    public final void setErroredOut() {
        try {
            if (this.fReportDir != null && this.fReportDir.exists()) {
                File file = new File(this.fReportDir.getParentFile(), "error_" + this.fReportDir.getName());
                if (!this.fRptDirMadeExternally) {
                    this.closeReport(false);
                    this.log.info("Renaming rpt dir on error to: " + file);
                    boolean bl = this.fReportDir.renameTo(file);
                    if (!bl) {
                        this.log.warn("Could not rename for error to: " + file);
                    }
                } else {
                    this.log.info("Pseudo Renaming rpt dir on error to: " + file + " (ext made report dir so not renamed)");
                }
            } else {
                this.log.info("No report dir was made yet (but an error condition was detected)");
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error while erroring out! (setErroredOut in ToolReport");
            throwable.printStackTrace();
        }
    }

    @Override
    public final String getName() {
        return this.fReportName;
    }

    @Override
    public final long getTimestamp() {
        return this.fTimestamp;
    }

    public final void display() {
        if (SystemUtils.isHeadless()) {
            this.log.debug("Suppressing display reports as headless mode");
        } else if (!SystemUtils.isPropertyTrue("GSEA")) {
            this.log.debug("Displaying reports ...");
            ToolReportDisplay toolReportDisplay = new ToolReportDisplay(this);
            toolReportDisplay.show();
        }
    }

    @Override
    public final Id getId() {
        throw new NotImplementedException();
    }

    @Override
    public final String getNameEnglish() {
        return null;
    }

    @Override
    public final String getQuickInfo() {
        return "" + this.fNumPagesAdded;
    }

    public final HtmlReportIndexPage getIndexPage() {
        if (this.fHtmlReportIndexPage == null) {
            throw new IllegalArgumentException("HtmlReportIndexpage was not made");
        }
        return this.fHtmlReportIndexPage;
    }

    public final File getIndexPageFile() {
        return this.fHtmlIndexPageFile;
    }

    @Override
    public final File[] getFilesProduced() {
        List list = this.fPages.getFiles_list();
        if (this.fHtmlIndexPageFile != null && this.fHtmlIndexPageFile.exists() && !list.contains(this.fHtmlIndexPageFile)) {
            list.add(this.fHtmlIndexPageFile);
        }
        return list.toArray(new File[list.size()]);
    }

    public final Page[] getPagesProduced() {
        return this.fPages.getPages();
    }

    @Override
    public final int getNumPagesMade() {
        return this.fNumPagesAdded;
    }

    @Override
    public final void addComment(String string) {
        this.fToolComments.add(string);
    }

    @Override
    public final void addError(String string, Throwable throwable) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList();
        }
        this.fErrors.add(throwable);
        this.log.error(string, throwable);
    }

    @Override
    public final String getComment() {
        throw new RuntimeException("use getToolComment instead");
    }

    public final ToolComments getToolComments() {
        return this.fToolComments;
    }

    @Override
    public final File getReportDir() {
        return this.fReportDir;
    }

    @Override
    public final Properties getParametersUsed() {
        if (this.fTool_opt != null) {
            return this.fTool_opt.getParamSet().toProperties();
        }
        throw new IllegalStateException("Tool not cached: " + this.fTool_opt);
    }

    public final Tool getTool() {
        if (this.fTool_opt != null) {
            return this.fTool_opt;
        }
        throw new IllegalStateException("Tool not cached: " + this.fTool_opt);
    }

    @Override
    public final Class getProducer() {
        return this.fProducerClass;
    }

    @Override
    public final String getProducerName() {
        return this.fProducerName;
    }

    public final void savePage(String string, String string2, BufferedImage bufferedImage) {
        if (this.fHtmlReportIndexPage != null) {
            this.fHtmlReportIndexPage.addImage(string, string2, bufferedImage);
        } else {
            this.savePage(string, string2, bufferedImage, this.getReportDir());
        }
    }

    public final void savePage(String string, String string2, BufferedImage bufferedImage, int n, int n2) {
        if (this.fHtmlReportIndexPage != null) {
            this.fHtmlReportIndexPage.addImage(string, string2, bufferedImage, n, n2, null);
        } else {
            this.savePage(string, string2, bufferedImage, n, n2, this.getReportDir());
        }
    }

    public final File savePage(String string, String string2, BufferedImage bufferedImage, File file) {
        File file2 = ToolReport._createFile(string, "png", file);
        try {
            if (this.fHtmlReportIndexPage != null) {
                this.fHtmlReportIndexPage.addImage(string, string2, bufferedImage);
            }
            ImageUtils.savePng(bufferedImage, file2);
            return file2;
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving image", throwable);
            return file2;
        }
    }

    public final File savePage(String string, String string2, BufferedImage bufferedImage, int n, int n2, File file) {
        File file2 = ToolReport._createFile(string, "png", file);
        try {
            if (this.fHtmlReportIndexPage != null) {
                this.fHtmlReportIndexPage.addImage(string, string2, bufferedImage, n, n2, null);
            }
            ImageUtils.savePng(bufferedImage, file2);
            return file2;
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving image", throwable);
            return file2;
        }
    }

    public final void savePage(DatasetTemplate datasetTemplate, File file) {
        this.savePage((PersistentObject)datasetTemplate.getDataset(), file);
        this.savePage((PersistentObject)datasetTemplate.getTemplate(), file);
        this.savePage_template(datasetTemplate.getTemplate(), true, false, file);
    }

    public final File savePage(XChart xChart, int n, int n2) {
        return this.savePage(xChart, n, n2, this.fReportDir);
    }

    public final File savePage(XChart xChart) {
        return this.savePage(xChart, 500, 500, this.fReportDir);
    }

    public final File savePage(XComboDomainChart xComboDomainChart, int n, int n2) {
        return this.savePage(xComboDomainChart.getCombinedChart(), n, n2);
    }

    public final File savePage(XComboDomainChart xComboDomainChart) {
        return this.savePage(xComboDomainChart.getCombinedChart());
    }

    public final File savePage(XChart xChart, int n, int n2, File file) {
        File file2 = ToolReport._createFile(xChart.getName(), "png", file);
        try {
            xChart.saveAsPNG(file2, n, n2);
            return file2;
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving png image", throwable);
            return file2;
        }
    }

    public final File savePageXML(String string, Document document) {
        File file = null;
        try {
            file = this._createFile(string, "xml");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            XMLWriter xMLWriter = new XMLWriter(printWriter, outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving Page", throwable);
        }
        return file;
    }

    public final File savePageXML(String string, Document document, File file) {
        File file2 = null;
        try {
            file2 = ToolReport._createFile(string, "xml", file);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            XMLWriter xMLWriter = new XMLWriter(printWriter, outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving Page", throwable);
        }
        return file2;
    }

    @Override
    public final File savePage(Page page) {
        return this.savePage(page, false);
    }

    public final File savePage(Page page, boolean bl) {
        File file = null;
        try {
            file = this._createFile(page);
            page.write(new FileOutputStream(file), this.getReportDir());
            if (!bl) {
                this._centralAddPage(page, file);
            }
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving Page", throwable);
        }
        return file;
    }

    public final File savePage(Page page, File file) {
        return this.savePage(page, file, true);
    }

    public final File savePage(Page page, File file, boolean bl) {
        File file2 = null;
        try {
            file2 = ToolReport._createFile(page.getName(), page.getExt(), file);
            page.write(new FileOutputStream(file2), file);
            if (!bl) {
                this._centralAddPage(page, file2);
            }
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving Page", throwable);
        }
        return file2;
    }

    @Override
    public final void savePage(Page[] pageArray, boolean bl) {
        for (int i2 = 0; i2 < pageArray.length; ++i2) {
            this.savePage(pageArray[i2], bl);
        }
    }

    public final void savePage(String string, String string2, TIntIntHashMap tIntIntHashMap) {
        TIntIntIterator tIntIntIterator = tIntIntHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tIntIntHashMap.size();
        while (n-- > 0) {
            tIntIntIterator.advance();
            stringBuffer.append(tIntIntIterator.key()).append('\t').append(tIntIntIterator.value()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final void savePage(String string, String string2, TIntFloatHashMap tIntFloatHashMap) {
        TIntFloatIterator tIntFloatIterator = tIntFloatHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tIntFloatHashMap.size();
        while (n-- > 0) {
            tIntFloatIterator.advance();
            stringBuffer.append(tIntFloatIterator.key()).append('\t').append(tIntFloatIterator.value()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final void savePage(String string, String string2, TFloatIntHashMap tFloatIntHashMap) {
        TFloatIntIterator tFloatIntIterator = tFloatIntHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tFloatIntHashMap.size();
        while (n-- > 0) {
            tFloatIntIterator.advance();
            stringBuffer.append(tFloatIntIterator.key()).append('\t').append(tFloatIntIterator.value()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final void savePage(String string, String string2, TObjectIntHashMap tObjectIntHashMap) {
        this.savePage(string, string2, tObjectIntHashMap, false);
    }

    public final void savePage(String string, String string2, TObjectIntHashMap tObjectIntHashMap, boolean bl, File file) {
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tObjectIntHashMap.size();
        while (n-- > 0) {
            tObjectIntIterator.advance();
            stringBuffer.append(tObjectIntIterator.key()).append('\t').append(tObjectIntIterator.value()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString(), "xls", file, bl);
    }

    public final void savePage(String string, String string2, TObjectIntHashMap tObjectIntHashMap, boolean bl) {
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tObjectIntHashMap.size();
        while (n-- > 0) {
            tObjectIntIterator.advance();
            stringBuffer.append(tObjectIntIterator.key()).append('\t').append(tObjectIntIterator.value()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString(), bl);
    }

    public final void savePage(String string, String string2, TObjectFloatHashMap tObjectFloatHashMap) {
        TObjectFloatIterator tObjectFloatIterator = tObjectFloatHashMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tObjectFloatHashMap.size();
        while (n-- > 0) {
            tObjectFloatIterator.advance();
            stringBuffer.append(tObjectFloatIterator.key()).append('\t').append(tObjectFloatIterator.value()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final void savePageRanges_NameByMin(String string, String string2, Range[] rangeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        float f2 = RangeUtils.getTotalCount(rangeArray);
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            String string3 = Double.toString(rangeArray[i2].getMin());
            float f3 = (float)rangeArray[i2].getCount() / f2;
            stringBuffer.append(string3).append('\t').append(rangeArray[i2].getCount()).append('\t').append(f3).append('\n');
        }
        String string4 = "by minimum";
        if (string2 != null) {
            string4 = string4 + " " + string2;
        }
        this.savePage(string, string4, stringBuffer.toString());
    }

    public final void savePageRanges_NameByMax(String string, String string2, Range[] rangeArray) {
        float f2 = RangeUtils.getTotalCount(rangeArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            String string3 = Double.toString(rangeArray[i2].getMin());
            float f3 = (float)rangeArray[i2].getCount() / f2;
            stringBuffer.append(string3).append('\t').append(rangeArray[i2].getCount()).append('\t').append(f3).append('\n');
        }
        String string4 = "by maximum";
        if (string2 != null) {
            string4 = string4 + " " + string2;
        }
        this.savePage(string, string4, stringBuffer.toString());
    }

    public final void savePageRanges(String string, String string2, Range[] rangeArray) {
        float f2 = RangeUtils.getTotalCount(rangeArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            String string3 = rangeArray[i2].getName();
            float f3 = (float)rangeArray[i2].getCount() / f2;
            stringBuffer.append(string3).append('\t').append(rangeArray[i2].getCount()).append('\t').append(f3).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final void savePages_gmp(GeneSetMatrixPair geneSetMatrixPair) {
        this.savePage(geneSetMatrixPair.getUp());
        this.savePage(geneSetMatrixPair.getDown());
    }

    public final void savePages_gmp(GeneSetMatrixPair[] geneSetMatrixPairArray) {
        for (int i2 = 0; i2 < geneSetMatrixPairArray.length; ++i2) {
            this.savePages_gmp(geneSetMatrixPairArray[i2]);
        }
    }

    public final File savePage(PersistentObject persistentObject) {
        if (persistentObject == null) {
            this.addError("Null pob specified for saving + " + persistentObject, new Throwable());
            return null;
        }
        try {
            return this.savePage(persistentObject.getQuickInfo(), persistentObject);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to report", throwable);
            return null;
        }
    }

    public final void savePage_templates(String string, TemplateFromAnnot[] templateFromAnnotArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        File file;
        if (bl2) {
            file = string == null || string.length() == 0 ? this.createSubDir("phenotypes") : this.createSubDir(string + "_phenotypes");
            for (n = 0; n < templateFromAnnotArray.length; ++n) {
                this.savePage((PersistentObject)templateFromAnnotArray[n], file, bl3);
            }
        }
        if (bl) {
            file = this.createSubDir(string + "_phenotypes_gc");
            for (n = 0; n < templateFromAnnotArray.length; ++n) {
                File file2 = NamingConventions.createSafeFile(file, templateFromAnnotArray[n].getName() + ".cls");
                FileUtils.write(templateFromAnnotArray[n].getAsString(true), file2);
            }
        }
    }

    public final File savePage_template(Template template, boolean bl) {
        return this.savePage_template(template, bl, true);
    }

    public final File savePage_template(Template template, boolean bl, boolean bl2) {
        String string = template.getName();
        if (bl) {
            string = string + "_gc";
        }
        return this.savePage_template(template, bl, string, bl2);
    }

    public final File savePage_template(Template template, boolean bl, boolean bl2, File file) {
        String string = template.getName();
        if (bl) {
            string = string + "_gc";
        }
        return this.savePage_template(template, bl, string, bl2, file);
    }

    public final File savePage_template(Template template, boolean bl, String string, boolean bl2) {
        return this.savePage_template(template, bl, string, bl2, this.getReportDir());
    }

    public final File savePage_template(Template template, boolean bl, String string, boolean bl2, File file) {
        File file2 = null;
        try {
            file2 = ToolReport._createFile(string, DataFormat.getExtension(template), file);
            ParserFactory.save(template, bl, file2);
            this._centralAddPage(new FileWrapperPage(file2, template.getQuickInfo()), bl2);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to report", throwable);
        }
        return file2;
    }

    public final void savePage(FilteredDataset filteredDataset) {
        this.savePage(filteredDataset, this.getReportDir());
    }

    public final void savePage(FilteredDataset filteredDataset, File file) {
        this.savePage((PersistentObject)filteredDataset.getGeneSet(true), file);
        this.savePage((PersistentObject)filteredDataset.getGeneSet(false), file);
        if (!(filteredDataset instanceof FilteredDatasetImpl_only_genes)) {
            this.savePage((PersistentObject)filteredDataset.getDataset(true), file);
            this.savePage((PersistentObject)filteredDataset.getDataset(false), file);
        }
    }

    public final File savePage(PersistentObject persistentObject, File file) {
        return this.savePage(persistentObject, file, true);
    }

    public final File savePage(PersistentObject persistentObject, File file, boolean bl) {
        try {
            return this.savePage(persistentObject.getQuickInfo(), persistentObject, file, bl);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to report", throwable);
            return null;
        }
    }

    public final File savePage(PersistentObject persistentObject, boolean bl) {
        try {
            return this.savePage(persistentObject.getQuickInfo(), persistentObject, this.getReportDir(), bl);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to report", throwable);
            return null;
        }
    }

    public final File savePageXls(StringDataframe stringDataframe, boolean bl) {
        if (bl) {
            stringDataframe.replace("NaN", "");
        }
        return this.savePageXls(stringDataframe);
    }

    public final File savePageXls(StringDataframe stringDataframe, boolean bl, File file) {
        if (bl) {
            stringDataframe.replace("NaN", "");
        }
        return this.savePageXls((IDataframe)stringDataframe, file);
    }

    public final File savePageXls(IDataframe iDataframe) {
        return this.savePageXls(iDataframe, iDataframe.getName());
    }

    public final File savePageXls(IDataframe iDataframe, String string) {
        return this.savePageXls(iDataframe, string, this.fReportDir);
    }

    public final File savePageXls(IDataframe iDataframe, File file) {
        return this.savePageXls(iDataframe, iDataframe.getName(), file);
    }

    public final File savePageXls(IDataframe iDataframe, String string, File file) {
        if (iDataframe instanceof RichDataframe) {
            StringDataframe stringDataframe = (StringDataframe)((RichDataframe)iDataframe).getDataframe();
            return this.savePageXls((IDataframe)stringDataframe, string, file);
        }
        if (iDataframe instanceof StringDataframe) {
            ((StringDataframe)iDataframe).replace("NaN", "");
        }
        File file2 = ToolReport._createFile(string, DataFormat.XLS_FORMAT.getExtension(), file);
        try {
            ParserFactory.saveInvisibly2Cache(iDataframe, file2);
            this._centralAddPage(new FileWrapperPage(file2, iDataframe.getQuickInfo()));
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving sdf to report", throwable);
        }
        return file2;
    }

    public final File savePage(String string, PersistentObject persistentObject) {
        return this.savePage(string, persistentObject, this.fReportDir);
    }

    public final File savePage(String string, String string2, PersistentObject persistentObject) {
        return this.savePage(string, string2, persistentObject, this.fReportDir, true);
    }

    public final File savePage(String string, PersistentObject persistentObject, File file) {
        return this.savePage(persistentObject.getName(), string, persistentObject, file, true);
    }

    public final File savePage(String string, String string2, PersistentObject persistentObject, boolean bl) {
        return this.savePage(string, string2, persistentObject, this.fReportDir, bl);
    }

    public final File savePage(String string, PersistentObject persistentObject, File file, boolean bl) {
        return this.savePage(persistentObject.getName(), string, persistentObject, file, bl);
    }

    public final File savePage(String string, PersistentObject persistentObject, DataFormat dataFormat) {
        return this.savePage(string, persistentObject.getQuickInfo(), persistentObject, this.getReportDir(), true, dataFormat);
    }

    public final File savePage(String string, String string2, PersistentObject persistentObject, File file, boolean bl, DataFormat dataFormat) {
        File file2 = null;
        try {
            file2 = ParserFactory.save(persistentObject, dataFormat, file);
            this._centralAddPage(new FileWrapperPage(file2, string2), bl);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
        return file2;
    }

    public final File savePage(String string, String string2, PersistentObject persistentObject, File file, boolean bl) {
        File file2 = null;
        try {
            if (persistentObject instanceof RankedListDb) {
                this.savePageRdb((RankedListDb)persistentObject, file);
            } else if (persistentObject instanceof RankedList) {
                file2 = ToolReport._createFile(string, "xls", file);
                ParserFactory.save((RankedList)persistentObject, file2);
            } else if (persistentObject instanceof Dataset) {
                file2 = ToolReport._createFile(string, DataFormat.GCT_FORMAT.getExtension(), file);
                ParserFactory.saveGct((Dataset)persistentObject, file2);
            } else if (persistentObject instanceof BitSetDataset) {
                Dataset dataset = ((BitSetDataset)persistentObject).toDataset(true, false);
                file2 = ToolReport._createFile(string, "bsd", file);
                ParserFactory.saveGct(dataset, file2);
                File file3 = ToolReport._createFile(string, "mat", file);
                MiscParsers.save(dataset.getMatrix(), file3);
                this._centralAddPage(new FileWrapperPage(file3, string2));
            } else if (persistentObject instanceof StringDataframe) {
                file2 = ToolReport._createFile(string, DataFormat.getExtension(persistentObject), file);
                ParserFactory.save((StringDataframe)persistentObject, file2, false);
            } else if (persistentObject instanceof LabelledVector) {
                file2 = this.savePage(string, string2, (LabelledVector)persistentObject);
            } else {
                file2 = ToolReport._createFile(string, DataFormat.getExtension(persistentObject), file);
                ParserFactory.save(persistentObject, file2);
            }
            if (file2 != null) {
                this._centralAddPage(new FileWrapperPage(file2, string2), bl);
            }
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
        return file2;
    }

    public final File savePage(PersistentObject persistentObject, DataFormatChooser dataFormatChooser) {
        File[] fileArray = this.savePage(new PersistentObject[]{persistentObject}, dataFormatChooser);
        if (fileArray != null && fileArray.length == 1) {
            return fileArray[0];
        }
        return null;
    }

    public final File savePage(PersistentObject persistentObject, DataFormat dataFormat) {
        File[] fileArray = this.savePage(new PersistentObject[]{persistentObject}, dataFormat, this.fReportDir);
        if (fileArray != null && fileArray.length == 1) {
            return fileArray[0];
        }
        return null;
    }

    public final File savePage(PersistentObject persistentObject, DataFormatChooser dataFormatChooser, File file) {
        File[] fileArray = this.savePage(new PersistentObject[]{persistentObject}, dataFormatChooser, file);
        if (fileArray != null && fileArray.length == 1) {
            return fileArray[0];
        }
        return null;
    }

    public final File[] savePage(PersistentObject[] persistentObjectArray, DataFormatChooser dataFormatChooser) {
        return this.savePage(persistentObjectArray, dataFormatChooser, this.getReportDir());
    }

    public final File[] savePage(PersistentObject[] persistentObjectArray, DataFormatChooser dataFormatChooser, File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            DataFormat dataFormat = dataFormatChooser.getDataFormat();
            try {
                for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
                    File file2 = ParserFactory.save(persistentObjectArray[i2], dataFormat, file);
                    this._centralAddPage(new FileWrapperPage(file2, "data format " + dataFormat.getDesc()));
                    arrayList.add(file2);
                }
            }
            catch (Throwable throwable) {
                this.addError("Trouble saving pob to reports", throwable);
            }
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public final File[] savePage(PersistentObject[] persistentObjectArray, DataFormat dataFormat, File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            try {
                for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
                    File file2 = ParserFactory.save(persistentObjectArray[i2], dataFormat, file);
                    this._centralAddPage(new FileWrapperPage(file2, "data format " + dataFormat.getDesc()));
                    arrayList.add(file2);
                }
            }
            catch (Throwable throwable) {
                this.addError("Trouble saving pob to reports", throwable);
            }
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public final File savePage(GeneSetMatrix geneSetMatrix, GeneSetMatrixFormatParam geneSetMatrixFormatParam) {
        return this.savePage(geneSetMatrix.getQuickInfo(), geneSetMatrix, geneSetMatrixFormatParam);
    }

    public final File savePage(String string, GeneSetMatrix geneSetMatrix, GeneSetMatrixFormatParam geneSetMatrixFormatParam) {
        try {
            if (geneSetMatrixFormatParam.getDataFormat() == DataFormat.GMT_FORMAT) {
                return this.savePageGmt(string, geneSetMatrix);
            }
            if (geneSetMatrixFormatParam.getDataFormat() == DataFormat.GMX_FORMAT) {
                return this.savePage(string, geneSetMatrix);
            }
            this.log.warn("Unkown gm format: " + geneSetMatrixFormatParam.getDataFormat());
            return this.savePageGmt(string, geneSetMatrix);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
            return null;
        }
    }

    public final File[] savePage(GeneSetPair geneSetPair) {
        File file = this.savePage(geneSetPair.getUp());
        File file2 = this.savePage(geneSetPair.getDown());
        return new File[]{file, file2};
    }

    public final File[] savePage(GeneSetPair geneSetPair, File file) {
        File file2 = this.savePage((PersistentObject)geneSetPair.getUp(), file);
        File file3 = this.savePage((PersistentObject)geneSetPair.getDown(), file);
        return new File[]{file2, file3};
    }

    public final File savePage(String string, GeneSetMatrix geneSetMatrix) {
        return this.savePage(string, geneSetMatrix, this.fReportDir);
    }

    public final File savePage(String string, GeneSetMatrix geneSetMatrix, File file) {
        StringBuffer stringBuffer = new StringBuffer(geneSetMatrix.getName()).append('.').append(DataFormat.GMX_FORMAT.getExtension());
        File file2 = ToolReport.createSafeReportFile(stringBuffer.toString(), file);
        this.log.debug("saving gmt in: " + file2);
        try {
            ParserFactory.save(geneSetMatrix, file2);
            this._centralAddPage(new FileWrapperPage(file2, string));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports object: " + geneSetMatrix + " in file: " + file2.getPath(), throwable);
        }
        return file2;
    }

    public final File savePageGmx(GeneSetMatrix geneSetMatrix) {
        return this.savePage(geneSetMatrix.getQuickInfo(), geneSetMatrix);
    }

    public final File savePageGmx(GeneSetMatrix geneSetMatrix, File file) {
        return this.savePage(geneSetMatrix.getQuickInfo(), geneSetMatrix, file);
    }

    public final File savePageGmt(GeneSetMatrix geneSetMatrix) {
        return this.savePageGmt(geneSetMatrix.getQuickInfo(), geneSetMatrix);
    }

    public final File savePageGmt(String string, GeneSet[] geneSetArray) {
        return this.savePageGmt(new DefaultGeneSetMatrix(string, geneSetArray));
    }

    public final File savePageGmt(String string, GeneSetMatrix geneSetMatrix) {
        StringBuffer stringBuffer = new StringBuffer(geneSetMatrix.getName()).append('.').append(DataFormat.GMT_FORMAT.getExtension());
        File file = this.createSafeReportFile(stringBuffer.toString());
        this.log.debug("saving gmt in: " + file);
        try {
            ParserFactory.saveGmt(geneSetMatrix, file);
            this._centralAddPage(new FileWrapperPage(file, string));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports object: " + geneSetMatrix + " in file: " + file.getPath(), throwable);
        }
        return file;
    }

    public final void savePageInvisibly2Cache(GeneSetMatrix geneSetMatrix) {
        try {
            File file = this._createFile(geneSetMatrix.getName(), DataFormat.getExtension(geneSetMatrix));
            ParserFactory.save(geneSetMatrix, file, false);
            this._centralAddPage(new FileWrapperPage(file, geneSetMatrix.getQuickInfo()));
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
    }

    public final void savePageInvisibly2Cache(GeneSetMatrix geneSetMatrix, DataFormat dataFormat) {
        try {
            File file = this._createFile(geneSetMatrix.getName(), dataFormat.getExtension());
            ParserFactory.save(geneSetMatrix, file, false);
            this._centralAddPage(new FileWrapperPage(file, geneSetMatrix.getQuickInfo()));
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
    }

    public final File savePageInvisibly2Cache(Dataset dataset) {
        return this.savePageInvisibly2Cache(dataset, DataFormat.GCT_FORMAT);
    }

    public final File savePageInvisibly2Cache(Dataset dataset, File file) {
        return this.savePageInvisibly2Cache(dataset, DataFormat.GCT_FORMAT, file);
    }

    public final File savePageInvisibly2Cache(Dataset dataset, DataFormat dataFormat) {
        return this.savePageInvisibly2Cache(dataset.getName(), dataset.getQuickInfo(), dataset, dataFormat, this.fReportDir);
    }

    public final File savePageInvisibly2Cache(String string, String string2, Dataset dataset) {
        return this.savePageInvisibly2Cache(string, string2, dataset, DataFormat.GCT_FORMAT, this.fReportDir);
    }

    public final File savePageInvisibly2Cache(String string, String string2, Dataset dataset, File file) {
        return this.savePageInvisibly2Cache(string, string2, dataset, DataFormat.GCT_FORMAT, file);
    }

    public final File savePageInvisibly2Cache(Dataset dataset, DataFormat dataFormat, File file) {
        return this.savePageInvisibly2Cache(dataset.getName(), dataset.getQuickInfo(), dataset, dataFormat, file);
    }

    public final File savePageInvisibly2Cache(String string, String string2, Dataset dataset, DataFormat dataFormat, File file) {
        File file2 = null;
        try {
            file2 = ToolReport._createFile(string, dataFormat.getExtension(), file);
            if (dataFormat == DataFormat.GCT_FORMAT) {
                ParserFactory.saveInvisibly2CacheGct(dataset, file2);
            } else if (dataFormat == DataFormat.DCHIP_FORMAT) {
                ParserFactory.saveInvisibly2CacheDChip(dataset, file2);
            } else if (dataFormat == DataFormat.TXT_DATASET_FORMAT) {
                ParserFactory.saveInvisibly2CacheTxt(dataset, file2);
            } else {
                this.log.warn("Unkown gm format: " + dataFormat.getExtension());
                ParserFactory.saveInvisibly2CacheGct(dataset, file2);
            }
            this._centralAddPage(new FileWrapperPage(file2, string2));
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
        return file2;
    }

    public final File savePageInvisibly2Cache(GeneSetMatrix geneSetMatrix, GeneSetMatrixFormatParam geneSetMatrixFormatParam) {
        File file = this._createFile(geneSetMatrix.getName(), geneSetMatrixFormatParam.getDataFormat().getExtension());
        try {
            if (geneSetMatrixFormatParam.getDataFormat() == DataFormat.GMT_FORMAT) {
                ParserFactory.saveGmt(geneSetMatrix, file, false);
            } else if (geneSetMatrixFormatParam.getDataFormat() == DataFormat.GMX_FORMAT) {
                ParserFactory.save(geneSetMatrix, file, false);
            } else {
                this.log.warn("Unkown gm format: " + geneSetMatrixFormatParam.getDataFormat());
                ParserFactory.save(geneSetMatrix, file, false);
            }
            this._centralAddPage(new FileWrapperPage(file, geneSetMatrix.getQuickInfo()));
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to reports", throwable);
        }
        return file;
    }

    public final void savePageGmx(String string, GeneSetSignal[] geneSetSignalArray) {
        GeneSet[] geneSetArray = new GeneSet[geneSetSignalArray.length];
        for (int i2 = 0; i2 < geneSetSignalArray.length; ++i2) {
            geneSetArray[i2] = geneSetSignalArray[i2].getAsGeneSet();
        }
        this.savePage(new DefaultGeneSetMatrix(string, geneSetArray));
    }

    public final void savePageGmx(String string, SignalMatrix signalMatrix) {
        GeneSet[] geneSetArray = new GeneSet[signalMatrix.getNumSignals()];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray[i2] = signalMatrix.getSignal(i2).getAsGeneSet();
        }
        this.savePage(new DefaultGeneSetMatrix(string, geneSetArray));
    }

    public final void savePageRL(String string, RankedList rankedList) {
        Chip chip = null;
        this.savePageRL(string, rankedList, chip);
    }

    public final void savePageRL(String string, RankedList rankedList, Chip chip) {
        this.savePageRL(string, rankedList, chip, this.fReportDir, true);
    }

    public final File savePageRL(String string, RankedList rankedList, Chip chip, File file, boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
                String string2 = rankedList.getRankName(i2);
                if (chip != null) {
                    String string3 = chip.getSymbol(string2, Chip.REPLACE_WITH_PROBEID);
                    String string4 = chip.getTitle(string2, Chip.REPLACE_WITH_PROBEID);
                    stringBuffer.append(string2).append('\t').append(string3).append('\t').append(string4).append('\t').append(rankedList.getScore(i2)).append('\n');
                    continue;
                }
                stringBuffer.append(string2).append('\t').append(rankedList.getScore(i2)).append('\n');
            }
            return this.savePage(rankedList.getName(), string, stringBuffer.toString(), true, bl);
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving rl to reports", throwable);
            return null;
        }
    }

    public final void savePageRdb(RankedListDb rankedListDb, File file) {
        for (int i2 = 0; i2 < rankedListDb.getNumRankedLists(); ++i2) {
            this.savePage(rankedListDb.getName() + "_" + i2, rankedListDb.getRankedList(i2), file, false);
        }
    }

    public final void savePage(String[] stringArray, PersistentObject[] persistentObjectArray) {
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            if (stringArray == null) {
                this.savePage(persistentObjectArray[i2]);
                continue;
            }
            this.savePage(stringArray[i2], persistentObjectArray[i2]);
        }
    }

    public final File savePageDF(String string, Dataframe dataframe) {
        return this.savePageDF(string, dataframe, "xls");
    }

    public final File savePageDF(String string, Dataframe dataframe, File file) {
        return this.savePageDF(string, dataframe, "xls", file);
    }

    public final File savePageDF(String string, Dataframe dataframe, String string2) {
        return this.savePageDF(string, dataframe, string2, this.getReportDir());
    }

    public final File savePageDF(String string, Dataframe dataframe, String string2, File file) {
        StringBuffer stringBuffer = new StringBuffer(dataframe.getName()).append('.').append(string2);
        File file2 = ToolReport.createSafeReportFile(stringBuffer.toString(), file);
        try {
            ParserFactory.save(dataframe, file2);
            this._centralAddPage(new FileWrapperPage(file2, string));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports object: " + dataframe + " in file: " + file2.getPath(), throwable);
        }
        return file2;
    }

    public final void savePageDF(Dataframe dataframe) {
        this.savePageDF(dataframe.getQuickInfo(), dataframe);
    }

    public final void savePagesDF(Dataframe[] dataframeArray) {
        for (int i2 = 0; i2 < dataframeArray.length; ++i2) {
            this.savePageDF(dataframeArray[i2]);
        }
    }

    public final void savePagesDF(Dataframe[] dataframeArray, File file, boolean bl, Chip chip) {
        for (int i2 = 0; i2 < dataframeArray.length; ++i2) {
            this.savePage(dataframeArray[i2], file, bl, chip);
        }
    }

    public final File savePage(Dataframe dataframe, File file, boolean bl, Chip chip) {
        AbstractObject abstractObject = dataframe;
        if (chip != null) {
            abstractObject = chip.annotate(dataframe);
        }
        return this.savePage((PersistentObject)abstractObject, file, bl);
    }

    public final void savePages(Dataset[] datasetArray) {
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            this.savePage(datasetArray[i2]);
        }
    }

    public final void savePages(StringDataframe[] stringDataframeArray) {
        for (int i2 = 0; i2 < stringDataframeArray.length; ++i2) {
            this.savePage(stringDataframeArray[i2]);
        }
    }

    public final File savePage(String string, StringDataframe stringDataframe) {
        String string2 = "xls";
        StringBuffer stringBuffer = new StringBuffer(stringDataframe.getName()).append('.').append(string2);
        File file = this.createSafeReportFile(stringBuffer.toString());
        try {
            ParserFactory.saveInvisibly2Cache(stringDataframe, file);
            this._centralAddPage(new FileWrapperPage(file, string));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports object: " + stringDataframe + " in file: " + file.getPath(), throwable);
        }
        return file;
    }

    public final File savePageInvisibly2Cache(String string, IDataframe iDataframe) {
        String string2 = "xls";
        StringBuffer stringBuffer = new StringBuffer(iDataframe.getName()).append('.').append(string2);
        return this.savePageInvisibly2Cache(stringBuffer.toString(), string, iDataframe);
    }

    public final File savePageInvisibly2Cache(String string, String string2, String string3, IDataframe iDataframe) {
        string = string + "." + string3;
        return this.savePageInvisibly2Cache(string, string2, iDataframe);
    }

    public final File savePageInvisibly2Cache(String string, String string2, IDataframe iDataframe) {
        File file;
        block4: {
            file = this.createSafeReportFile(string);
            try {
                if (iDataframe instanceof StringDataframe) {
                    ParserFactory.saveInvisibly2Cache((StringDataframe)iDataframe, file);
                    break block4;
                }
                if (iDataframe instanceof Dataframe) {
                    ParserFactory.saveInvisibly2Cache((Dataframe)iDataframe, file);
                    break block4;
                }
                throw new IllegalArgumentException("Unknown df for saving: " + iDataframe.getClass());
            }
            catch (Throwable throwable) {
                this.addError("Could not save object to reports object: " + iDataframe + " in file: " + file.getPath(), throwable);
            }
        }
        return file;
    }

    public final File savePage(RichDataframe richDataframe) {
        if (richDataframe == null) {
            this.addError("param red cannot be null", new IllegalArgumentException("Param rdf cannot be null"));
            return null;
        }
        File file = this.createSafeReportFile(richDataframe.getName());
        try {
            ParserFactory.save(richDataframe.getDataframe(), file);
            KeyValTable keyValTable = richDataframe.getMetaData().getKvt();
            if (keyValTable != null) {
                HtmlPage htmlPage = new HtmlPage(richDataframe.getName() + "_details", null);
                htmlPage.addTable("details", keyValTable);
                this.savePage(htmlPage);
            }
        }
        catch (Throwable throwable) {
            this.addError("Trouble saving pob to report", throwable);
        }
        return file;
    }

    public final File savePage(String string, String string2, LabelledVector labelledVector) {
        return this.savePage(string, string2, labelledVector.toString_newline('\t'));
    }

    public final File savePage(String string, String string2, LabelledVector labelledVector, File file) {
        return this.savePage(string, string2, labelledVector.toString_newline('\t'), file);
    }

    public final File savePage(String string, LabelledVector labelledVector) {
        return this.savePage(string, labelledVector.getQuickInfo(), labelledVector);
    }

    public final File savePage(String string, LabelledVector labelledVector, File file) {
        return this.savePage(string, labelledVector.getQuickInfo(), labelledVector, file);
    }

    public final File savePage(LabelledVector labelledVector, File file) {
        return this.savePage(labelledVector.getName(), labelledVector.getQuickInfo(), labelledVector, file);
    }

    public final File savePage(String string, String string2, LabelledVector[] labelledVectorArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[labelledVectorArray.length];
        for (n = 0; n < labelledVectorArray.length; ++n) {
            nArray[n] = labelledVectorArray[n].getSize();
        }
        n = XMath.max(nArray);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < labelledVectorArray.length; ++i3) {
                if (labelledVectorArray[i3].getSize() > i2) {
                    stringBuffer.append(labelledVectorArray[i3].getLabel(i2)).append('\t');
                    stringBuffer.append(labelledVectorArray[i3].getScore(i2)).append('\t');
                    continue;
                }
                stringBuffer.append('\t');
                stringBuffer.append('\t');
            }
            stringBuffer.append('\n');
        }
        return this.savePage(string, string2, stringBuffer.toString());
    }

    public final File savePage(String string, String string2, RankedList[] rankedListArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[rankedListArray.length];
        for (n = 0; n < rankedListArray.length; ++n) {
            nArray[n] = rankedListArray[n].getSize();
        }
        n = XMath.max(nArray);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < rankedListArray.length; ++i3) {
                if (rankedListArray[i3].getSize() > i2) {
                    stringBuffer.append(rankedListArray[i3].getRankName(i2)).append('\t');
                    stringBuffer.append(rankedListArray[i3].getScore(i2)).append('\t');
                    continue;
                }
                stringBuffer.append('\t');
                stringBuffer.append('\t');
            }
            stringBuffer.append('\n');
        }
        return this.savePage(string, string2, stringBuffer.toString());
    }

    public final File savePage(String string, String string2, Vector vector) {
        return this.savePage(string, string2, Printf.format(vector, '\n'));
    }

    public final File savePage(String string, String string2, int[] nArray) {
        return this.savePage(string, string2, Printf.format(nArray, '\n'));
    }

    public final File savePage(String string, String string2, float[] fArray) {
        return this.savePage(string, string2, Printf.format(fArray, 10));
    }

    public final File savePage(String string, String string2, Vector[] vectorArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vectorArray[0].getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                stringBuffer.append(vectorArray[i3].getElement(i2)).append('\t');
            }
        }
        return this.savePage(string, string2, stringBuffer.toString());
    }

    public final File savePage(String string, GeneSetSignal[] geneSetSignalArray, GeneSetMatrix geneSetMatrix) {
        return this.savePage(new DefaultGseaSignalMatrix(string, geneSetSignalArray, geneSetMatrix));
    }

    public final void savePageSvmFu(Dataset dataset, Template template) {
        try {
            String string = NamingConventions.removeExtension(dataset) + ".svm";
            File file = this.createSafeReportFile(string);
            MiscParsers.exportSvmFu(dataset, template, file);
            this._centralAddPage(new FileWrapperPage(file, "svm_fu data"));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports object: " + dataset + " to file", throwable);
        }
    }

    public final void savePageWithRowDescriptions(String string, String string2, Dataframe dataframe, List list) {
        String string3 = "xls";
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(dataframe.getName()).append('.').append(string3);
        File file = this.createSafeReportFile(stringBuffer.toString());
        try {
            ParserFactory.saveWithRowDescs(dataframe, list, file);
            this._centralAddPage(new FileWrapperPage(file, string2));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports object: " + dataframe + " in file: " + file.getPath(), throwable);
        }
    }

    public final void savePageWithRowDescriptions(String string, Dataframe dataframe, FeatureAnnot featureAnnot) {
        this.savePageWithRowDescriptions(string, dataframe.getQuickInfo(), dataframe, featureAnnot);
    }

    public final void savePageWithRowDescriptions(String string, String string2, Dataframe dataframe, FeatureAnnot featureAnnot) {
        ArrayList<String> arrayList = new ArrayList<String>(dataframe.getNumRow());
        for (int i2 = 0; i2 < dataframe.getNumRow(); ++i2) {
            String string3 = dataframe.getRowName(i2);
            String string4 = featureAnnot.getNativeDesc(string3);
            if (string4 == null) {
                arrayList.add("-");
                continue;
            }
            arrayList.add(string4);
        }
        this.savePageWithRowDescriptions(string, string2, dataframe, arrayList);
    }

    public final void savePage(String string, String string2, Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e2 : set) {
            stringBuffer.append(e2.toString()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final void savePage(String string, String string2, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k2 : map.keySet()) {
            Object object = map.get(k2);
            if (object == null) {
                object = "";
            }
            stringBuffer.append(k2.toString()).append('\t');
            if (object instanceof Set) {
                stringBuffer.append(Printf$Full.toString((Set)object)).append('\t').append(((Set)object).size()).append('\n');
                continue;
            }
            stringBuffer.append(object.toString()).append('\n');
        }
        this.savePage(string, string2, stringBuffer.toString());
    }

    public final File savePage(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]).append('\n');
        }
        return this.savePage(string, string2, stringBuffer.toString());
    }

    public final File savePage(String string, String string2, String string3) {
        return this.savePage(string, string2, string3, "xls", false, true);
    }

    public final File savePage(String string, String string2, String string3, boolean bl, boolean bl2) {
        return this.savePage(string, string2, string3, "xls", bl, bl2);
    }

    public final File savePage(String string, String string2, String string3, boolean bl) {
        return this.savePage(string, string2, string3, "xls", bl, true);
    }

    public final File savePage(String string, String string2, String string3, File file) {
        return this.savePage(string, string2, string3, "xls", file, false);
    }

    public final File savePageTxt(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]).append('\n');
        }
        return this.savePage(string, string2, stringBuffer.toString());
    }

    public final File savePageTxt(String string, String string2, List list) {
        return this.savePageTxt(string, string2, list.toArray(new String[list.size()]));
    }

    public final File savePageTxt(String string, String string2, String[] stringArray, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]).append('\n');
        }
        return this.savePage(string, string2, stringBuffer.toString(), file);
    }

    public final File savePageTxt(String string, String string2, String string3) {
        return this.savePage(string, string2, string3, "txt", false, true);
    }

    public final File savePageTxt(String string, String string2, String string3, String string4) {
        return this.savePage(string, string2, string3, string4, false, true);
    }

    public final File savePageTxt(String string, String string2, String string3, File file) {
        return this.savePage(string, string2, string3, "txt", file, false, true);
    }

    public final File savePageTxt(String string, String string2, String string3, File file, boolean bl, boolean bl2) {
        return this.savePage(string, string2, string3, "txt", file, bl, bl2);
    }

    public final File savePageTxt(String string, String string2, String string3, boolean bl, boolean bl2) {
        return this.savePage(string, string2, string3, "txt", bl, bl2);
    }

    public final File savePage(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        return this.savePage(string, string2, string3, string4, this.getReportDir(), bl, bl2);
    }

    public final File savePage(String string, String string2, String string3, String string4, File file, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(string4);
        File file2 = ToolReport.createSafeReportFile(stringBuffer.toString(), file);
        try {
            if (!bl) {
                this.log.debug("saving in: " + file2);
            }
            FileUtils.write(string3, file2);
            if (bl2) {
                this._centralAddPage(new FileWrapperPage(file2, string2));
            }
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports data: " + string + " in file: " + file2.getPath(), throwable);
        }
        return file2;
    }

    public final File savePage(String string, String string2, String string3, String string4, File file, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(string4);
        File file2 = ToolReport.createSafeReportFile(stringBuffer.toString(), file);
        try {
            if (!bl) {
                this.log.debug("saving xls in: " + file2);
            }
            FileUtils.write(string3, file2);
            this._centralAddPage(new FileWrapperPage(file2, string2));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports data: " + string + " in file: " + file2.getPath(), throwable);
        }
        return file2;
    }

    public final void savePage(String string, String string2, Matrix matrix) {
        String string3 = "mat";
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(string3);
        File file = this.createSafeReportFile(stringBuffer.toString());
        try {
            this.log.debug("saving mat in: " + file);
            MiscParsers.save(matrix, file);
            this._centralAddPage(new FileWrapperPage(file, string2));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports data: " + string + " in file: " + file.getPath(), throwable);
        }
    }

    public final void savePageHtml(String string, String string2, String string3) {
        String string4 = "html";
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(string4);
        File file = this.createSafeReportFile(stringBuffer.toString());
        try {
            this.log.debug("saving html in: " + file);
            FileUtils.write(string3, file);
            this._centralAddPage(new FileWrapperPage(file, string2));
        }
        catch (Throwable throwable) {
            this.addError("Could not save object to reports data: " + string + " in file: " + file.getPath(), throwable);
        }
    }

    private void _centralAddPage(Page page, File file) {
        if (this.fReportIndexState.keepTrackOfPages() && !(page instanceof HtmlReportIndexPage)) {
            this.fPages.add(page, file);
        }
        ++this.fNumPagesAdded;
        if (page instanceof HtmlPage) {
            this.createCss();
        }
    }

    public final void createCss() {
        if (!this.fDoneAddingCss) {
            this.createCss(this.fReportDir);
        }
        this.fDoneAddingCss = true;
    }

    public final void createCss(File file) {
        try {
            File file2 = ToolReport._createFile("xtools", "css", file);
            FileUtils.copy(JarResources.toURL("xtools.css"), file2);
        }
        catch (Throwable throwable) {
            this.log.error("Trouble copying over CSS", throwable);
        }
    }

    public final File createSubDir(String string) {
        boolean bl;
        File file = NamingConventions.createSafeFile(this.getReportDir(), string);
        if (!file.exists() && !(bl = file.mkdir())) {
            throw new IllegalStateException("Unable to make an output folder for the report at: " + file.getPath());
        }
        this.createCss(file);
        return file;
    }

    public final File createSubSubDir(File file, String string) {
        boolean bl;
        File file2 = NamingConventions.createSafeFile(file, string);
        if (!file2.exists() && !(bl = file2.mkdir())) {
            throw new IllegalStateException("Unable to make an output folder for the report at: " + file2.getPath());
        }
        this.createCss(file2);
        return file2;
    }

    public final void setWebBaseRelativePath(String string) {
        this.fOptWebBase = string;
    }

    public final void setKvtHeaders(Element element, Element element2) {
        this.fKvt_key_col_header = element;
        this.fKvt_value_col_header = element2;
    }

    public final KeyValTable getKvt() {
        return this.fKvt;
    }

    private void _centralAddPage(FileWrapperPage fileWrapperPage) {
        this._centralAddPage(fileWrapperPage, this.fReportIndexState.keepTrackOfPages());
    }

    private void _centralAddPage(FileWrapperPage fileWrapperPage, boolean bl) {
        if (fileWrapperPage == null) {
            throw new IllegalArgumentException("Param page cannot be null");
        }
        if (bl) {
            this.fPages.add(fileWrapperPage);
        }
        ++this.fNumPagesAdded;
        if (this.fReportIndexState.keepTrackOfPagesInHtmlIndex()) {
            if (this.fKvt == null) {
                this.fKvt = this.fKvt_key_col_header == null ? new KeyValTable() : new KeyValTable(this.fKvt_key_col_header, this.fKvt_value_col_header);
            }
            this.fKvt.addRow(fileWrapperPage.getDesc(), fileWrapperPage.createLink(this.fReportDir, this.fOptWebBase));
        }
    }

    public final void closeReport(boolean bl) {
        if (this.fClosed) {
            return;
        }
        if (this.fReportParamsFile != null && this.fReportParamsFile.exists()) {
            this._centralAddPage(new FileWrapperPage(this.fReportParamsFile, "List of parameters used by the tool (rpt)"));
        }
        StringBuffer stringBuffer = null;
        try {
            if (this.fErrors != null && this.fErrors.size() != 0) {
                stringBuffer = new StringBuffer(COMMON_ERROR_PREFIX);
                for (int i2 = 0; i2 < this.fErrors.size(); ++i2) {
                    stringBuffer.append("ERROR ").append(i2 + 1).append('\n');
                    Throwable throwable = (Throwable)this.fErrors.get(i2);
                    stringBuffer.append(throwable.getMessage()).append('\n');
                    stringBuffer.append("---------------------------------------------------");
                    stringBuffer.append(TraceUtils.getAsString(throwable)).append('\n');
                }
                this.savePage("there_were_reporting_errors", "reporting errors", stringBuffer.toString());
            }
        }
        catch (Throwable throwable) {
            this.log.error("Errors adding errors to reports!", throwable);
        }
        if (this.fHtmlReportIndexPage != null) {
            try {
                if (stringBuffer != null && stringBuffer.length() > 0) {
                    this.fHtmlReportIndexPage.addError(stringBuffer.toString());
                }
                if (this.fKvt != null && this.fReportIndexState.keepTrackOfPagesInHtmlIndex()) {
                    this.fHtmlReportIndexPage.addTable("Result files produced in this analysis", this.fKvt);
                }
                this.fHtmlIndexPageFile = this.savePage((Page)this.fHtmlReportIndexPage, false);
            }
            catch (Throwable throwable) {
                this.log.error("Error making HtmlIndexPage -- report content may otherwise be OK", throwable);
            }
        }
        if (this.fTool_opt != null && bl && this.fReportParamsFile != null && !this.fReportParamsFile.exists()) {
            try {
                ParserFactory.save(this, this.fReportParamsFile);
            }
            catch (Throwable throwable) {
                this.log.error("Error closing report -- suppressing", throwable);
            }
        }
        if (bl) {
            try {
                if (this.fReportParamsFile != null) {
                    File file = new File(Application.getVdbManager().getReportsCacheDir(), this.fReportParamsFile.getName());
                    ParserFactory.save(this, file, false);
                }
            }
            catch (Throwable throwable) {
                this.log.error("Error saving report to cahche -- suppressing", throwable);
            }
        }
        this.fClosed = true;
    }

    private File _createFile(Page page) {
        return this._createFile(page.getName(), page.getExt());
    }

    public final File createFile(String string, String string2) {
        File file = this.createSafeReportFile(string);
        this._centralAddPage(new FileWrapperPage(file, string2));
        return file;
    }

    private File _createFile(String string, String string2) {
        return ToolReport._createFile(string, string2, this.fReportDir);
    }

    private static File _createFile(String string, String string2, File file) {
        File file2 = null;
        try {
            int n;
            StringBuffer stringBuffer = string.endsWith(string2) ? new StringBuffer(string) : new StringBuffer(string).append('.').append(string2);
            file2 = ToolReport.createSafeReportFile(stringBuffer.toString(), file);
            if (FileUtils.isLocked(file2)) {
                n = string.length();
                if (n > 10) {
                    n = 10;
                }
                stringBuffer = new StringBuffer(string.substring(0, n)).append(".WARNING_renamed_on_detecting_lock").append(System.currentTimeMillis()).append('.').append(string2);
                String string3 = NamingConventions.createSafeFileName(stringBuffer.toString());
                file2 = new File(file, string3);
            }
            if (!file2.exists() && (n = (int)(file2.createNewFile() ? 1 : 0)) == 0) {
                throw new IOException("Could not make file: " + file2.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            if (file2 == null) {
                file2 = ToolReport.createSafeReportFile("tmp_report_error_file." + System.currentTimeMillis() + string2, file);
            }
            StringBuffer stringBuffer = new StringBuffer("Fatal error making file to save a component of the reports in");
            stringBuffer.append("\nInstead using a result file: ").append(file2.getPath());
            klog.fatal(stringBuffer, throwable);
        }
        return file2;
    }

    private static File createSafeReportFile(String string, File file) {
        return NamingConventions.createSafeFile(file, string);
    }

    private File createSafeReportFile(String string) {
        return ToolReport.createSafeReportFile(string, this.fReportDir);
    }

    private static File createIfNeededAndGetReportDir(File file, Tool tool, Report report) {
        boolean bl;
        boolean bl2;
        if (!file.exists() && !(bl2 = file.mkdir())) {
            throw new IOException("Could not make analysis(-out) results dir at: " + file);
        }
        File file2 = ToolReport.generateReportDir(report, tool);
        if (!file2.exists() && !(bl = file2.mkdir())) {
            throw new IOException("Could not make a directory to store the Tool reports in. The location attempted was: " + file2.getAbsolutePath());
        }
        return file2;
    }

    private static File generateReportDir(Report report, Tool tool) {
        if (Conf.isMakeReportDirOffMode()) {
            return tool.getParamSet().getAnalysisDirParam().getAnalysisDir();
        }
        ReportLabelParam reportLabelParam = tool.getParamSet().getReportLabelParam();
        String string = reportLabelParam.getReportLabel();
        if (string == null || string.length() == 0) {
            string = "my_report";
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(tool.getName(), ".");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer(string).append('.').append(string2);
        stringBuffer.append('.').append(report.getTimestamp());
        return new File(tool.getParamSet().getAnalysisDirParam().getAnalysisDir(), stringBuffer.toString());
    }

    @Override
    public final void setProperty(String string, String string2) {
        if (this.prp == null) {
            this.prp = new Properties();
        }
        this.prp.setProperty(string, string2);
    }

    @Override
    public final boolean hasProperty(String string) {
        if (this.prp == null) {
            return false;
        }
        String string2 = this.prp.getProperty(string);
        return string2 != null && string2.length() > 0;
    }

    @Override
    public final String getProperty(String string) {
        if (this.prp == null) {
            return null;
        }
        return this.prp.getProperty(string);
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

