/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.api.ToolReportDisplay$1;
import edu.mit.broad.genome.reports.api.ToolReportDisplay$2;
import edu.mit.broad.genome.reports.api.ToolReportDisplay$CommonLookAndClickListRenderer;
import edu.mit.broad.genome.reports.api.ToolReportDisplay$ReportChartAction;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.AcrobatAction;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.actions.ext.ExcelAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import edu.mit.broad.xbench.actions.ext.TextpadAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class ToolReportDisplay {
    private JList jlDisplay;
    private ToolReport fReport;
    private final Logger log = XLogger.getLogger(this.getClass());
    private JFrame fFrame;
    private static final Dimension DEFAULT_DIM = new Dimension(500, 325);
    private final ToolReportDisplay fInstance = this;
    private static final Font FONT_DEFAULT_BOLD = new Font("Helvetica", 1, 12);
    private static final String index_html = "index.html";

    public ToolReportDisplay(ToolReport toolReport) {
        if (toolReport == null) {
            throw new IllegalArgumentException("Param reports cannot be null");
        }
        this.fReport = toolReport;
        this.init();
    }

    public final void show() {
        ToolReportDisplay.centerFrame(this.fFrame);
        this.fFrame.setSize(DEFAULT_DIM);
        this.fFrame.setVisible(true);
    }

    private void init() {
        this.jbInit();
    }

    private void jbInit() {
        JButton jButton;
        File file = this.fReport.getReportDir();
        String string = file != null && file.exists() ? "Report for " + this.fReport.getName() + " [" + file.getAbsolutePath() + "]" : "Report for " + this.fReport.getName() + " [ No data files ]";
        this.jlDisplay = new JList();
        this.jlDisplay.setToolTipText(string);
        this.jlDisplay.setCellRenderer(new ToolReportDisplay$CommonLookAndClickListRenderer(this, this.jlDisplay, null));
        this.jlDisplay.setSelectionMode(0);
        DefaultListModel<File> defaultListModel = new DefaultListModel<File>();
        File[] fileArray = this.fReport.getFilesProduced();
        File file2 = this.fReport.getIndexPageFile();
        if (file2 != null) {
            defaultListModel.addElement(file2);
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (file2 != null) {
                if (file2.equals(fileArray[i2])) continue;
                defaultListModel.addElement(fileArray[i2]);
                continue;
            }
            defaultListModel.addElement(fileArray[i2]);
        }
        this.jlDisplay.setModel(defaultListModel);
        this.jlDisplay.setBorder(BorderFactory.createTitledBorder("Files Produced (double click to open, right-click for options)"));
        if (defaultListModel.getSize() > 0) {
            this.jlDisplay.setSelectedIndex(0);
        }
        this.fFrame = new JFrame(string);
        this.fFrame.setVisible(false);
        this.fFrame.setSize(DEFAULT_DIM);
        this.fFrame.getContentPane().setLayout(new BorderLayout());
        this.fFrame.getContentPane().add((Component)this.createCommandPanel(), "North");
        JScrollPane jScrollPane = new JScrollPane(this.jlDisplay);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.fFrame.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        if (file != null && file.exists()) {
            jButton = new JButton("Browse");
            jButton.addActionListener(new OsExplorerAction(file.getPath()));
            jPanel.add(jButton);
        }
        jButton = new JButton("Quit");
        if (this.fReport.getTool().getParamSet().getGuiParam().isTrue()) {
            jButton.setText("Close");
        }
        jButton.addActionListener(new ToolReportDisplay$1(this));
        jPanel.add(jButton);
        this.fFrame.getContentPane().add((Component)jPanel, "South");
    }

    private JComponent createCommandPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(ToolReportDisplay.DEFAULT_DIM.width, 55));
        StringBuffer stringBuffer = new StringBuffer(this.fReport.getProducerName()).append(' ');
        stringBuffer.append(this.fReport.getTool().getParamSet().getAsCommand(false, false, false).trim());
        JTextArea jTextArea = new JTextArea(1, 40);
        jTextArea.setBorder(BorderFactory.createTitledBorder("The command was:"));
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setWrapStyleWord(true);
        JButton jButton = new JButton("Copy", GuiHelper.ICON_COPY16);
        jButton.addActionListener(new ToolReportDisplay$2(this, jTextArea));
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel.add((Component)jButton, "East");
        return jPanel;
    }

    private Icon getIcon(File file) {
        return DataFormat.getIcon(file);
    }

    private void runDefaultAction(Object object) {
        ActionListener actionListener = null;
        if (object instanceof File) {
            File file = (File)object;
            String string = NamingConventions.getExtension(file);
            if (string.equalsIgnoreCase("txt")) {
                actionListener = new TextpadAction(file.getPath());
            } else if (string.equalsIgnoreCase("pdf")) {
                actionListener = new AcrobatAction(file.getPath());
            } else if (string.equalsIgnoreCase("xls")) {
                actionListener = new ExcelAction(file.getPath());
            } else if (string.equalsIgnoreCase("html")) {
                actionListener = new BrowserAction(file.getPath());
            }
        } else if (object instanceof XChart) {
            actionListener = new ToolReportDisplay$ReportChartAction(this, (XChart)object, null);
        }
        if (actionListener != null) {
            actionListener.actionPerformed(null);
        } else {
            Application.getWindowManager().showMessage("No action defined for: " + object);
        }
    }

    private JPopupMenu createPopupMenu(Object object) {
        JPopupMenu jPopupMenu = null;
        if (object instanceof File) {
            jPopupMenu = new JPopupMenu();
            File file = (File)object;
            String string = NamingConventions.getExtension(file);
            if (string.equalsIgnoreCase("txt")) {
                jPopupMenu.add(new TextpadAction(file.getPath()));
                jPopupMenu.add(new ExcelAction(file.getPath()));
                jPopupMenu.add(new OsExplorerAction(file.getPath()));
            } else if (string.equalsIgnoreCase("pdf")) {
                jPopupMenu.add(new AcrobatAction(file.getPath()));
                jPopupMenu.add(new OsExplorerAction(file.getPath()));
            } else {
                jPopupMenu.add(new TextpadAction(file.getPath()));
                jPopupMenu.add(new ExcelAction(file.getPath()));
                jPopupMenu.add(new OsExplorerAction(file.getPath()));
            }
        } else if (object instanceof XChart) {
            jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new ToolReportDisplay$ReportChartAction(this, (XChart)object, null));
        }
        return jPopupMenu;
    }

    private static void centerFrame(JFrame jFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void close() {
        this.fFrame.dispose();
        this.fFrame.setVisible(false);
        this.log.debug("Debug mode, so not quiting but hiding");
    }

    static final /* synthetic */ ToolReportDisplay access$100(ToolReportDisplay toolReportDisplay) {
        return toolReportDisplay.fInstance;
    }

    static final /* synthetic */ void access$200(ToolReportDisplay toolReportDisplay) {
        toolReportDisplay.close();
    }

    static final /* synthetic */ void access$500(ToolReportDisplay toolReportDisplay, Object object) {
        toolReportDisplay.runDefaultAction(object);
    }

    static final /* synthetic */ Font access$600() {
        return FONT_DEFAULT_BOLD;
    }

    static final /* synthetic */ Icon access$700(ToolReportDisplay toolReportDisplay, File file) {
        return toolReportDisplay.getIcon(file);
    }

    static final /* synthetic */ JPopupMenu access$800(ToolReportDisplay toolReportDisplay, Object object) {
        return toolReportDisplay.createPopupMenu(object);
    }
}

