/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class SGLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int FILL = 4;
    public static final int TOP = 8;
    public static final int BOTTOM = 16;
    protected int rows;
    protected int cols;
    protected final int vgap;
    protected final int hgap;
    protected int topBorder = 0;
    protected int leftBorder = 0;
    protected int bottomBorder = 0;
    protected int rightBorder = 0;
    protected final int minW = 10;
    protected final int minH = 10;
    protected double[] rowScale;
    protected double[] columnScale;
    protected int hAlignment = 4;
    protected int vAlignment = 4;
    protected int[][] hAlignments;
    protected int[][] vAlignments;
    protected int[] rowSizes;
    protected int[] columnSizes;

    public SGLayout() {
        this(2, 2, 4, 4, 0, 0);
    }

    public SGLayout(int n, int n2) {
        this(n, n2, 4, 4, 0, 0);
    }

    public SGLayout(int n, int n2, int n3, int n4) {
        this(n, n2, 4, 4, n3, n4);
    }

    public SGLayout(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hgap = n5;
        this.vgap = n6;
        this.hAlignment = n3;
        this.vAlignment = n4;
        this.setDimensions(n, n2);
    }

    private void setScaleValues() {
        int n;
        this.rowScale = new double[this.rows];
        this.columnScale = new double[this.cols];
        for (n = 0; n < this.rows; ++n) {
            this.rowScale[n] = 1.0;
        }
        for (n = 0; n < this.cols; ++n) {
            this.columnScale[n] = 1.0;
        }
    }

    private void setAlignments() {
        this.hAlignments = new int[this.rows][this.cols];
        this.vAlignments = new int[this.rows][this.cols];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int i3 = 0; i3 < this.cols; ++i3) {
                this.hAlignments[i2][i3] = this.hAlignment;
                this.vAlignments[i2][i3] = this.vAlignment;
            }
        }
    }

    private void setDimensions(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.setScaleValues();
        this.setAlignments();
    }

    public final void setMargins(int n, int n2, int n3, int n4) {
        this.topBorder = n;
        this.leftBorder = n2;
        this.bottomBorder = n3;
        this.rightBorder = n4;
    }

    public final void setRowScale(int n, double d2) {
        if (n >= 0 && n < this.rows) {
            this.rowScale[n] = d2;
        }
    }

    public final void setColumnScale(int n, double d2) {
        if (n >= 0 && n < this.cols) {
            this.columnScale[n] = d2;
        }
    }

    public final void setAlignment(int n, int n2, int n3, int n4) {
        if (n < this.rows && n2 < this.cols) {
            this.hAlignments[n][n2] = n3;
            this.vAlignments[n][n2] = n4;
        }
    }

    public final void setRowAlignment(int n, int n2, int n3) {
        if (n < this.rows) {
            for (int i2 = 0; i2 < this.cols; ++i2) {
                this.hAlignments[n][i2] = n2;
                this.vAlignments[n][i2] = n3;
            }
        }
    }

    public final void setColumnAlignment(int n, int n2, int n3) {
        if (n < this.cols) {
            for (int i2 = 0; i2 < this.rows; ++i2) {
                this.hAlignments[i2][n] = n2;
                this.vAlignments[i2][n] = n3;
            }
        }
    }

    @Override
    public final void addLayoutComponent(String string, Component component) {
    }

    @Override
    public final void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n6 = 0;
                int n7 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n8 = i2 * n3 + i3;
                    if (n8 >= n) continue;
                    Component component = container.getComponent(n8);
                    Dimension dimension = component.getPreferredSize();
                    n6 = dimension.width < 10 ? (n6 += 10) : (n6 += dimension.width);
                    if (dimension.height <= n7) continue;
                    n7 = dimension.height;
                }
                if (n6 > n4) {
                    n4 = n6;
                }
                n5 += n7;
            }
            return new Dimension(n4 + this.leftBorder + this.rightBorder + (n3 - 1) * this.hgap, n5 + this.topBorder + this.bottomBorder + (n2 - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n6 = 0;
                int n7 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n8 = i2 * n3 + i3;
                    if (n8 >= n) continue;
                    Component component = container.getComponent(n8);
                    Dimension dimension = component.getMinimumSize();
                    int n9 = dimension.width;
                    if (n9 < 10) {
                        n9 = 10;
                    }
                    n6 += n9;
                    if (n7 <= dimension.height) continue;
                    n7 = dimension.height;
                }
                if (n4 > n6) {
                    n4 = n6;
                }
                if (n7 < 10) {
                    n7 = 10;
                }
                n5 += n7;
            }
            return new Dimension(n4 + this.leftBorder + this.rightBorder + (n3 - 1) * this.hgap, n5 + this.topBorder + this.bottomBorder + (n2 - 1) * this.vgap);
        }
    }

    @Override
    public final void layoutContainer(Container container) {
        int n = container.getComponentCount();
        int n2 = this.topBorder;
        this.allocateMaxSizes(container);
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int n3 = this.leftBorder;
            for (int i3 = 0; i3 < this.cols; ++i3) {
                int n4 = i2 * this.cols + i3;
                if (n4 > n - 1) continue;
                Component component = container.getComponent(n4);
                if (component.isVisible()) {
                    this.setComponentBounds(component, i2, i3, n3, n2);
                }
                n3 += this.columnSizes[i3] + this.hgap;
            }
            n2 += this.rowSizes[i2] + this.vgap;
        }
    }

    private final void setComponentBounds(Component component, int n, int n2, int n3, int n4) {
        int n5;
        Dimension dimension = component.getPreferredSize();
        int n6 = this.columnSizes[n2];
        int n7 = this.rowSizes[n];
        int n8 = n6 - dimension.width;
        if (n8 > 0) {
            n5 = this.hAlignments[n][n2];
            if (n5 == 2) {
                n3 += n8;
            } else if (n5 == 1) {
                n3 += n8 / 2;
            }
            if (n5 != 4) {
                n6 = dimension.width;
            }
        }
        if ((n5 = n7 - dimension.height) > 0) {
            int n9 = this.vAlignments[n][n2];
            if (n9 == 16) {
                n4 += n5;
            } else if (n9 == 1) {
                n4 += n5 / 2;
            }
            if (n9 != 4) {
                n7 = dimension.height;
            }
        }
        component.setBounds(n3, n4, n6, n7);
    }

    protected final void allocateMaxSizes(Container container) {
        int n;
        this.rowSizes = new int[this.rows];
        this.columnSizes = new int[this.cols];
        Dimension dimension = container.getSize();
        int n2 = dimension.width - this.leftBorder - this.rightBorder - (this.cols - 1) * this.hgap;
        int n3 = dimension.height - this.topBorder - this.bottomBorder - (this.rows - 1) * this.vgap;
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            d2 += this.rowScale[i2];
        }
        double d3 = 0.0;
        for (n = 0; n < this.cols; ++n) {
            d3 += this.columnScale[n];
        }
        for (n = 0; n < this.rows; ++n) {
            this.rowSizes[n] = (int)(this.rowScale[n] * (double)n3 / d2);
        }
        for (n = 0; n < this.cols; ++n) {
            this.columnSizes[n] = (int)(this.columnScale[n] * (double)n2 / d3);
        }
    }
}

