/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.dnd;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.dnd.DndTarget;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.apache.log4j.Logger;

public class DropTargetDecorator
implements DropTargetListener {
    private final Logger log = XLogger.getLogger(DropTargetDecorator.class);
    private DropTarget fDropTarget;
    private DndTarget fTarget;
    private final int fAcceptActions = 3;

    public DropTargetDecorator(DndTarget dndTarget) {
        if (dndTarget == null) {
            throw new IllegalArgumentException("DndTarget cannot be null");
        }
        this.fTarget = dndTarget;
        this.fDropTarget = new DropTarget(this.fTarget.getDroppableIntoComponent(), this.fAcceptActions, this, true);
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = this.fTarget.getDroppableFlavors();
        for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
            if (!dropTargetDragEvent.isDataFlavorSupported(dataFlavorArray[i2])) continue;
            return true;
        }
        return false;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = this.fTarget.getDroppableFlavors();
        for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
            if (!dropTargetDropEvent.isDataFlavorSupported(dataFlavorArray[i2])) continue;
            return dataFlavorArray[i2];
        }
        return null;
    }

    private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
            return false;
        }
        int n = dropTargetDragEvent.getDropAction();
        return (n & 3) != 0;
    }

    @Override
    public final void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public final void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            dropTargetContext.getComponent().setCursor(DragSource.DefaultCopyNoDrop);
            dropTargetContext.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public final void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public final void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public final void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        int n = dropTargetDropEvent.getSourceActions();
        if ((n & 3) == 0) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Object object = null;
        try {
            dropTargetDropEvent.acceptDrop(this.fAcceptActions);
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            if (object == null) {
                throw new NullPointerException("Tarnsferable data was null");
            }
            this.fTarget.setDropData(object);
            dropTargetDropEvent.dropComplete(true);
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Bad drop -- couldn't get transfer data", throwable);
            dropTargetDropEvent.dropComplete(false);
        }
    }
}

