/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.strucs.NamedColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ColorUtils {
    public static Color COLOR_LIGHT_BLUE = new Color(150, 150, 255);
    public static final Color COLOR_DARK_BROWN = new Color(128, 64, 64);
    public static final Color COLOR_VERY_LIGHT_GRAY = new Color(239, 239, 239);
    public static final Color COLOR_DARK_BLUE = new Color(63, 64, 124);
    public static final Color COLOR_LIGHT_GREEN = new Color(153, 247, 121);
    public static final Color COLOR_LIGHT_ORANGE = new Color(255, 172, 89);
    public static final NamedColor[] COMMON_COLORS = new NamedColor[]{new NamedColor("Black", Color.black), new NamedColor("Blue", Color.blue), new NamedColor("Brown", new Color(Integer.decode("#A52A2A"))), new NamedColor("CadetBlue", new Color(Integer.decode("#5F9EA0"))), new NamedColor("Chocolate", new Color(Integer.decode("#8B4513"))), new NamedColor("Cyan", Color.cyan), new NamedColor("DarkBlue", COLOR_DARK_BLUE), new NamedColor("DarkBrown", COLOR_DARK_BROWN), new NamedColor("DarkGray", Color.darkGray), new NamedColor("DarkGreen", new Color(Integer.decode("#006400"))), new NamedColor("Gold", new Color(Integer.decode("#FFD700"))), new NamedColor("Gray", Color.gray), new NamedColor("Green", Color.green), new NamedColor("LightGray", Color.lightGray), new NamedColor("LightGreen", COLOR_LIGHT_GREEN), new NamedColor("LightOrange", COLOR_LIGHT_ORANGE), new NamedColor("LightRed", new Color(Integer.decode("#FF3030"))), new NamedColor("Magenta", Color.magenta), new NamedColor("Orange", Color.orange), new NamedColor("Pink", Color.pink), new NamedColor("Red", Color.red), new NamedColor("SeaGreen", new Color(Integer.decode("#54FF9F"))), new NamedColor("SkyBlue", new Color(Integer.decode("#87CEEB"))), new NamedColor("Turquoise", new Color(Integer.decode("#00F5FF"))), new NamedColor("White", Color.white), new NamedColor("Yellow", Color.yellow)};
    private static final Logger klog = XLogger.getLogger(ColorUtils.class);
    private static final Map kUcNameColorMap = new HashMap();
    private static final Map kColorUcNameMap = new HashMap();

    public static final String nameForColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Param c cannot be null");
        }
        Object v = kColorUcNameMap.get(color);
        if (v != null) {
            return (String)v;
        }
        return "new java.awt.Color(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public static final Color colorForName(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        String string2 = string.toUpperCase();
        Object v = kUcNameColorMap.get(string2);
        if (v != null) {
            return (Color)v;
        }
        if (bl) {
            throw new IllegalArgumentException("Invalid color specfied: " + string);
        }
        klog.warn("Unknown color name: " + string + " using black");
        return Color.black;
    }

    public static final String toHex(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('#');
        String string = Integer.toHexString(color.getRGB() & 0x1FFFFFF);
        stringBuffer.append(string.substring(1));
        return stringBuffer.toString();
    }

    public static final Color parse(String string, boolean bl) {
        if (string.charAt(0) == '#') {
            try {
                Integer n = Integer.valueOf(string.substring(1), 16);
                return new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid RGB color syntax: " + string);
            }
        }
        Color color = ColorUtils.colorForName(string, bl);
        if (color == null) {
            throw new IllegalArgumentException("Unknown color name: " + string);
        }
        return color;
    }

    public static final Color[] generate(int n) {
        Color[] colorArray = new Color[n];
        for (int i2 = 0; i2 < n; ++i2) {
            colorArray[i2] = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        }
        return colorArray;
    }

    public static final Color[] generate(int n, Color[] colorArray) {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 < colorArray.length) {
                arrayList.add(colorArray[i2]);
                continue;
            }
            arrayList.add(ColorUtils.generate());
        }
        return arrayList.toArray(new Color[arrayList.size()]);
    }

    public static final Color generate() {
        return new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    static {
        for (int i2 = 0; i2 < COMMON_COLORS.length; ++i2) {
            kUcNameColorMap.put(ColorUtils.COMMON_COLORS[i2].name.toUpperCase(), ColorUtils.COMMON_COLORS[i2].color);
            kColorUcNameMap.put(ColorUtils.COMMON_COLORS[i2].color, ColorUtils.COMMON_COLORS[i2].name.toUpperCase());
        }
    }
}

