/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.FileUtils$ContainsFileFilter;
import edu.mit.broad.genome.utils.FileUtils$EndsWithFileFilter;
import edu.mit.broad.genome.utils.FileUtils$ExtensionFileFilter;
import edu.mit.broad.genome.utils.FileUtils$ExtensionsFileFilter;
import edu.mit.broad.genome.utils.FileUtils$StartsWithEndsWithFileFilter;
import edu.mit.broad.genome.utils.FileUtils$StartsWithFileFilter;
import edu.mit.broad.genome.utils.Strings;
import edu.mit.broad.genome.utils.SystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger klog = XLogger.getLogger(FileUtils.class);
    public static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static List windows_roots;

    public static final String path2name(String string) {
        if (string.indexOf(47) == -1 && string.indexOf(92) == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\");
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static final int countLines(File file, boolean bl) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        return FileUtils._countLines(bufferedReader, bl);
    }

    public static final int countLines(String string, boolean bl) {
        return FileUtils.countLines(new File(string), bl);
    }

    private static int _countLines(BufferedReader bufferedReader, boolean bl) {
        int n = 0;
        if (!bl) {
            while (bufferedReader.readLine() != null) {
                ++n;
            }
        } else {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.trim().length() > 0) {
                    ++n;
                }
                string = bufferedReader.readLine();
            }
        }
        bufferedReader.close();
        return n;
    }

    public static final void writeFofn(List list, boolean bl, File file) {
        FileUtils.writeFofn(list.toArray(new File[list.size()]), bl, file);
    }

    public static final void writeFofn(File[] fileArray, boolean bl, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (bl) {
                stringBuffer.append(fileArray[i2].getAbsolutePath()).append('\n');
                continue;
            }
            stringBuffer.append(fileArray[i2].getName()).append('\n');
        }
        FileUtils.write(stringBuffer.toString(), file);
    }

    public static final String getRelativePath(File file, File file2) {
        String string = file.getPath();
        return string.substring(file2.getPath().length() + 1, string.length());
    }

    public static final boolean isSubFile(File file, File file2) {
        int n = file.getPath().indexOf(file2.getPath());
        return n != -1;
    }

    public static final String unixPath(File file) {
        return file.getPath().replace('\\', '/');
    }

    public static final String unixPath(String string) {
        return string.replace('\\', '/');
    }

    public static final String windowsPath(File file) {
        return file.getPath().replace('/', '\\');
    }

    public static final String windowsPath(String string) {
        return string.replace('/', '\\');
    }

    public static final boolean isWindowsFileSystem() {
        return File.separatorChar == '\\';
    }

    public static final boolean isUnixFileSystem() {
        return File.separatorChar == '/';
    }

    public static final boolean isMacFileSystem() {
        return File.separatorChar == ':';
    }

    public static final File[] bugFixListRoots() {
        if (FileUtils.isWindowsFileSystem()) {
            if (windows_roots == null) {
                windows_roots = new ArrayList();
                for (char c2 = 'C'; c2 <= 'Z'; c2 = (char)((char)(c2 + 1))) {
                    char[] cArray = new char[]{c2, ':', '\\'};
                    String string = new String(cArray);
                    File file = new File(string);
                    if (!file.exists()) continue;
                    windows_roots.add(new File(string));
                }
            }
            return windows_roots.toArray(new File[windows_roots.size()]);
        }
        return File.listRoots();
    }

    public static final File getSafeChildFile(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    public static final boolean isRWIfFileExists(File file) {
        if (!file.exists()) {
            return true;
        }
        if (!file.canRead()) {
            return false;
        }
        if (!file.canWrite()) {
            return false;
        }
        return !file.isDirectory();
    }

    public static final boolean isRWFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        return file.canWrite();
    }

    public static final boolean isValidDir(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.isDirectory();
    }

    public static final File createTempFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.currentTimeMillis());
        return File.createTempFile(stringBuffer.toString(), string);
    }

    public static final FilenameFilter createExtFileFilter(String string) {
        return new FileUtils$ExtensionFileFilter(string);
    }

    public static final FilenameFilter createExtsFileNameFilter(String[] stringArray) {
        return new FileUtils$ExtensionsFileFilter(stringArray);
    }

    public static final FileFilter createExtsFileFilter(String[] stringArray) {
        return new FileUtils$ExtensionsFileFilter(stringArray);
    }

    public static final FilenameFilter createExtsFileFilter(Set set) {
        return new FileUtils$ExtensionsFileFilter(set);
    }

    public static final File createTempFile() {
        return FileUtils.createTempFile(".result");
    }

    public static final String shortenedPathRepresentation(File file) {
        if (file != null && file.getParentFile() != null) {
            return ".." + File.separator + file.getParentFile().getName() + File.separator + file.getName();
        }
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    public static final String shortenedPathRepresentation(String string) {
        return FileUtils.shortenedPathRepresentation(new File(string));
    }

    public static final File copy(File file, File file2) {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileUtils.copy(fileInputStream, fileOutputStream);
        return file2;
    }

    public static final void copy(URL uRL, File file) {
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileUtils.copy(inputStream, fileOutputStream);
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    public static final void write(String string, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print(string);
        printWriter.close();
    }

    public static final void writeSafely(String string, File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.print(string);
            printWriter.close();
        }
        catch (Throwable throwable) {
            klog.error("Writing to file: " + file + " failed");
        }
    }

    public static final void write(List list, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            printWriter.println(list.get(i2));
        }
        printWriter.close();
    }

    public static final void write(String[] stringArray, File file, boolean bl) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (bl) {
                printWriter.print(stringArray[i2]);
                if (i2 == stringArray.length - 1) continue;
                printWriter.print('\t');
                continue;
            }
            printWriter.println(stringArray[i2]);
        }
        printWriter.close();
    }

    public static final void writeTabularFile(List list, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = (String[])list.get(i2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                stringBuffer.append(stringArray[i3]);
                if (i3 == stringArray.length - 1) continue;
                stringBuffer.append('\t');
            }
            stringBuffer.append('\n');
            printWriter.write(stringBuffer.toString());
        }
        printWriter.close();
    }

    public static final void write(Map map, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (Object k2 : map.keySet()) {
            printWriter.println(k2 + "\t" + map.get(k2));
        }
        printWriter.close();
    }

    public static final void writeByRow(Matrix matrix, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i2 = 0; i2 < matrix.getNumRow(); ++i2) {
            printWriter.println(matrix.getRowV(i2).toString('\t'));
        }
        printWriter.close();
    }

    public static final File writeByColumn(Matrix matrix, File file) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i2 = 0; i2 < matrix.getNumCol(); ++i2) {
            printWriter.println(matrix.getColumnV(i2).toString('\t'));
        }
        printWriter.close();
        return file;
    }

    public static final File write(Vector[] vectorArray, File file, boolean bl) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        FileUtils._out(vectorArray, printWriter, bl);
        return file;
    }

    public static final File append(Vector[] vectorArray, File file, boolean bl) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath(), true));
        FileUtils._out(vectorArray, printWriter, bl);
        return file;
    }

    private static void _out(Vector[] vectorArray, PrintWriter printWriter, boolean bl) {
        int n = Vector.maxSize(vectorArray);
        if (bl) {
            for (int i2 = 0; i2 < n; ++i2) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                    if (i2 < vectorArray[i3].getSize()) {
                        stringBuffer.append(vectorArray[i3].getElement(i2));
                    }
                    if (i3 == vectorArray.length - 1) continue;
                    stringBuffer.append('\t');
                }
                printWriter.println(stringBuffer.toString());
            }
        } else {
            for (int i4 = 0; i4 < vectorArray.length; ++i4) {
                printWriter.println(vectorArray[i4].toString('\t'));
            }
        }
        printWriter.close();
    }

    public static final File write(Vector vector, File file, boolean bl) {
        return FileUtils.write(new Vector[]{vector}, file, bl);
    }

    public static final File append(Vector vector, File file, boolean bl) {
        return FileUtils.append(new Vector[]{vector}, file, bl);
    }

    public static final File write(Vector vector, File file, int n) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        int n2 = 1;
        if (vector.getSize() >= n) {
            if (vector.getSize() % n != 0) {
                klog.warn("Ignoring chunk size vector size: " + vector.getSize() + " not a multiple of horiz chunk size: " + n);
            }
            n2 = vector.getSize() / n;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i3 = 0; i3 < n; ++i3) {
                stringBuffer.append(vector.getElement(n3++)).append('\t');
            }
            printWriter.println(stringBuffer.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i4 = n3; i4 < vector.getSize(); ++i4) {
            stringBuffer.append(vector.getElement(i4)).append('\t');
        }
        if (stringBuffer.length() > 0) {
            printWriter.println(stringBuffer.toString());
        }
        printWriter.close();
        return file;
    }

    public static final void append(String string, File file) {
        if (file == null || !file.exists()) {
            throw new IOException("File does not exist: " + file);
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file.getPath(), true));
        printWriter.print(string);
        printWriter.close();
    }

    public static final boolean hasExtension(String string, String string2) {
        int n = string.lastIndexOf("." + string2);
        return n != -1;
    }

    public static final String getExtension(File file) {
        return FileUtils.getExtension(file.getName());
    }

    public static final String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }

    public static final int compareExt(File file, File file2) {
        return NamingConventions.getExtension(file).compareToIgnoreCase(NamingConventions.getExtension(file2));
    }

    public static final String changeExtension(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n).concat(".").concat(string2);
    }

    public static final String stripSuffixSlash(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if (string.equals("/")) {
            return "";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.lastIndexOf("/"));
        }
        return string;
    }

    public static final void removeDuplicateLines(File file, File file2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = 0;
        int n2 = 0;
        String string = ParseUtils.nextLine(bufferedReader);
        while (string != null) {
            ++n;
            if (arrayList.contains(string)) {
                klog.debug("dup: " + string);
                ++n2;
            } else {
                arrayList.add(string);
            }
            string = ParseUtils.nextLine(bufferedReader);
        }
        bufferedReader.close();
        klog.info("Original # of lines = " + n + " # of duplicate lines = " + n2);
        FileUtils.write(arrayList, file2);
    }

    public static final File toFile(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        return new File(string);
    }

    public static final URL toURL(File file) {
        return file.toURL();
    }

    public static final BufferedReader toBufferedReader(String string) {
        URL uRL = FileUtils.toURL(string);
        return new BufferedReader(new InputStreamReader(uRL.openStream()));
    }

    private static URL toURL(String string) {
        if (string.indexOf(58) == -1) {
            return new File(string).toURL();
        }
        return new URL(string);
    }

    public static final URL[] toURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURL();
        }
        return uRLArray;
    }

    public static final String removeExtension(String string) {
        return NamingConventions.removeExtension(string);
    }

    public static final String removeExtension(File file) {
        return NamingConventions.removeExtension(file.getName());
    }

    public static final String removeExtensionIfPresent(File file, String string) {
        return FileUtils.removeExtensionIfPresent(file.getName(), string);
    }

    public static final String removeExtensionIfPresent(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static final String removePath(String string) {
        return FileUtils.removePath(string, File.separatorChar);
    }

    public static final String removePath(String string, char c2) {
        int n = string.lastIndexOf(c2);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static final String getPath(String string) {
        return FileUtils.getPath(string, File.separatorChar);
    }

    public static final String getPath(String string, char c2) {
        int n = string.lastIndexOf(c2);
        if (-1 == n) {
            return "";
        }
        return string.substring(0, n);
    }

    public static final String getCrossPlatformName(String string) {
        String string2 = FileUtils.getName(string, '/');
        string2 = FileUtils.getName(string2, '\\');
        return string2;
    }

    public static final String getCrossPlatformName(File file) {
        return FileUtils.getCrossPlatformName(file.getPath());
    }

    public static final String getName(String string, char c2) {
        int n = string.lastIndexOf(c2);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public static final boolean isPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        return stringTokenizer.countTokens() != 1;
    }

    public static final boolean deleteRecursive(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                if (FileUtils.deleteOnlyFilesRecursively(file)) {
                    return file.delete();
                }
                return false;
            }
            return file.delete();
        }
        return true;
    }

    public static final boolean deleteOnlyFilesRecursively(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file2 = new File(file, stringArray[i2]);
                if (file2.isDirectory() && !FileUtils.deleteOnlyFilesRecursively(file2)) {
                    return false;
                }
                if (file2.delete()) continue;
                return false;
            }
        }
        return true;
    }

    public static final void deleteFilesInDirs(File[] fileArray) {
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            FileUtils.deleteFilesInDir(fileArray[i2]);
        }
    }

    public static final boolean deleteFilesInDir(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter dir cannot be null");
        }
        boolean bl = true;
        if (!file.isDirectory()) {
            klog.error("Not a directory!" + file);
            bl = false;
        }
        klog.info("Deleting files in dir: " + file.getAbsolutePath());
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            boolean bl2;
            if (!fileArray[i2].isFile() || (bl2 = fileArray[i2].delete())) continue;
            klog.error("could not delete file: " + fileArray[i2]);
            bl = false;
        }
        return bl;
    }

    public static final boolean deleteDirsNotRecursive(File[] fileArray) {
        boolean bl = true;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            boolean bl2 = fileArray[i2].delete();
            if (bl2) continue;
            bl = bl2;
        }
        return bl;
    }

    public static final File ungz(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Param source  cannot be null");
        }
        if (!file.getName().endsWith(".gz")) {
            throw new IllegalArgumentException("Not a gz file: " + file.getName());
        }
        File file2 = new File(file.getParentFile(), FileUtils.removeExtensionIfPresent(file.getName(), ".gz"));
        FileUtils.ungz(file, file2);
        return file2;
    }

    public static final void ungz(File file, File file2) {
        if (file.lastModified() > file2.lastModified()) {
            klog.info("Expanding " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
            FileOutputStream fileOutputStream = null;
            GZIPInputStream gZIPInputStream = null;
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                gZIPInputStream = new GZIPInputStream(bufferedInputStream);
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = gZIPInputStream.read(byArray, 0, byArray.length)) != -1);
            }
            catch (IOException iOException) {
                String string = "Problem expanding gz " + iOException.getMessage();
                throw new IOException(string + " " + iOException.getMessage());
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (gZIPInputStream != null) {
                    gZIPInputStream.close();
                }
            }
        }
    }

    public static final void listArchive(File file) {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            System.out.println(zipEntry.getName());
        }
    }

    public static final List listFilesL(File[] fileArray, FilenameFilter filenameFilter, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            arrayList.addAll(FileUtils.listFilesL(fileArray[i2], filenameFilter, bl));
        }
        return arrayList;
    }

    public static final File findFile(File file, String string, boolean bl) {
        Object[] objectArray = FileUtils.listFiles_by_ends_with(file, string, false);
        if (objectArray != null && objectArray.length == 1) {
            return objectArray[0];
        }
        if (bl) {
            throw new IllegalArgumentException("No file with endsWith: " + string + " found in dir: " + file + "\n" + Printf.outs(objectArray));
        }
        return null;
    }

    public static final File findFile(File file, String[] stringArray, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.addAll(Arrays.asList(FileUtils.listFiles_by_ends_with(file, stringArray[i2], false)));
        }
        File[] fileArray = arrayList.toArray(new File[arrayList.size()]);
        if (fileArray.length == 1) {
            return fileArray[0];
        }
        if (bl) {
            throw new IllegalArgumentException("No file found in dir: <" + file + "< with endsWiths\n" + Printf.outs(stringArray));
        }
        return null;
    }

    public static final File[] listFiles(File file, String string, boolean bl) {
        return FileUtils.listFiles(file, new FileUtils$ExtensionFileFilter(string), bl);
    }

    public static final Set listFiles_set(File file, String string, boolean bl) {
        return new HashSet<File>(Arrays.asList(FileUtils.listFiles(file, string, bl)));
    }

    public static final File[] listFiles(File file, String[] stringArray, boolean bl) {
        return FileUtils.listFiles(file, new FileUtils$ExtensionsFileFilter(stringArray), bl);
    }

    public static final File[] listFiles_by_ends_with(File file, String string, boolean bl) {
        return FileUtils.listFiles(file, new FileUtils$EndsWithFileFilter(string), bl);
    }

    public static final File[] listFiles_by_starts_with(File file, String string, boolean bl) {
        return FileUtils.listFiles(file, new FileUtils$StartsWithFileFilter(string), bl);
    }

    public static final File[] listFiles_by_starts_with_ends_with(File file, String string, String string2, boolean bl) {
        return FileUtils.listFiles(file, new FileUtils$StartsWithEndsWithFileFilter(string, string2), bl);
    }

    public static final File[] listFiles_by_contains(File file, String string, boolean bl) {
        return FileUtils.listFiles(file, new FileUtils$ContainsFileFilter(string), bl);
    }

    public static final File[] listFiles(File file, FilenameFilter filenameFilter, boolean bl) {
        if (bl) {
            return FileUtils._listFilesRecursive(file, filenameFilter);
        }
        if (filenameFilter == null) {
            return file.listFiles();
        }
        return file.listFiles(filenameFilter);
    }

    public static final File[] listFiles(File file, boolean bl) {
        FilenameFilter filenameFilter = null;
        return FileUtils.listFiles(file, filenameFilter, bl);
    }

    public static final List listFilesL(File file, FilenameFilter filenameFilter, boolean bl) {
        return FileUtils._toList(FileUtils.listFiles(file, filenameFilter, bl));
    }

    public static final File[] listFileByContains(String string, File file) {
        HashSet<File> hashSet = new HashSet<File>();
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!Strings.contains(fileArray[i2].getName(), string, true)) continue;
            hashSet.add(fileArray[i2]);
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public static final File[] listDirs(File file, boolean bl) {
        File[] fileArray = FileUtils.listFiles(file, bl);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!fileArray[i2].isDirectory()) continue;
            arrayList.add(fileArray[i2]);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static boolean isDirectory(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    private static File[] _listFilesRecursive(String string, FilenameFilter filenameFilter) {
        if (!new File(string).isDirectory()) {
            klog.warn("You asked me to list a File!: " + string);
        }
        ArrayList arrayList = new ArrayList();
        FileUtils.scanTree(string, arrayList, filenameFilter);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static File[] _listFilesRecursive(File file, FilenameFilter filenameFilter) {
        return FileUtils._listFilesRecursive(file.getPath(), filenameFilter);
    }

    private static void scanTree(String string, List list, FilenameFilter filenameFilter) {
        File file = new File(string);
        String[] stringArray = FileUtils._getList_for_tree_scan(file, filenameFilter);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (FileUtils.isDirectory(string + File.separator + stringArray[i2])) {
                FileUtils.scanTree(string + File.separator + stringArray[i2], list, filenameFilter);
                continue;
            }
            File file2 = new File(string + File.separator + stringArray[i2]);
            list.add(file2);
        }
    }

    private static String[] _getList_for_tree_scan(File file, FilenameFilter filenameFilter) {
        try {
            if (filenameFilter != null) {
                return file.list(filenameFilter);
            }
            return file.list();
        }
        catch (Exception exception) {
            klog.error(exception);
            return null;
        }
    }

    public static final boolean isLocked(File file) {
        if (!file.exists()) {
            return false;
        }
        File file2 = new File(file.getAbsolutePath());
        StringBuffer stringBuffer = new StringBuffer(file.getName()).append(System.currentTimeMillis()).append(".lock_check");
        File file3 = new File(SystemUtils.getTmpDir(), stringBuffer.toString());
        boolean bl = file.renameTo(file3);
        if (!bl) {
            return true;
        }
        boolean bl2 = file3.renameTo(file2);
        if (!bl2) {
            throw new IllegalStateException("Bad error - couldnt move file back after lock check");
        }
        return false;
    }

    private static List _toList(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            arrayList.add(fileArray[i2]);
        }
        return arrayList;
    }
}

