/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.XLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class Zipper {
    private static final Logger klog = XLogger.getLogger(Zipper.class);
    private ZipOutputStream fZos;
    private File fSource;
    private int fCnt;
    int kcnt = 0;

    public final void zipIt(File file, File file2) {
        try {
            klog.info("Zipping: " + file.getName() + " to " + file2.getName());
            this.fSource = file;
            this.fCnt = 0;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.fZos = new ZipOutputStream(fileOutputStream);
            this.dirFunc(this.fSource);
            this.fZos.flush();
            this.fZos.close();
            this.fZos.close();
            StringBuffer stringBuffer = new StringBuffer("Zipped folder\n");
            stringBuffer.append("Zip source: ").append(file.getPath()).append('\n');
            stringBuffer.append("Zipped to : ").append(file2.getPath()).append('\n');
            stringBuffer.append("Number of files = " + this.fCnt).append('\n');
        }
        catch (Throwable throwable) {
            klog.error("Zipping error", throwable);
        }
    }

    private void dirFunc(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    if (fileArray[i2].isDirectory()) {
                        this.dirFunc(fileArray[i2]);
                        continue;
                    }
                    if (!fileArray[i2].isFile()) continue;
                    this.add(fileArray[i2]);
                }
            } else {
                System.out.println(file + " is not a directory.");
            }
        } else {
            klog.warn("Directory " + file + " does not exist.");
        }
    }

    private void add(File file) {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file.getPath());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        String string = file.getPath();
        string = string.substring(this.fSource.getPath().length());
        ZipEntry zipEntry = new ZipEntry(string);
        this.fZos.putNextEntry(zipEntry);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > -1) {
            this.fZos.write(byArray, 0, n);
        }
        if (this.kcnt % 5 == 0) {
            System.out.println("Added to zip archive file " + file + " count: " + this.kcnt);
        }
        ++this.kcnt;
    }
}

