/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideButton;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.models.NumberedProxyModel;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper$Button;
import edu.mit.broad.genome.swing.GuiHelper$Table;
import edu.mit.broad.genome.swing.VerticalFlowLayout;
import edu.mit.broad.genome.viewers.Viewer;
import edu.mit.broad.xbench.actions.ext.ExcelAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public abstract class AbstractViewer
extends JPanel
implements Viewer {
    protected Logger log;
    protected static final Logger klog = XLogger.getLogger(AbstractViewer.class);
    private Icon fIcon;
    private String fName;
    private String fTitle;
    private static final Icon SMALL_EXCEL_ICON = JarResources.getIcon("Excel13.gif");
    private static final Icon SMALL_EXCEL_NA_ICON = JarResources.getIcon("ExcelNa.gif");

    protected AbstractViewer() {
        this.log = XLogger.getLogger(this.getClass());
    }

    public AbstractViewer(String string, Icon icon, String string2) {
        this.init(string, icon, string2);
    }

    public AbstractViewer(String string, Icon icon, PersistentObject persistentObject) {
        this(string, icon, AbstractViewer.formatTitle(persistentObject, string));
    }

    protected final void init(String string, Icon icon, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Param title cannot be null");
        }
        this.fIcon = icon;
        this.fName = string;
        this.fTitle = string2;
        if (this.log == null) {
            this.log = XLogger.getLogger(this.getClass());
        }
    }

    @Override
    public boolean allowClose() {
        return true;
    }

    @Override
    public JComponent getWindowUI() {
        this._checkInit();
        return this;
    }

    @Override
    public Icon getIcon() {
        this._checkInit();
        return this.fIcon;
    }

    @Override
    public String getName() {
        this._checkInit();
        return this.fName;
    }

    private void _checkInit() {
        if (this.fName == null) {
            throw new IllegalStateException("Viewer likely not init'ed name: " + this.fName);
        }
        if (this.fTitle == null) {
            throw new IllegalStateException("Viewer likely not init'ed title: " + this.fTitle);
        }
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    protected final void showError(Throwable throwable) {
        Application.getWindowManager().showError(throwable);
    }

    protected final void showError(String string) {
        Application.getWindowManager().showError(string);
    }

    protected static final JButton createButton(Action action) {
        JideButton jideButton = new JideButton(action);
        jideButton.setButtonStyle(1);
        GuiHelper$Button.addMouseOverRollOverAction(jideButton);
        return jideButton;
    }

    protected static final JComponent createToolBar(Action[] actionArray) {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        for (int i2 = 0; i2 < actionArray.length; ++i2) {
            jPanel.add(AbstractViewer.createButton(actionArray[i2]));
        }
        return jPanel;
    }

    protected static final JPanel wrap(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected static final Dimension getPlaceHolderSize() {
        return new Dimension(200, 200);
    }

    protected static final Component createEmptyFiller() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(AbstractViewer.getPlaceHolderSize());
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    protected static final Component createEmptyFiller(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(AbstractViewer.getPlaceHolderSize().width, n));
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    protected static final void showInPopup(Component component, Component component2) {
        JidePopup jidePopup = new JidePopup();
        jidePopup.setMovable(false);
        jidePopup.getContentPane().setLayout(new BorderLayout());
        jidePopup.getContentPane().add(component);
        jidePopup.setDefaultFocusComponent(component);
        jidePopup.setOwner(component2);
        jidePopup.setResizable(true);
        jidePopup.setMovable(true);
        if (jidePopup.isPopupVisible()) {
            jidePopup.hidePopup();
        } else {
            jidePopup.showPopup();
        }
    }

    protected static final String formatTitle(PersistentObject persistentObject, String string) {
        if (persistentObject == null) {
            return "na -- " + string;
        }
        return persistentObject.getName();
    }

    protected static final String formatTitle(PersistentObject persistentObject) {
        if (persistentObject == null) {
            return "na";
        }
        return persistentObject.getName();
    }

    protected static final void setColumnSize(int n, int n2, JTable jTable, boolean bl) {
        GuiHelper$Table.setColumnSize(n, n2, jTable, bl);
    }

    protected static final JScrollPane createExcelScrollPane(JTable jTable, PersistentObject persistentObject) {
        JButton jButton;
        JScrollPane jScrollPane = AbstractViewer.createAlwaysScrollPane(jTable);
        if (ParserFactory.getCache().isCached(persistentObject)) {
            File file = ParserFactory.getCache().getSourceFile(persistentObject);
            jButton = new JButton(new ExcelAction(file.getPath()));
            jButton.setText("");
            jButton.setIcon(SMALL_EXCEL_ICON);
            jButton.setToolTipText("Click me to open the object in Excel");
        } else {
            jButton = new JButton(SMALL_EXCEL_NA_ICON);
            jButton.setText("");
            jButton.setToolTipText("Object constructed in memory and hence na for excel view");
        }
        jScrollPane.setCorner("LOWER_RIGHT_CORNER", jButton);
        return jScrollPane;
    }

    protected static final JScrollPane createAlwaysScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        return jScrollPane;
    }

    protected static final SortableTable createTable(TableModel tableModel, boolean bl, boolean bl2) {
        TableModel tableModel2 = tableModel;
        if (bl) {
            tableModel2 = new NumberedProxyModel(tableModel);
        }
        SortableTable sortableTable = new SortableTable(tableModel2);
        if (bl) {
            AbstractViewer.setColumnSize(35, 0, sortableTable, true);
        }
        sortableTable.setCellSelectionEnabled(true);
        return sortableTable;
    }
}

