/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.DatasetModel;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.swing.PointLayout;
import edu.mit.broad.genome.viewers.AbstractViewer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class DatasetViewer
extends AbstractViewer {
    public static final String NAME = "DatasetViewer";
    public static final Icon ICON = JarResources.getIcon("Res16.gif");
    private final Dataset fDataset;

    public DatasetViewer(Dataset dataset) {
        super(NAME, ICON, dataset);
        this.fDataset = dataset;
        this.jbInit();
    }

    private void jbInit() {
        DatasetModel datasetModel = new DatasetModel(this.fDataset);
        SortableTable sortableTable = DatasetViewer.createTable(datasetModel, true, true);
        ((JTable)sortableTable).setAutoResizeMode(0);
        this.setLayout(new PointLayout());
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        JScrollPane jScrollPane = DatasetViewer.createExcelScrollPane(sortableTable, this.fDataset);
        jTabbedPane.addTab("Data", jScrollPane);
        jTabbedPane.addTab("Info", this.getDatasetInfo(this.fDataset));
        this.add(jTabbedPane);
    }

    private JComponent getDatasetInfo(Dataset dataset) {
        StringBuffer stringBuffer = new StringBuffer("Name: ").append(dataset.getName()).append('\n');
        stringBuffer.append("Number of rows(features): ").append(dataset.getNumRow()).append('\n');
        stringBuffer.append("Num of columns(samples): ").append(dataset.getNumCol()).append('\n');
        String string = dataset.getComment();
        if (string != null && string.length() > 0) {
            stringBuffer.append("\nComments\n");
            stringBuffer.append(dataset.getComment());
        }
        stringBuffer.append("\nColumn Names\n");
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            stringBuffer.append(dataset.getColumnName(i2)).append('\n');
        }
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        return new JScrollPane(jTextArea);
    }
}

