/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GeneSetMatrixPairImpl;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.GeneSetPairImpl;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.strucs.Hyperlink;
import edu.mit.broad.genome.reports.DefaultHyperlink;
import edu.mit.broad.genome.reports.web.WebResources;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.NullSymbolMode;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractChip
extends AbstractObject
implements Chip {
    protected String fSourcePath;
    private static final String[] AFFY_CLUES = new String[]{"AFFX", "_at", "_st", "_s"};
    private String fBaseLinkURL;
    private boolean fDoneLookup;

    @Override
    public Chip cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    protected AbstractChip() {
    }

    public AbstractChip(String string, String string2) {
        super.initialize(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter sourcePath cannot be null");
        }
        this.fSourcePath = string2;
    }

    @Override
    public Hyperlink getHyperlink(String string) {
        String string2 = this._getProbeBaseLinkURL(string);
        if (string2 != null) {
            return new DefaultHyperlink(string, string2 + string);
        }
        return null;
    }

    private String _getProbeBaseLinkURL(String string) {
        if (this.fDoneLookup) {
            return this.fBaseLinkURL;
        }
        if (VdbRuntimeResources.isChipGeneSymbol(this)) {
            this.fBaseLinkURL = WebResources.STANFORD_SOURCE_GENE.getUrlPrefix();
            this.fDoneLookup = true;
            return this.fBaseLinkURL;
        }
        boolean bl = false;
        for (int i2 = 0; i2 < AFFY_CLUES.length; ++i2) {
            if (string.toUpperCase().startsWith(AFFY_CLUES[i2].toUpperCase())) {
                bl = true;
                break;
            }
            if (!string.toUpperCase().endsWith(AFFY_CLUES[i2].toUpperCase())) continue;
            bl = true;
            break;
        }
        this.fBaseLinkURL = bl ? WebResources.NETAFFX.getUrlPrefix() : null;
        this.fDoneLookup = true;
        return this.fBaseLinkURL;
    }

    @Override
    public String getSourcePath() {
        return this.fSourcePath;
    }

    protected final File getFile() {
        return new File(this.fSourcePath);
    }

    public final boolean equals(Object object) {
        return object instanceof Chip && ((Chip)object).getName().equalsIgnoreCase(this.getName());
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public String[] probize(String[] stringArray) {
        return this.probize_gs(new FSet("symbols_" + stringArray.length, stringArray)).getMembersArray();
    }

    @Override
    public GeneSet probize_gs(String[] stringArray) {
        return this.probize_gs(new FSet("symbols_" + stringArray.length, stringArray));
    }

    @Override
    public String[] probize(GeneSet geneSet) {
        return this.probize_gs(geneSet).getMembersArray();
    }

    @Override
    public GeneSet probize_gs(GeneSet geneSet) {
        try {
            Chip2ChipMapperSymbol chip2ChipMapperSymbol = new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), this);
            return chip2ChipMapperSymbol.map(geneSet, false).getMappedGeneSet(true);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public String[] getProbeNamesArr() {
        Set set = this.getProbeNames();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public GeneSet getProbeNamesAsGeneSet() {
        return new FSet(this.getName(), this.getProbeNames());
    }

    @Override
    public Gene getHugo(String string) {
        return this.getProbe(string).getGene();
    }

    @Override
    public Set getHugos(GeneSet geneSet) {
        HashSet<Gene> hashSet = new HashSet<Gene>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            hashSet.add(this.getHugo(geneSet.getMember(i2)));
        }
        return hashSet;
    }

    @Override
    public Set getSymbols(GeneSet geneSet, NullSymbolMode nullSymbolMode) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            String string2 = this.getSymbol(string, nullSymbolMode);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    @Override
    public GeneSet getSymbols_gs(GeneSet geneSet, NullSymbolMode nullSymbolMode) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            String string2 = this.getSymbol(string, nullSymbolMode);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return new FSet(geneSet.getName(true) + "_symbolized", hashSet);
    }

    @Override
    public Set getSymbols(NullSymbolMode nullSymbolMode) {
        return this.getSymbols(this.getProbeNamesAsGeneSet(), nullSymbolMode);
    }

    @Override
    public GeneSetPair getSymbols(GeneSetPair geneSetPair, NullSymbolMode nullSymbolMode) {
        return new GeneSetPairImpl(geneSetPair.getName() + "_symbols", new FSet(geneSetPair.getUp().getName(true), this.getSymbols(geneSetPair.getUp(), nullSymbolMode)), new FSet(geneSetPair.getDown().getName(true), this.getSymbols(geneSetPair.getDown(), nullSymbolMode)));
    }

    @Override
    public GeneSetMatrixPair getSymbols(GeneSetMatrixPair geneSetMatrixPair, NullSymbolMode nullSymbolMode) {
        GeneSetPair[] geneSetPairArray = new GeneSetPair[geneSetMatrixPair.getSize()];
        for (int i2 = 0; i2 < geneSetMatrixPair.getSize(); ++i2) {
            geneSetPairArray[i2] = this.getSymbols(geneSetMatrixPair.get(i2), nullSymbolMode);
        }
        return new GeneSetMatrixPairImpl(geneSetMatrixPair.getName() + "_symbols", geneSetPairArray);
    }

    @Override
    public Set getSymbols(List list, NullSymbolMode nullSymbolMode) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = list.get(i2).toString();
            Gene gene = null;
            if (this.isProbe(string)) {
                gene = this.getHugo(string);
            }
            nullSymbolMode.processSymbol(string, gene, hashSet);
        }
        return hashSet;
    }

    @Override
    public List getSymbols_synched(List list, NullSymbolMode nullSymbolMode) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = list.get(i2).toString();
            Gene gene = null;
            if (this.isProbe(string)) {
                gene = this.getHugo(string);
            }
            nullSymbolMode.processSymbol(string, gene, arrayList);
        }
        return arrayList;
    }

    @Override
    public String getSymbol(String string, NullSymbolMode nullSymbolMode) {
        try {
            if (this.isProbe(string)) {
                return nullSymbolMode.getSymbol(string, this.getHugo(string));
            }
            return nullSymbolMode.getSymbol(string, null);
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
            return "";
        }
    }

    @Override
    public String getTitle(String string, NullSymbolMode nullSymbolMode) {
        try {
            if (this.isProbe(string)) {
                return nullSymbolMode.getTitle(string, this.getHugo(string));
            }
            return nullSymbolMode.getTitle(string, null);
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
            return "";
        }
    }

    @Override
    public StringDataframe annotate(IDataframe iDataframe) {
        int n;
        StringMatrix stringMatrix = new StringMatrix(iDataframe.getNumRow(), iDataframe.getNumCol() + 2);
        String[] stringArray = new String[iDataframe.getNumCol() + 2];
        stringArray[0] = "GENE_SYMBOL";
        stringArray[1] = "GENE_TITLE";
        for (n = 0; n < iDataframe.getNumCol(); ++n) {
            stringArray[n + 2] = iDataframe.getColumnName(n);
        }
        for (n = 0; n < iDataframe.getNumRow(); ++n) {
            String string = iDataframe.getRowName(n);
            stringMatrix.setElement(n, 0, this.getSymbol(string, OMIT_NULLS));
            stringMatrix.setElement(n, 1, this.getTitle(string, OMIT_NULLS));
        }
        for (n = 0; n < iDataframe.getNumCol(); ++n) {
            stringMatrix.setColumn(n + 2, iDataframe.getColumnAsStrings(n));
        }
        return new StringDataframe(iDataframe.getName(), stringMatrix, iDataframe.getRowNames(), stringArray, true, true);
    }

    @Override
    public StringDataframe annotate(RankedList rankedList) {
        StringMatrix stringMatrix = new StringMatrix(rankedList.getSize(), 3);
        String[] stringArray = new String[]{"SCORE", "GENE_SYMBOL", "GENE_TITLE"};
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            String string = rankedList.getRankName(i2);
            stringMatrix.setElement(i2, 0, rankedList.getScore(i2));
            stringMatrix.setElement(i2, 1, this.getSymbol(string, OMIT_NULLS));
            stringMatrix.setElement(i2, 2, this.getTitle(string, OMIT_NULLS));
        }
        return new StringDataframe(rankedList.getName(), stringMatrix, rankedList.getRankedNames(), stringArray, true, true);
    }

    @Override
    public RankedList symbolize(RankedList rankedList) {
        String[] stringArray = new String[rankedList.getSize()];
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            stringArray[i2] = this.getSymbol(rankedList.getRankName(i2), REPLACE_WITH_PROBEID);
        }
        return new DefaultRankedList(rankedList.getName(), stringArray, rankedList.getScoresV(true), true);
    }

    @Override
    public GeneSetMatrix symbolize(GeneSetMatrix geneSetMatrix) {
        GeneSet[] geneSetArray = new GeneSet[geneSetMatrix.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            geneSetArray[i2] = this.symbolize(geneSetMatrix.getGeneSet(i2));
        }
        return new DefaultGeneSetMatrix(geneSetMatrix.getName() + "_symbolized", geneSetArray);
    }

    @Override
    public GeneSet symbolize(GeneSet geneSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = this.getSymbol(geneSet.getMember(i2), OMIT_NULLS);
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return new FSet(geneSet.getName(), arrayList, false);
    }

    @Override
    public StringDataframe symbolize(String string, TObjectIntHashMap tObjectIntHashMap) {
        String[] stringArray = new String[]{"SYMBOL", "TITLE", "CNT"};
        StringMatrix stringMatrix = new StringMatrix(tObjectIntHashMap.size(), stringArray.length);
        String[] stringArray2 = new String[tObjectIntHashMap.size()];
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        int n = tObjectIntHashMap.size();
        while (n-- > 0) {
            tObjectIntIterator.advance();
            stringArray2[n] = tObjectIntIterator.key().toString();
            stringMatrix.setElement(n, 0, this.getSymbol(stringArray2[n], REPLACE_WITH_PROBEID));
            stringMatrix.setElement(n, 1, this.getTitle(stringArray2[n], REPLACE_WITH_PROBEID));
            stringMatrix.setElement(n, 2, tObjectIntHashMap.get(stringArray2[n]));
        }
        return new StringDataframe(string, stringMatrix, stringArray2, stringArray, true);
    }

    @Override
    public Probe[] getProbes(GeneSet geneSet) {
        Probe[] probeArray = new Probe[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            probeArray[i2] = this.getProbe(geneSet.getMember(i2));
        }
        return probeArray;
    }

    @Override
    public Probe[] getProbes(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter ds cannot be null");
        }
        HashSet<Probe> hashSet = new HashSet<Probe>();
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            String string = dataset.getRowName(i2);
            if (!this.isProbe(string)) continue;
            hashSet.add(this.getProbe(string));
        }
        return hashSet.toArray(new Probe[hashSet.size()]);
    }

    @Override
    public GeneSet getProbeNamesAsGeneSet(Dataset dataset) {
        Set set = AbstractChip._toNamesS(this.getProbes(dataset));
        return new FSet(dataset.getName() + "_" + this.getName(), set);
    }

    private static String[] _toNames(Probe[] probeArray) {
        String[] stringArray = new String[probeArray.length];
        for (int i2 = 0; i2 < probeArray.length; ++i2) {
            stringArray[i2] = probeArray[i2].getName();
        }
        return stringArray;
    }

    private static Set _toNamesS(Probe[] probeArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < probeArray.length; ++i2) {
            hashSet.add(probeArray[i2].getName());
        }
        return hashSet;
    }
}

