/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.vdb.map.MGeneSet;
import edu.mit.broad.vdb.map.MGeneSetImpl;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import edu.mit.broad.vdb.map.Mapper;
import edu.mit.broad.vdb.map.MappingDbType;
import edu.mit.broad.vdb.map.MappingEtiology;

class MGeneSetMatrixImpl
implements MGeneSetMatrix {
    private MGeneSet[] mappedGeneSets;
    private String fOrigGmName;

    MGeneSetMatrixImpl(GeneSetMatrix geneSetMatrix, boolean bl, String string, String string2, MappingDbType mappingDbType, Mapper mapper) {
        if (geneSetMatrix == null) {
            throw new IllegalArgumentException("Param sourceGeneSetMatrix cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Param sourceChipName cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Param targetChipName cannot be null");
        }
        this.mappedGeneSets = new MGeneSet[geneSetMatrix.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            this.mappedGeneSets[i2] = new MGeneSetImpl(geneSetMatrix.getGeneSet(i2), bl, string, string2, mappingDbType, mapper);
        }
        this.fOrigGmName = geneSetMatrix.getName();
    }

    @Override
    public final MGeneSet[] getMappedGeneSets() {
        return this.mappedGeneSets;
    }

    @Override
    public final MGeneSet getMappedGeneSet(int n) {
        return this.mappedGeneSets[n];
    }

    @Override
    public final GeneSetMatrix getMappedGeneSetMatrix(String string) {
        GeneSet[] geneSetArray = new GeneSet[this.mappedGeneSets.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray[i2] = this.mappedGeneSets[i2].getMappedGeneSet(true);
        }
        String string2 = string == null || string.length() == 0 ? this.fOrigGmName : string + "_" + this.fOrigGmName;
        return new DefaultGeneSetMatrix(string2, geneSetArray);
    }

    @Override
    public final int getNumMappedSets() {
        return this.mappedGeneSets.length;
    }

    @Override
    public final MappingEtiology[] getEtiologies() {
        MappingEtiology[] mappingEtiologyArray = new MappingEtiology[this.getNumMappedSets()];
        for (int i2 = 0; i2 < mappingEtiologyArray.length; ++i2) {
            mappingEtiologyArray[i2] = this.getMappedGeneSet(i2).getEtiology();
        }
        return mappingEtiologyArray;
    }
}

