/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.MapUtils;
import edu.mit.broad.vdb.map.MappingDbType;
import edu.mit.broad.vdb.map.MappingDbTypes;
import java.io.File;

public class MapUtils$Struc {
    public String sourceChipName;
    public String targetChipName;
    public String mappingDbType;

    public MapUtils$Struc(File file) {
        String[] stringArray = ParseUtils.string2strings(file.getName(), ".", false);
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("Not a map file: " + file + " # tokens: " + stringArray.length);
        }
        this.sourceChipName = stringArray[0];
        this.targetChipName = stringArray[1];
        this.mappingDbType = stringArray[2];
    }

    public final MappingDbType getMappingDbType() {
        return MappingDbTypes.lookupMappingType(this.mappingDbType);
    }

    public final boolean equals(Chip chip, Chip chip2, MappingDbType mappingDbType) {
        return chip.getName().equals(this.sourceChipName) && chip2.getName().equals(this.targetChipName) && mappingDbType.getName().equals(this.mappingDbType);
    }

    public final boolean equals(Chip chip, Chip chip2) {
        return chip.getName().equals(this.sourceChipName) && chip2.getName().equals(this.targetChipName);
    }

    public final String createChipId() {
        return MapUtils.createId(this.sourceChipName, this.targetChipName);
    }

    public final String createId() {
        return MapUtils.createId(this.sourceChipName, this.targetChipName, this.mappingDbType);
    }
}

