/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.vdb.Organism;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.DefaultGene;
import edu.mit.broad.vdb.meg.EntrezGene;
import edu.mit.broad.vdb.meg.Gene;
import java.util.HashSet;
import java.util.Set;

public class EntrezGeneImpl
extends DefaultGene
implements EntrezGene,
Probe {
    private long fGeneID;
    private long fTaxonID;
    private String fStatus;

    @Override
    public final Probe cloneDeepProbe() {
        throw new NotImplementedException();
    }

    @Override
    public final String getName() {
        return this.getSymbol();
    }

    @Override
    public final Gene getGene() {
        return this;
    }

    @Override
    public final EntrezGene cloneDeep(Set set) {
        return new EntrezGeneImpl(this.getEntrezID(), this.getTaxonId(), this.getSymbol(), this.getTitle(), set, this.getCyto(), this.getSeqAccessions(), this.getStatus());
    }

    @Override
    public final EntrezGene cloneShallow(String string) {
        this.fCyto_opt = string;
        return this;
    }

    @Override
    public final EntrezGene cloneShallow(Set set) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        if (this.fSeqAccessions != null) {
            hashSet.addAll(this.fSeqAccessions);
        }
        this.fSeqAccessions = hashSet;
        return this;
    }

    public EntrezGeneImpl(long l2, long l3, String string, String string2, Set set, String string3, Set set2, String string4) {
        super(string, string2, set, string3, set2);
        this.fGeneID = l2;
        this.fTaxonID = l3;
        if (string4 == null) {
            throw new IllegalArgumentException("Param status cannot be null");
        }
        if (!(string4.equalsIgnoreCase("O") || string4.equalsIgnoreCase("I") || string4.equalsIgnoreCase("-"))) {
            throw new IllegalArgumentException("Unknown status>" + string4 + "<");
        }
        this.fStatus = string4;
    }

    @Override
    public final boolean isOrg(Organism organism) {
        return this.getTaxonId() == (long)organism.getTaxonID();
    }

    @Override
    public final boolean isHuman() {
        return this.getTaxonId() == (long)Organism.HUMAN.getTaxonID();
    }

    @Override
    public final boolean isMouse() {
        return this.getTaxonId() == (long)Organism.MOUSE.getTaxonID();
    }

    @Override
    public final boolean isRat() {
        return this.getTaxonId() == (long)Organism.RAT.getTaxonID();
    }

    @Override
    public final long getEntrezID() {
        return this.fGeneID;
    }

    @Override
    public final long getTaxonId() {
        return this.fTaxonID;
    }

    @Override
    public final boolean isOfficial() {
        return !this.fStatus.equalsIgnoreCase("O");
    }

    @Override
    public final String getStatus() {
        return this.fStatus;
    }
}

