/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.msigdb;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.vdb.Organism;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.vdb.msigdb.GeneSetCategory;
import edu.mit.broad.vdb.msigdb.GeneSetCategoryImpl;
import edu.mit.broad.vdb.msigdb.GeneSetContributor;
import edu.mit.broad.vdb.msigdb.GeneSetContributorImpl;
import edu.mit.broad.vdb.msigdb.GeneSetDescription;
import edu.mit.broad.vdb.msigdb.GeneSetDescriptionImpl;
import edu.mit.broad.vdb.msigdb.GeneSetExternalLinks;
import edu.mit.broad.vdb.msigdb.GeneSetExternalLinksImpl;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeneSetAnnotationImpl
implements GeneSetAnnotation {
    private Logger log = XLogger.getLogger(GeneSetAnnotationImpl.class);
    private GeneSet fGeneSet_orig;
    private GeneSet fGeneSet_symbolized;
    private Chip fChipxx;
    private String fChip_name;
    private GeneSetContributor fContributor;
    private String fStandardName;
    private String fSystematicName;
    private GeneSetExternalLinks fExtLinks;
    private Organism fOrganism;
    private GeneSetCategory fCategory;
    private GeneSetDescription fDesc;
    private Set fTags;

    public GeneSetAnnotationImpl(GeneSet geneSet, GeneSet geneSet2, Chip chip, GeneSetContributor geneSetContributor, String string, String string2, String string3, String string4, String string5, String string6, Organism organism, GeneSetCategory geneSetCategory, GeneSetDescription geneSetDescription, Set set) {
        this.init(geneSet, geneSet2, chip, chip.getName(), geneSetContributor, string, string2, string3, string4, string5, string6, organism, geneSetCategory, geneSetDescription, set);
    }

    private void init(GeneSet geneSet, GeneSet geneSet2, Chip chip, String string, GeneSetContributor geneSetContributor, String string2, String string3, String string4, String string5, String string6, String string7, Organism organism, GeneSetCategory geneSetCategory, GeneSetDescription geneSetDescription, Set set) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Param gset_orig cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Param chip_orig_reqd cannot be null");
        }
        this.fGeneSet_orig = geneSet;
        this.fGeneSet_symbolized = geneSet2;
        this.fChip_name = string;
        this.fChipxx = chip;
        this.fContributor = geneSetContributor;
        this.fExtLinks = new GeneSetExternalLinksImpl(string2, string3, string4, string5);
        this.fStandardName = string6;
        this.fSystematicName = string7;
        this.fOrganism = organism;
        this.fCategory = geneSetCategory;
        this.fDesc = geneSetDescription;
        this.fTags = set != null ? Collections.unmodifiableSet(set) : Collections.EMPTY_SET;
    }

    public GeneSetAnnotationImpl(GeneSet geneSet, GeneSet geneSet2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, Set set) {
        this.init(geneSet, geneSet2, null, string, GeneSetContributorImpl.create(string2), string3, string4, string5, string6, string7, string8, Organism.parseOrganism(string9), GeneSetCategoryImpl.lookup(string10), new GeneSetDescriptionImpl(string11, string12), set);
    }

    @Override
    public final GeneSet getGeneSet(boolean bl, boolean bl2) {
        if (bl) {
            return this.fGeneSet_orig;
        }
        if (this.fGeneSet_symbolized != null) {
            return this.fGeneSet_symbolized;
        }
        if (GeneSetAnnotationImpl.isGeneSymbol(this.fGeneSet_orig)) {
            return this.fGeneSet_orig;
        }
        if (this.fGeneSet_symbolized == null) {
            if (bl2 && VdbRuntimeResources.isChipSeqAccession(this.getChipOriginal_name())) {
                try {
                    this.fGeneSet_symbolized = VdbRuntimeResources.getChip_EntrezWeb().symbolize(this.fGeneSet_orig, bl2, true);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            } else {
                this.fGeneSet_symbolized = this._getChipOriginal().symbolize(this.fGeneSet_orig);
            }
            if (this.fGeneSet_symbolized.getNumMembers() == 0) {
                throw new IllegalStateException("Bad conversion for: " + this.fGeneSet_orig.getName() + " " + this.getChipOriginal_name());
            }
            if (this.fGeneSet_symbolized.getNumMembers() < this.fGeneSet_orig.getNumMembers() / 2) {
                this.log.warn("POOR conversion for: " + this.fGeneSet_orig.getName() + " orig: " + this.fGeneSet_orig.getNumMembers() + " symbols: " + this.fGeneSet_symbolized.getNumMembers() + " chip: " + this.getChipOriginal_name());
            }
        }
        return this.fGeneSet_symbolized;
    }

    @Override
    public final GeneSet getGeneSet(boolean bl) {
        return this.getGeneSet(bl, false);
    }

    private static boolean isGeneSymbol(GeneSet geneSet) {
        boolean bl = false;
        try {
            for (int i2 = 0; i2 < geneSet.getNumMembers() && i2 <= 2 && !bl; ++i2) {
                if (!VdbRuntimeResources.getChip_Gene_Symbol().isProbe(geneSet.getMember(i2))) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return bl;
    }

    @Override
    public final GeneSetContributor getContributor() {
        return this.fContributor;
    }

    @Override
    public final GeneSetExternalLinks getExternalLinks() {
        return this.fExtLinks;
    }

    @Override
    public final String getStandardName() {
        return this.fStandardName;
    }

    @Override
    public final String getLSIDName() {
        return this.fSystematicName;
    }

    private Chip _getChipOriginal() {
        if (this.fChipxx == null) {
            this.fChipxx = VdbRuntimeResources.getChip(this.getChipOriginal_name());
        }
        return this.fChipxx;
    }

    @Override
    public final String getChipOriginal_name() {
        return this.fChip_name;
    }

    @Override
    public final Organism getOrganism() {
        return this.fOrganism;
    }

    @Override
    public final GeneSetCategory getCategory() {
        return this.fCategory;
    }

    @Override
    public final GeneSetDescription getDescription() {
        return this.fDesc;
    }

    @Override
    public final Set getTags() {
        return this.fTags;
    }

    @Override
    public final String[] getTagsArray() {
        return this.getTags().toArray(new String[this.getTags().size()]);
    }
}

