/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.msigdb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap$Columns;
import edu.mit.broad.genome.objects.ColumnsImpl;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.vdb.msigdb.FeatureAnnotMSigDbImpl;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.vdb.msigdb.MSigDB;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MSigDBImpl
extends AbstractObject
implements MSigDB {
    private GeneSetAnnotation[] fGeneSetAnns;
    private String fVersion;
    private String fBuildDate;
    private Map fGeneSetNameGeneSetAnnotationMap;
    private FeatureAnnot fFeatureAnnot;
    private SampleAnnot fSampleAnnot;

    public MSigDBImpl(String string, String string2, String string3, GeneSetAnnotation[] geneSetAnnotationArray) {
        this.initHere(string, string2, string3, geneSetAnnotationArray);
    }

    public MSigDBImpl(String string, String string2, String string3, MSigDB[] mSigDBArray) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < mSigDBArray.length; ++i2) {
            arrayList.addAll(mSigDBArray[i2].getGeneSetAnnotations_set());
        }
        this.initHere(string, string2, string3, arrayList.toArray(new GeneSetAnnotation[arrayList.size()]));
    }

    private void initHere(String string, String string2, String string3, GeneSetAnnotation[] geneSetAnnotationArray) {
        super.initialize(string);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        this.fGeneSetNameGeneSetAnnotationMap = new THashMap();
        for (int i2 = 0; i2 < geneSetAnnotationArray.length; ++i2) {
            if (hashSet2.contains(geneSetAnnotationArray[i2].getStandardName())) {
                hashSet.add(geneSetAnnotationArray[i2].getStandardName());
                continue;
            }
            hashSet2.add(geneSetAnnotationArray[i2].getStandardName());
            this.fGeneSetNameGeneSetAnnotationMap.put(geneSetAnnotationArray[i2].getStandardName(), geneSetAnnotationArray[i2]);
        }
        if (!hashSet.isEmpty()) {
            throw new IllegalArgumentException("Duplicate gene set annotations: " + hashSet.size() + "\n" + hashSet);
        }
        this.fGeneSetAnns = geneSetAnnotationArray;
        this.fVersion = string2;
        this.fBuildDate = string3;
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    @Override
    public final String[] getStandardNames() {
        String[] stringArray = new String[this.getNumGeneSets()];
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            stringArray[i2] = this.getGeneSetAnnotation(i2).getStandardName();
        }
        return stringArray;
    }

    @Override
    public final FeatureAnnot getAsFeatureAnnot() {
        if (this.fFeatureAnnot == null) {
            this.fFeatureAnnot = new FeatureAnnotMSigDbImpl(this);
        }
        return this.fFeatureAnnot;
    }

    @Override
    public final SampleAnnot getAsSampleAnnot() {
        if (this.fSampleAnnot == null) {
            String[] stringArray = this.getStandardNames();
            this.fSampleAnnot = new SampleAnnotImpl(this.getName(), stringArray, (ColorMap$Columns)new ColumnsImpl(stringArray));
        }
        return this.fSampleAnnot;
    }

    @Override
    public final String getVersion() {
        return this.fVersion;
    }

    @Override
    public final String getBuildDate() {
        return this.fBuildDate;
    }

    @Override
    public final GeneSetMatrix createGeneSetMatrix(String[] stringArray, boolean bl) {
        GeneSet[] geneSetArray = new GeneSet[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            geneSetArray[i2] = this.getGeneSetAnnotation(stringArray[i2]).getGeneSet(bl);
        }
        String string = "gsets_" + stringArray.length + "_" + this._toName(bl);
        return new DefaultGeneSetMatrix(string, geneSetArray);
    }

    @Override
    public final GeneSetMatrix createGeneSetMatrix(boolean bl) {
        GeneSet[] geneSetArray = new GeneSet[this.getNumGeneSets()];
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            geneSetArray[i2] = this.getGeneSetAnnotation(i2).getGeneSet(bl);
        }
        return new DefaultGeneSetMatrix(this._toName(bl), geneSetArray);
    }

    private String _toName(boolean bl) {
        String string = this.getName();
        string = bl ? string + "." + this.getVersion() + ".native_ids" : string + "." + this.getVersion() + ".symbols";
        return string;
    }

    @Override
    public final GeneSetAnnotation[] getGeneSetAnnotations() {
        return this.fGeneSetAnns;
    }

    @Override
    public final Set getGeneSetAnnotations_set() {
        HashSet<GeneSetAnnotation> hashSet = new HashSet<GeneSetAnnotation>();
        for (int i2 = 0; i2 < this.fGeneSetAnns.length; ++i2) {
            hashSet.add(this.fGeneSetAnns[i2]);
        }
        return hashSet;
    }

    @Override
    public final MSigDB[] split(boolean bl, boolean bl2) {
        ArrayList<MSigDB> arrayList = new ArrayList<MSigDB>();
        if (bl || bl2) {
            int n;
            MSigDB[] mSigDBArray = this.splitByCategory();
            if (bl) {
                for (n = 0; n < mSigDBArray.length; ++n) {
                    arrayList.add(mSigDBArray[n]);
                }
            }
            if (bl2) {
                for (n = 0; n < mSigDBArray.length; ++n) {
                    MSigDB[] mSigDBArray2 = mSigDBArray[n].splitByTags();
                    for (int i2 = 0; i2 < mSigDBArray2.length; ++i2) {
                        arrayList.add(mSigDBArray2[i2]);
                    }
                }
            }
        }
        return arrayList.toArray(new MSigDB[arrayList.size()]);
    }

    @Override
    public final MSigDB[] splitByTags() {
        Object object;
        int n;
        Object[] objectArray;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i2 = 0; i2 < this.fGeneSetAnns.length; ++i2) {
            objectArray = this.fGeneSetAnns[i2].getTagsArray();
            for (n = 0; n < objectArray.length; ++n) {
                object = hashMap.get(objectArray[n]);
                if (object == null) {
                    object = new ArrayList();
                }
                ((List)object).add(this.fGeneSetAnns[i2]);
                hashMap.put(objectArray[n], object);
            }
        }
        String string = "";
        if (this.fGeneSetAnns.length > 0) {
            string = this.fGeneSetAnns[0].getCategory().getCode();
        }
        objectArray = new MSigDB[hashMap.size()];
        n = 0;
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string2 = object.next().toString();
            List list = (List)hashMap.get(string2);
            objectArray[n++] = new MSigDBImpl(string + "." + string2, this.fVersion, this.fBuildDate, list.toArray(new GeneSetAnnotation[list.size()]));
        }
        return objectArray;
    }

    @Override
    public final MSigDB[] splitByCategory() {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.fGeneSetAnns.length; ++i2) {
            Object object = hashMap.get(this.fGeneSetAnns[i2].getCategory().getCode());
            if (object == null) {
                object = new ArrayList();
            }
            ((List)object).add(this.fGeneSetAnns[i2]);
            hashMap.put(this.fGeneSetAnns[i2].getCategory().getCode(), object);
        }
        MSigDB[] mSigDBArray = new MSigDB[hashMap.size()];
        int n = 0;
        for (Object k2 : hashMap.keySet()) {
            List list = (List)hashMap.get(k2);
            mSigDBArray[n++] = new MSigDBImpl(k2.toString(), this.fVersion, this.fBuildDate, list.toArray(new GeneSetAnnotation[list.size()]));
        }
        return mSigDBArray;
    }

    @Override
    public final GeneSetAnnotation getGeneSetAnnotation(int n) {
        return this.fGeneSetAnns[n];
    }

    @Override
    public final GeneSetAnnotation getGeneSetAnnotation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param gsStdName cannot be null");
        }
        Object v = this.fGeneSetNameGeneSetAnnotationMap.get(string);
        if (v == null && (v = this.fGeneSetNameGeneSetAnnotationMap.get(string.toUpperCase())) == null) {
            throw new IllegalArgumentException("No gset ann with std name: " + string);
        }
        return (GeneSetAnnotation)v;
    }

    @Override
    public final int getNumGeneSets() {
        return this.fGeneSetAnns.length;
    }

    @Override
    public final int getNumGenes() {
        throw new NotImplementedException();
    }

    @Override
    public final GeneSet getAllGenes(boolean bl) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < this.getNumGeneSets(); ++i2) {
            GeneSetAnnotation geneSetAnnotation = this.getGeneSetAnnotation(i2);
            GeneSet geneSet = geneSetAnnotation.getGeneSet(bl);
            hashSet.addAll(geneSet.getMembersS());
        }
        return new FSet(this.getName(), hashSet);
    }
}

