/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.TemplateFromAnnot;
import edu.mit.broad.genome.objects.strucs.Linked;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelSdfColorStruc;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.genome.utils.ParseException;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import edu.mit.broad.vdb.sampledb.AbstractSample;
import edu.mit.broad.vdb.sampledb.AbstractSampleAnnot$CategoryComparator;
import edu.mit.broad.vdb.sampledb.Category;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.State;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractSampleAnnot
extends AbstractObject
implements SampleAnnot {
    protected Logger log = XLogger.getLogger(AbstractSampleAnnot.class);
    protected static final Logger klog = XLogger.getLogger(AbstractSampleAnnot.class);
    protected Sample[] fSamples;
    private Map fCelFileNameSampleMap;
    private Map fSampleNameSampleMap;
    private TObjectIntHashMap sampleNameIndexMap;

    protected AbstractSampleAnnot() {
    }

    @Override
    public SampleAnnot createRandomAnnot() {
        return this.createRandomAnnot(this.getSampleNames());
    }

    @Override
    public SampleAnnot createRandomAnnot(String[] stringArray) {
        throw new NotImplementedException();
    }

    protected static final StringDataframe checkSdf_makeUC_and_remove_bad_qc_samples(MiscParsers$ExcelSdfColorStruc miscParsers$ExcelSdfColorStruc) {
        int n;
        StringDataframe stringDataframe = miscParsers$ExcelSdfColorStruc.sdf;
        stringDataframe = stringDataframe.cloneDeep_uppercase();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("SAMPLE_NAME");
        hashSet.add("SERIES_ID");
        hashSet.add("TYPE");
        hashSet.add("POPULATION_NAME");
        hashSet.add("LINEAGE");
        hashSet.add("SEMISUPER");
        hashSet.add("BASIC");
        hashSet.add("POPULATION_NUMBER");
        hashSet.add("SOURCE_OF_DATA");
        hashSet.add("PLATFORM");
        hashSet.add("ORGANISM");
        hashSet.add("RNA_AMPLIFICATION");
        hashSet.add("DIAGNOSIS");
        hashSet.add("MOLECULAR_ABNORMALITY");
        hashSet.add("SOURCE_OF_CELLS");
        hashSet.add("DIFFERENTIATION_STATE");
        hashSet.add("REPLICATE_NUMBER");
        hashSet.add("SAMPLE_CODE");
        hashSet.add("SORT_DATE");
        hashSet.add("SORT_LOCATION");
        hashSet.add("RNA_PREPARATION_DATE");
        hashSet.add("CONCENTRATION_OF_STARTING_RNA(NG/UL)");
        hashSet.add("TYPE");
        hashSet.add("%_P_CALLS_ON_ARRAY");
        hashSet.add("GOOD_QUALITY");
        hashSet.add("CELL_COUNT_FROM_SORT");
        for (int i2 = 0; i2 < stringDataframe.getNumRow(); ++i2) {
            for (n = 0; n < stringDataframe.getNumCol(); ++n) {
                String string = stringDataframe.getElement(i2, n);
                if (!hashSet.contains(stringDataframe.getColumnName(n).toUpperCase()) || !NamingConventions.isBadCharacter(string, false, true, true)) continue;
                arrayList.add(string);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new ParseException("Bad values in the SampleAnnot Db: " + arrayList.size() + "\n" + arrayList);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < stringDataframe.getNumRow(); ++n) {
            boolean bl = AbstractSample.lookupQuality(stringDataframe.getElement(n, "GOOD_QUALITY"));
            if (bl && stringDataframe.hasColumn("LINEAGE") && stringDataframe.getElement(n, "LINEAGE").equalsIgnoreCase("NA")) {
                bl = false;
            }
            if (!bl) continue;
            arrayList2.add(stringDataframe.getRowName(n));
        }
        klog.info("# of samples excluded by QC: " + (stringDataframe.getNumRow() - arrayList2.size()));
        miscParsers$ExcelSdfColorStruc.sdf = stringDataframe.cloneDeep_by_row_names(arrayList2.toArray(new String[arrayList2.size()]), true);
        return miscParsers$ExcelSdfColorStruc.sdf;
    }

    protected static final void checkForDuplicates_SampleNames_and_SampleCelFiles(Sample[] sampleArray) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            String string = sampleArray[i2].getCelFileName();
            if (string == null) {
                throw new IllegalStateException("sample cell file cfn is null: " + string);
            }
            if (hashSet3.contains(string)) {
                hashSet.add(string);
            }
            if ((string = sampleArray[i2].getName()) == null) {
                throw new IllegalStateException("sample name cfn is null: " + string);
            }
            if (hashSet3.contains(string)) {
                hashSet2.add(string);
            }
            hashSet3.add(sampleArray[i2].getCelFileName());
            hashSet3.add(sampleArray[i2].getName());
        }
        if (hashSet.size() != 0) {
            throw new ParseException("Duplicate sample CEL file name: " + hashSet);
        }
        if (hashSet2.size() != 0) {
            throw new ParseException("Duplicate sample code name: " + hashSet2);
        }
    }

    @Override
    public SampleAnnot cloneDeep(String[] stringArray) {
        return this.cloneDeep(this.getName() + "_" + stringArray.length, stringArray);
    }

    @Override
    public SampleAnnot cloneDeep(Chip chip) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            Sample sample = this.getSample(i2);
            if (!sample.getChip().equals(chip)) continue;
            arrayList.add(sample.getName());
        }
        return this.cloneDeep(this.getName() + "_" + chip.getName(), arrayList.toArray(new String[arrayList.size()]));
    }

    @Override
    public Map getCelFileSampleNameMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            String string = this.getSample(i2).getCelFileName();
            String string2 = this.getSample(i2).getName();
            hashMap.put(string.toUpperCase(), string2);
            if (string.toUpperCase().endsWith(".CEL")) continue;
            hashMap.put(string.toUpperCase() + ".CEL", string2);
        }
        this.log.debug(">>>> " + hashMap);
        return hashMap;
    }

    @Override
    public int getNumSamples() {
        return this.fSamples.length;
    }

    @Override
    public Sample[] getSamples() {
        return this.fSamples;
    }

    @Override
    public Sample[] getSamples(String string, String string2) {
        Category category = this.createCategory(string, new String[]{string2});
        return category.getSamples();
    }

    @Override
    public String[] getSampleNames(String string, String string2) {
        Category category = this.createCategory(string, new String[]{string2});
        return category.getSampleNames();
    }

    @Override
    public String[] getSampleNames(String string, String[] stringArray) {
        Category category = this.createCategory(string, stringArray);
        return category.getSampleNames();
    }

    @Override
    public String[] getSampleNames() {
        String[] stringArray = new String[this.getNumSamples()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.getSample(i2).getName();
        }
        return stringArray;
    }

    @Override
    public List getSampleNames_list() {
        String[] stringArray = this.getSampleNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    @Override
    public String[] getSampleNames(String[] stringArray) {
        List list = this.getSampleNames_list(stringArray);
        return list.toArray(new String[list.size()]);
    }

    public final List getSampleNames_list(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            arrayList.add(this.getSampleName(stringArray[i2]));
        }
        return arrayList;
    }

    @Override
    public Sample getSample(int n) {
        return this.fSamples[n];
    }

    private Sample _getSample(String string) {
        Sample sample = this._get(string = AbstractSampleAnnot.make_name_proper(string));
        if (sample != null) {
            return sample;
        }
        if (string.startsWith("X")) {
            string = string.substring(1, string.length());
        }
        return this._get(string);
    }

    private Sample _get(String string) {
        Object v;
        if (this.fCelFileNameSampleMap == null) {
            this.fCelFileNameSampleMap = new HashMap();
            this.fSampleNameSampleMap = new HashMap();
            for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
                Sample sample = this.getSample(i2);
                this.fCelFileNameSampleMap.put(sample.getCelFileName(), sample);
                this.fSampleNameSampleMap.put(sample.getName(), sample);
            }
        }
        if ((v = this.fCelFileNameSampleMap.get(string)) != null) {
            return (Sample)v;
        }
        v = this.fSampleNameSampleMap.get(string);
        if (v != null) {
            return (Sample)v;
        }
        return null;
    }

    @Override
    public boolean isSample(String string) {
        return this._getSample(string) != null;
    }

    @Override
    public int getSampleIndex(Sample sample) {
        return this.getSampleIndex(sample.getName());
    }

    @Override
    public int getSampleIndex(String string) {
        if (this.sampleNameIndexMap == null) {
            this.sampleNameIndexMap = new TObjectIntHashMap();
            for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
                this.sampleNameIndexMap.put(this.getSample(i2).getName(), i2);
            }
        }
        return this.sampleNameIndexMap.get(string);
    }

    @Override
    public Chip getChip() {
        return this.getChip(this.getSampleNames());
    }

    @Override
    public Chip getChip(Dataset dataset) {
        return this.getChip(dataset.getColumnNamesArray());
    }

    @Override
    public Chip getChip(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param celFileOrSampleName cannot be null");
        }
        Sample sample = this.getSample(string);
        return sample.getChip();
    }

    @Override
    public Chip getChip(TemplateFromAnnot templateFromAnnot) {
        return this.getChip(templateFromAnnot.getSampleNames_ordered());
    }

    @Override
    public Chip getChip(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Param celFileOrSampleName cannot be null");
        }
        Chip chip = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Sample sample = this.getSample(stringArray[i2]);
            Chip chip2 = sample.getChip();
            if (chip == null) {
                chip = chip2;
                continue;
            }
            if (chip2 == null) {
                throw new IllegalArgumentException("Chip was not null: " + chip.getName() + " but got null: " + chip2 + " for celFileOrSampleName: " + stringArray[i2]);
            }
            if (chip.getName().equalsIgnoreCase(chip2.getName())) continue;
            throw new IllegalArgumentException("Chip was: " + chip.getName() + " but got was: " + chip2 + " for celFileOrSampleName: " + stringArray[i2]);
        }
        return chip;
    }

    @Override
    public Dataset orderByDefaultCategory(Dataset dataset) {
        String[] stringArray = this.orderByDefaultCategory(dataset.getColumnNamesArray());
        return new DatasetGenerators().orderDatasetColumns(dataset.getName(), stringArray, dataset, true);
    }

    @Override
    public Dataset orderByCategory(Dataset dataset, String string) {
        String[] stringArray = this.orderByCategory(dataset.getColumnNamesArray(), string);
        return new DatasetGenerators().orderDatasetColumns(dataset.getName(), stringArray, dataset, true);
    }

    @Override
    public String[] getSampleNames_OrderByCategory(String string) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            arrayList.add(this.getSample(i2));
        }
        Collections.sort(arrayList, new AbstractSampleAnnot$CategoryComparator(this, string));
        return AbstractSampleAnnot._toSampleNames(arrayList);
    }

    @Override
    public String[] orderByDefaultCategory(String[] stringArray) {
        List list = this.getSampleNames_list(stringArray);
        Collections.sort(list, this.createDefaultSampleComparator());
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String[] orderByCategory(String[] stringArray, String string) {
        List list = this.getSampleNames_list(stringArray);
        Collections.sort(list, new AbstractSampleAnnot$CategoryComparator(this, string));
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void orderByCategory(List list, String string) {
        Collections.sort(list, new AbstractSampleAnnot$CategoryComparator(this, string));
    }

    @Override
    public String[] orderStateNames(String[] stringArray, String string) {
        List<String> list = Arrays.asList(stringArray);
        Collections.sort(list, this.createDefaultStateComparator(string));
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Dataset orderStateNames(Dataset dataset, String string) {
        String[] stringArray = this.orderStateNames(dataset.getColumnNamesArray(), string);
        return new DatasetGenerators().orderDatasetColumns(dataset.getName(), stringArray, dataset, true);
    }

    @Override
    public String[] getSampleNames_OrderByDefaultCategory() {
        List list = this.getSampleNames_list();
        Collections.sort(list, this.createDefaultSampleComparator());
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Linked getLink(String string) {
        return LinkedFactory.createLinkedGeneSymbol(string);
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public String[] getCelFileNames() {
        String[] stringArray = new String[this.getNumSamples()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.getSample(i2).getCelFileName();
        }
        return stringArray;
    }

    public final GeneSet map(GeneSet geneSet, Dataset dataset, boolean bl) {
        Chip chip = this.getChip(dataset);
        Chip2ChipMapperSymbol chip2ChipMapperSymbol = VdbRuntimeResources.getGeneSymbolMapper(chip, bl);
        GeneSet geneSet2 = chip2ChipMapperSymbol.map(geneSet, false).getMappedGeneSet(true);
        return geneSet2.cloneDeep(dataset);
    }

    @Override
    public List getSamples_list(int[] nArray) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.getSample(nArray[i2]));
        }
        return arrayList;
    }

    @Override
    public List getSampleNames_list(int[] nArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.getSample(nArray[i2]).getName());
        }
        return arrayList;
    }

    @Override
    public Sample[] getSamples(int[] nArray) {
        Sample[] sampleArray = new Sample[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            sampleArray[i2] = this.getSample(nArray[i2]);
        }
        return sampleArray;
    }

    @Override
    public String getSampleName(String string) {
        return this.getSample(string).getName();
    }

    @Override
    public Sample[] getSamples(String[] stringArray) {
        Sample[] sampleArray = new Sample[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            sampleArray[i2] = this.getSample(stringArray[i2]);
        }
        return sampleArray;
    }

    @Override
    public String[] getCelFileNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = this.getSample(stringArray[i2]).getCelFileName();
        }
        return stringArray2;
    }

    protected static final String make_name_proper(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param celFileOrSampleName cannot be null");
        }
        if ((string = string.trim()).endsWith(".CEL")) {
            string = string.substring(0, string.indexOf(".CEL"));
        }
        if (string.endsWith(".cel")) {
            string = string.substring(0, string.indexOf(".cel"));
        }
        if (string.endsWith(".TXT")) {
            string = string.substring(0, string.indexOf(".TXT"));
        }
        if (string.endsWith(".txt")) {
            string = string.substring(0, string.indexOf(".txt"));
        }
        string = string.trim();
        return string;
    }

    @Override
    public TemplateFromAnnot createTemplate(String string) {
        return this.createCategory(string).createTemplate();
    }

    @Override
    public TemplateFromAnnot[] createAllTemplates() {
        String[] stringArray = this.getAllCategoricalCategoryNames();
        TemplateFromAnnot[] templateFromAnnotArray = new TemplateFromAnnot[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            templateFromAnnotArray[i2] = this.createTemplate(stringArray[i2]);
        }
        return templateFromAnnotArray;
    }

    @Override
    public String getStateName(String string, Sample sample) {
        return sample.getCategoryValue(string);
    }

    @Override
    public Sample getSample(String string) {
        Sample sample = this._getSample(string);
        if (sample == null) {
            throw new IllegalArgumentException("No such sample: " + string + " \nsamples are\n" + this.getSampleNames_list());
        }
        return sample;
    }

    public final void ensureValidSampleNames(Dataset dataset, boolean bl) {
        this.ensureValidSampleNames(dataset.getColumnNamesArray(), bl);
    }

    public final void ensureValidSampleNames(String[] stringArray, boolean bl) {
        if (bl && stringArray.length != this.getNumSamples()) {
            throw new IllegalArgumentException("Mismatched sample numbers. celFileOrSampleNames: " + stringArray + " annot: " + this.getNumSamples());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            try {
                Sample sample;
                Sample sample2 = this.getSample(string);
                if (!bl || sample2.equals(sample = this.getSample(i2))) continue;
                String string2 = "Mismatched sample orderd b/w ds and sample annotation: " + sample2.getName() + " " + sample.getName();
                klog.debug(string2);
                throw new Exception(string2);
            }
            catch (Throwable throwable) {
                if (arrayList.size() < 2) {
                    throwable.printStackTrace();
                }
                arrayList.add(string);
            }
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer("Unknown sample names:  " + arrayList.size() + " \n");
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                stringBuffer.append("[").append(arrayList.get(i3)).append("] ");
            }
            throw new RuntimeException(stringBuffer.toString());
        }
        this.log.info("All samples passed checks: " + stringArray.length);
    }

    public final String ensureSameOrganism(Dataset dataset) {
        return this.ensureSameOrganism(dataset.getColumnNamesArray());
    }

    public final String ensureSameOrganism(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            try {
                Sample sample = this.getSample(string2);
                if (string == null) {
                    string = sample.getOrganism();
                }
                if (sample.getOrganism().equalsIgnoreCase(string)) continue;
                throw new IllegalArgumentException("Mismatched organisms: " + string + " and " + sample.getOrganism() + " for sample: " + sample.getName());
            }
            catch (Throwable throwable) {
                arrayList.add(string2);
            }
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer("Unknown sample names:  " + arrayList.size() + " \n");
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                stringBuffer.append("[").append(arrayList.get(i3)).append("] ");
            }
            throw new RuntimeException(stringBuffer.toString());
        }
        this.log.info("All samples passed sin checks: " + stringArray.length);
        return string;
    }

    public final Chip ensureSameChip(Sample[] sampleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Chip chip = null;
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            try {
                if (chip == null) {
                    chip = sampleArray[i2].getChip();
                }
                if (sampleArray[i2].getChip().equals(chip)) continue;
                arrayList.add(sampleArray[i2].getName());
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer("Mismatched chips for samples:  " + arrayList.size() + " \n");
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                stringBuffer.append("[").append(arrayList.get(i3)).append("] ");
            }
            throw new RuntimeException(stringBuffer.toString());
        }
        this.log.info("All samples passed checks: " + sampleArray.length);
        return chip;
    }

    @Override
    public Category[] createAllCategories() {
        String[] stringArray = this.getAllCategoricalCategoryNames();
        Category[] categoryArray = new Category[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            categoryArray[i2] = this.createCategory(stringArray[i2]);
        }
        return categoryArray;
    }

    @Override
    public Category createCategory(String string) {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        Object[] objectArray = this.getCelFileNames();
        boolean bl = false;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Sample sample = this.getSample(objectArray[i2]);
            object2 = sample.getCategoryValue(string);
            bl = true;
            object = hashMap.get(object2);
            if (object == null) {
                object = new ArrayList();
            }
            ((List)object).add(sample);
            hashMap.put(object2, object);
        }
        if (!bl) {
            throw new IllegalArgumentException("No matches for category: " + string + " for states: " + hashMap + " " + " celFileOrSampleNames: " + objectArray.length + " \n" + Printf.outs(objectArray));
        }
        State[] stateArray = new State[hashMap.size()];
        int n = 0;
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next().toString();
            List list = (List)hashMap.get(object);
            Sample[] sampleArray = list.toArray(new Sample[list.size()]);
            stateArray[n++] = new State((String)object, sampleArray);
        }
        return new Category(string, stateArray, this);
    }

    @Override
    public Category createCategory(String string, Set set) {
        return this._createCategory(string, set.toArray(new String[set.size()]), this.getCelFileNames());
    }

    @Override
    public Category createCategory(String string, String[] stringArray) {
        return this._createCategory(string, stringArray, this.getCelFileNames());
    }

    private Category _createCategory(String string, String[] stringArray, String[] stringArray2) {
        Object object;
        Object object2;
        String[] stringArray3 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray3.length; ++i2) {
            stringArray3[i2] = stringArray[i2].toUpperCase();
        }
        Set set = AbstractSampleAnnot.checkForDuplicates(stringArray3);
        HashMap hashMap = new HashMap();
        boolean bl = false;
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            Sample sample = this.getSample(stringArray2[i3]);
            object2 = sample.getCategoryValue(string);
            if (!set.contains(object2)) continue;
            bl = true;
            object = hashMap.get(object2);
            if (object == null) {
                object = new ArrayList();
            }
            ((List)object).add(sample);
            hashMap.put(object2, object);
        }
        if (hashMap.size() != stringArray3.length) {
            StringBuffer stringBuffer = new StringBuffer("No match in SampleDb for category: " + string + " for some states(s): \n");
            for (int i4 = 0; i4 < stringArray3.length; ++i4) {
                if (hashMap.containsKey(stringArray3[i4])) continue;
                stringBuffer.append(stringArray3[i4]).append('\n');
            }
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        if (!bl) {
            throw new IllegalArgumentException("No matches at in category: " + string + " for states: " + set);
        }
        State[] stateArray = new State[stringArray3.length];
        for (int i5 = 0; i5 < stateArray.length; ++i5) {
            object2 = (List)hashMap.get(stringArray3[i5]);
            object = object2.toArray(new Sample[object2.size()]);
            stateArray[i5] = new State(stringArray3[i5], (Sample[])object);
        }
        return new Category(string, stateArray, this);
    }

    private static Set checkForDuplicates(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (hashSet.contains(stringArray[i2])) {
                throw new IllegalArgumentException("Duplicate states not allowed: " + stringArray[i2]);
            }
            hashSet.add(stringArray[i2]);
        }
        if (hashSet.size() != stringArray.length) {
            throw new IllegalArgumentException("Duplicate states specified: " + hashSet);
        }
        return hashSet;
    }

    protected static final String[] _toSampleNames(Sample[] sampleArray) {
        String[] stringArray = new String[sampleArray.length];
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            stringArray[i2] = sampleArray[i2].getName();
        }
        return stringArray;
    }

    protected static final String[] _toSampleNames(List list) {
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stringArray[i2] = ((Sample)list.get(i2)).getName();
        }
        return stringArray;
    }
}

