/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GeneSetMatrixPairImpl;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.GeneSetPairImpl;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateFromAnnot;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.State;
import edu.mit.broad.vdb.sampledb.StateExpression;
import edu.mit.broad.vdb.sampledb.StateExpressionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Category {
    private Logger log = XLogger.getLogger(Category.class);
    private static final Logger klog = XLogger.getLogger(Category.class);
    private String fName;
    private State[] fStates;
    private SampleAnnot fAnnot;
    private Map stateNameStateMap;

    public Category(String string, State[] stateArray, SampleAnnot sampleAnnot) {
        if (string == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        if (stateArray == null) {
            throw new IllegalArgumentException("Param states cannot be null");
        }
        if (sampleAnnot == null) {
            throw new IllegalArgumentException("Param annot cannot be null");
        }
        for (int i2 = 0; i2 < stateArray.length; ++i2) {
            if (stateArray[i2] != null) continue;
            throw new IllegalArgumentException("States cannot be null at: " + i2);
        }
        this.fName = string;
        this.fStates = stateArray;
        this.fAnnot = sampleAnnot;
    }

    public final String getName() {
        return this.fName;
    }

    public final Dataset collapseSamplesIntoStates(Dataset dataset, boolean bl) {
        Object object;
        Matrix matrix = new Matrix(dataset.getNumRow(), this.getNumStates());
        for (int i2 = 0; i2 < this.getNumStates(); ++i2) {
            object = this.getState(i2);
            String[] stringArray = ((State)object).getSampleNames();
            Vector vector = new Vector(dataset.getNumRow());
            for (int i3 = 0; i3 < dataset.getNumRow(); ++i3) {
                Vector vector2 = new Vector(stringArray.length);
                for (int i4 = 0; i4 < stringArray.length; ++i4) {
                    vector2.setElement(i4, dataset.getElement(i3, stringArray[i4]));
                }
                vector.setElement(i3, vector2.meanOrMedian(bl));
            }
            matrix.setColumn(i2, vector);
        }
        AnnotImpl annotImpl = null;
        if (dataset.getAnnot() != null && dataset.getAnnot().getFeatureAnnot() != null) {
            object = new SampleAnnotImpl(this.getName(), this.getStateNames(), null);
            annotImpl = new AnnotImpl(dataset.getAnnot().getFeatureAnnot(), (SampleAnnot)object);
        }
        return new DefaultDataset(dataset.getName() + "_state_collapsed_" + this.getNumStates(), matrix, dataset.getRowNamesArray(), this.getStateNames(), true, (Annot)annotImpl);
    }

    public final GeneSetMatrixPair createGeneSets_ova(String string, Dataset dataset, int n) {
        Template[] templateArray = this.createTemplates(string, dataset);
        return Category._makeSets(string, dataset, templateArray, n);
    }

    public final GeneSetMatrixPair createGeneSets_ova(Dataset dataset, int n) {
        TemplateFromAnnot templateFromAnnot = this.createTemplate();
        Template[] templateArray = TemplateFactory.extractAllOvaTemplates(templateFromAnnot, true);
        return Category._makeSets("ova", dataset, templateArray, n);
    }

    public final GeneSetMatrixPair createGeneSets_ap(Dataset dataset, int n) {
        TemplateFromAnnot templateFromAnnot = this.createTemplate();
        Template[] templateArray = TemplateFactory.extractAllPairsTemplates(templateFromAnnot);
        this.log.debug("# of templates =" + templateArray.length + " from states: " + this.getNumStates());
        return Category._makeSets("ap", dataset, templateArray, n);
    }

    public final GeneSetPair[] createGeneSets_ap2(Dataset dataset, int n) {
        TemplateFromAnnot templateFromAnnot = this.createTemplate();
        Template[] templateArray = TemplateFactory.extractAllPairsTemplates(templateFromAnnot);
        return Category._makeSets_gsp(dataset, templateArray, n);
    }

    private static GeneSetMatrixPair _makeSets(String string, Dataset dataset, Template[] templateArray, int n) {
        Object object;
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        ArrayList<GeneSet> arrayList2 = new ArrayList<GeneSet>();
        RankedList[] rankedListArray = new RankedList[templateArray.length];
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            RankedList rankedList;
            object = templateArray[i2].getName();
            System.out.println("Doing: " + (String)object + " " + (i2 + 1) + " / " + templateArray.length);
            DatasetTemplate datasetTemplate = new DatasetGenerators().extract(dataset, templateArray[i2]);
            rankedListArray[i2] = rankedList = datasetMetrics.scoreDataset(datasetTemplate).cloneShallowRL((String)object);
            GeneSet geneSet = rankedList.getNamesOfUpOrDnXRanks_gs(n, true);
            arrayList.add(geneSet);
            GeneSet geneSet2 = rankedList.getNamesOfUpOrDnXRanks_gs(n, false);
            arrayList2.add(geneSet2);
        }
        DefaultGeneSetMatrix defaultGeneSetMatrix = new DefaultGeneSetMatrix(string + "_up", arrayList);
        object = new DefaultGeneSetMatrix(string + "_dn", arrayList2);
        return new GeneSetMatrixPairImpl(defaultGeneSetMatrix, (GeneSetMatrix)object);
    }

    private static GeneSetPair[] _makeSets_gsp(Dataset dataset, Template[] templateArray, int n) {
        DatasetMetrics datasetMetrics = new DatasetMetrics();
        GeneSetPair[] geneSetPairArray = new GeneSetPair[templateArray.length];
        RankedList[] rankedListArray = new RankedList[templateArray.length];
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            RankedList rankedList;
            String string = templateArray[i2].getName();
            System.out.println("Doing: " + string + " " + (i2 + 1) + " / " + templateArray.length);
            DatasetTemplate datasetTemplate = new DatasetGenerators().extract(dataset, templateArray[i2]);
            rankedListArray[i2] = rankedList = datasetMetrics.scoreDataset(datasetTemplate).cloneShallowRL(string);
            GeneSet geneSet = rankedList.getNamesOfUpOrDnXRanks_gs(n, true);
            GeneSet geneSet2 = rankedList.getNamesOfUpOrDnXRanks_gs(n, false);
            geneSetPairArray[i2] = new GeneSetPairImpl(geneSet, geneSet2);
        }
        return geneSetPairArray;
    }

    public final int getNumStates() {
        return this.fStates.length;
    }

    public final int getNumSamples(String string) {
        return this.getState(string).getNumSamples();
    }

    public final State getState(String string) {
        Object v;
        if (this.stateNameStateMap == null) {
            this.stateNameStateMap = new HashMap();
            for (int i2 = 0; i2 < this.fStates.length; ++i2) {
                this.stateNameStateMap.put(this.fStates[i2].getName(), this.fStates[i2]);
            }
        }
        if ((v = this.stateNameStateMap.get(string)) == null) {
            throw new IllegalArgumentException("Np such state in this categ: " + string);
        }
        return (State)v;
    }

    public final State[] getStates() {
        return this.fStates;
    }

    public final State getState(int n) {
        return this.fStates[n];
    }

    public final StateExpression[] getStateExpressions(Dataset dataset) {
        StateExpression[] stateExpressionArray = new StateExpression[this.fStates.length];
        for (int i2 = 0; i2 < this.fStates.length; ++i2) {
            stateExpressionArray[i2] = new StateExpressionImpl(this.fStates[i2], new DatasetGenerators().extractColumns(this.fStates[i2].getName(), dataset, this.fStates[i2].getSampleNames()));
        }
        return stateExpressionArray;
    }

    public final String[] getStateNames() {
        String[] stringArray = new String[this.fStates.length];
        for (int i2 = 0; i2 < this.fStates.length; ++i2) {
            stringArray[i2] = this.fStates[i2].getName();
        }
        return stringArray;
    }

    public final List getStateNames_list() {
        return Arrays.asList(this.getStateNames());
    }

    public final State[] getStates(Set set) {
        Iterator iterator = set.iterator();
        HashSet<State> hashSet = new HashSet<State>();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            for (int i2 = 0; i2 < this.fStates.length; ++i2) {
                if (!this.fStates[i2].getName().equals(string)) continue;
                hashSet.add(this.fStates[i2]);
            }
        }
        return hashSet.toArray(new State[hashSet.size()]);
    }

    public final State[] getStates(String[] stringArray) {
        ArrayList<State> arrayList = new ArrayList<State>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            for (int i3 = 0; i3 < this.fStates.length; ++i3) {
                if (!this.fStates[i3].getName().equalsIgnoreCase(string)) continue;
                arrayList.add(this.fStates[i3]);
            }
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("No hits for states: " + Printf.outs(stringArray));
        }
        return arrayList.toArray(new State[arrayList.size()]);
    }

    public final Sample[] getSamples() {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.fStates.length; ++i2) {
            arrayList.addAll(this.fStates[i2].getSamples_list());
        }
        return arrayList.toArray(new Sample[arrayList.size()]);
    }

    public final String[] getSampleNames() {
        Sample[] sampleArray = this.getSamples();
        String[] stringArray = new String[sampleArray.length];
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            stringArray[i2] = sampleArray[i2].getName();
        }
        return stringArray;
    }

    public final Sample[] getSamples(String[] stringArray) {
        State[] stateArray = this.getStates(stringArray);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < stateArray.length; ++i2) {
            arrayList.addAll(stateArray[i2].getSamples_list());
        }
        return arrayList.toArray(new Sample[arrayList.size()]);
    }

    public final String[] getSampleNames(String[] stringArray) {
        Sample[] sampleArray = this.getSamples(stringArray);
        String[] stringArray2 = new String[sampleArray.length];
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            stringArray2[i2] = sampleArray[i2].getName();
        }
        return stringArray2;
    }

    public final String[] getSampleNames(String string) {
        return this.getState(string).getSampleNames();
    }

    public final TemplateFromAnnot createTemplate() {
        State[] stateArray = this.getStates();
        return this.createTemplate(stateArray);
    }

    public final TemplateFromAnnot createTemplate(State[] stateArray) {
        return TemplateFactory.createTemplate_from_annot(this.getName(), stateArray, this.fAnnot);
    }

    public final TemplateFromAnnot[] createTemplates(String string, Dataset dataset) {
        throw new NotImplementedException();
    }

    public final TemplateFromAnnot[] createTemplates(String[] stringArray, Dataset dataset) {
        throw new NotImplementedException();
    }

    public final TemplateFromAnnot createTemplate(String[] stringArray) {
        return TemplateFactory.createTemplate_from_annot(this.getName(), this.getStates(stringArray), this.fAnnot);
    }

    public final TemplateFromAnnot createTemplate(String[] stringArray, String[] stringArray2, Dataset dataset) {
        int n;
        String string = Category._toName(stringArray);
        String string2 = Category._toName(stringArray2);
        String[] stringArray3 = this.getSampleNames(stringArray);
        String[] stringArray4 = this.getSampleNames(stringArray2);
        String[] stringArray5 = new String[stringArray3.length + stringArray4.length];
        int n2 = 0;
        for (n = 0; n < stringArray3.length; ++n) {
            stringArray5[n2++] = stringArray3[n];
        }
        for (n = 0; n < stringArray4.length; ++n) {
            stringArray5[n2++] = stringArray4[n];
        }
        Template template = TemplateFactory.createCategoricalTemplate(string + "_vs_" + string2, dataset, string, stringArray3, string2, stringArray4);
        return new TemplateFromAnnot(template, this.fAnnot.getSamples(stringArray5), stringArray3, stringArray4);
    }

    public final TemplateFromAnnot createTemplate(String string, String[] stringArray, Dataset dataset) {
        return this.createTemplate(new String[]{string}, stringArray, dataset);
    }

    public final TemplateFromAnnot createTemplate(String string, String string2, Dataset dataset) {
        return this.createTemplate(new String[]{string}, new String[]{string2}, dataset);
    }

    public final TemplateFromAnnot createTemplate_ova(String string) {
        TemplateFromAnnot templateFromAnnot = this.createTemplate();
        Template template = TemplateFactory.extractOvaTemplate(templateFromAnnot, templateFromAnnot.getClass(string));
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getSampleNames(string)));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = this.getSampleNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (arrayList.contains(stringArray[i2])) continue;
            arrayList2.add(stringArray[i2]);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.addAll(arrayList);
        arrayList3.addAll(arrayList2);
        Sample[] sampleArray = this.fAnnot.getSamples(arrayList3.toArray(new String[arrayList3.size()]));
        return new TemplateFromAnnot(template, sampleArray, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]));
    }

    public final TemplateFromAnnot[] createTemplate_ap(String string, Dataset dataset) {
        String[] stringArray = this.getStateNames();
        ArrayList<TemplateFromAnnot> arrayList = new ArrayList<TemplateFromAnnot>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals(string)) continue;
            arrayList.add(this.createTemplate(string, stringArray[i2], dataset));
        }
        return arrayList.toArray(new TemplateFromAnnot[arrayList.size()]);
    }

    public final TemplateFromAnnot[] createTemplate_ap_all(Dataset dataset) {
        ArrayList<TemplateFromAnnot> arrayList = new ArrayList<TemplateFromAnnot>();
        for (int i2 = 0; i2 < this.getNumStates(); ++i2) {
            TemplateFromAnnot[] templateFromAnnotArray = this.createTemplate_ap(this.getState(i2).getName(), dataset);
            arrayList.addAll(Arrays.asList(templateFromAnnotArray));
        }
        return arrayList.toArray(new TemplateFromAnnot[arrayList.size()]);
    }

    public final TemplateFromAnnot[] createTemplate_ova_all() {
        TemplateFromAnnot[] templateFromAnnotArray = new TemplateFromAnnot[this.getNumStates()];
        for (int i2 = 0; i2 < this.getNumStates(); ++i2) {
            templateFromAnnotArray[i2] = this.createTemplate_ova(this.getState(i2).getName());
        }
        return templateFromAnnotArray;
    }

    private static String _toName(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }
}

