/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.ColorMap$Columns;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelSdfColorStruc;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.sampledb.AbstractSample;
import edu.mit.broad.vdb.sampledb.AbstractSampleAnnot;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.SampleAnnotGcm$ColorMapImpl;
import edu.mit.broad.vdb.sampledb.SampleAnnotGcm$LineageComparator;
import edu.mit.broad.vdb.sampledb.SampleGcm;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleAnnotGcm
extends AbstractSampleAnnot {
    private static List ALL_CATEGORY_NAMES = new ArrayList();
    private static Set CATEGORICAL_CATEGORY_NAMES = new HashSet();
    private ColorMap$Columns fColorMap;
    private Map fStateColorMap;

    public static final String[] getCommonCategoryNames() {
        return new String[0];
    }

    private SampleAnnotGcm(String string, Map map, SampleGcm[] sampleGcmArray) {
        this.initHere(string, map, sampleGcmArray);
    }

    private void initHere(String string, Map map, SampleGcm[] sampleGcmArray) {
        super.initialize(string);
        this.fSamples = sampleGcmArray;
        this.fStateColorMap = map;
        this.fColorMap = new SampleAnnotGcm$ColorMapImpl(this, map);
    }

    @Override
    public final SampleAnnot cloneDeep(String string, String[] stringArray) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(this.getSample(stringArray[i2]));
        }
        return new SampleAnnotGcm(string, this.fStateColorMap, arrayList.toArray(new SampleGcm[arrayList.size()]));
    }

    @Override
    public final String[] getAllCategoricalCategoryNames() {
        return CATEGORICAL_CATEGORY_NAMES.toArray(new String[CATEGORICAL_CATEGORY_NAMES.size()]);
    }

    @Override
    public final boolean isValidCategoricalCategory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param categoryName cannot be null");
        }
        return CATEGORICAL_CATEGORY_NAMES.contains(string.toUpperCase());
    }

    public static final String[] getAllCategoryNames() {
        return ALL_CATEGORY_NAMES.toArray(new String[ALL_CATEGORY_NAMES.size()]);
    }

    public static final boolean isCategoryName(String string) {
        return ALL_CATEGORY_NAMES.contains(string);
    }

    @Override
    public final Comparator createDefaultSampleComparator() {
        return new SampleAnnotGcm$LineageComparator(this);
    }

    @Override
    public final Comparator createDefaultStateComparator(String string) {
        throw new NotImplementedException();
    }

    public final String[] getSampleNames_OrderByLineage() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            arrayList.add(this.getSample(i2));
        }
        Collections.sort(arrayList, new SampleAnnotGcm$LineageComparator(this));
        return SampleAnnotGcm._toSampleNames(arrayList);
    }

    @Override
    public final ColorMap$Columns getColorMap() {
        return this.fColorMap;
    }

    public final String[] getLineages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            String string = this._getSample(i2).getLineage();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final SampleGcm[] getHSCSamples() {
        ArrayList<SampleGcm> arrayList = new ArrayList<SampleGcm>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            SampleGcm sampleGcm = this._getSample(i2);
            if (!sampleGcm.getLineage().equalsIgnoreCase("HSC")) continue;
            arrayList.add(sampleGcm);
        }
        return SampleAnnotGcm._arr(arrayList);
    }

    public final String[] getHSCSampleNames() {
        return SampleAnnotGcm._toSampleNames(this.getHSCSamples());
    }

    public final List getHSCSampleNamesList() {
        return Arrays.asList(this.getHSCSampleNames());
    }

    private static SampleGcm[] _arr(List list) {
        return list.toArray(new SampleGcm[list.size()]);
    }

    private SampleGcm _getSample(int n) {
        return (SampleGcm)this.getSample(n);
    }

    public final void saveBrief(Template template, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            SampleGcm sampleGcm = (SampleGcm)this.getSample(i2);
            stringBuffer.append(sampleGcm.getName()).append('\t');
            stringBuffer.append(sampleGcm.getLineage()).append('\t');
            stringBuffer.append(sampleGcm.getDataSource()).append('\t');
            stringBuffer.append(sampleGcm.getChipName()).append('\t');
            if (template != null) {
                stringBuffer.append(template.getItemByProfilePos(i2).getId()).append('\t');
            }
            if (template != null) {
                stringBuffer.append(template.getClassByProfilePos(i2).getName());
            }
            stringBuffer.append('\n');
        }
        FileUtils.write(stringBuffer.toString(), file);
    }

    public static final SampleAnnotGcm parse(File file) {
        return SampleAnnotGcm.parse(MiscParsers.excel2sdf_and_colors(file));
    }

    public static final SampleAnnotGcm parse(MiscParsers$ExcelSdfColorStruc miscParsers$ExcelSdfColorStruc) {
        StringDataframe stringDataframe = AbstractSampleAnnot.checkSdf_makeUC_and_remove_bad_qc_samples(miscParsers$ExcelSdfColorStruc);
        String[] stringArray = stringDataframe.getColumn("CEL_FILE_NAME_HU6800");
        Sample[] sampleArray = new SampleGcm[stringDataframe.getNumRow()];
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            String string = SampleAnnotGcm.make_name_proper(stringDataframe.getRowName(i2));
            sampleArray[i2] = new SampleGcm(string, stringArray[i2]);
        }
        AbstractSample.setCommonSampleProperties((AbstractSample[])sampleArray, stringDataframe);
        String[] stringArray2 = stringDataframe.getColumn("DIAGNOSIS");
        for (int i3 = 0; i3 < sampleArray.length; ++i3) {
            ((SampleGcm)sampleArray[i3]).fDiagnosis = stringArray2[i3];
        }
        String[] stringArray3 = stringDataframe.getColumn("LINEAGE");
        for (int i4 = 0; i4 < sampleArray.length; ++i4) {
            ((SampleGcm)sampleArray[i4]).fLineage = stringArray3[i4];
        }
        SampleAnnotGcm.checkForDuplicates_SampleNames_and_SampleCelFiles(sampleArray);
        return new SampleAnnotGcm(miscParsers$ExcelSdfColorStruc.sdf.getName(), miscParsers$ExcelSdfColorStruc.stateColorMap, (SampleGcm[])sampleArray);
    }

    static {
        ALL_CATEGORY_NAMES.add("SAMPLE_NAME");
        ALL_CATEGORY_NAMES.add("DIAGNOSIS");
        ALL_CATEGORY_NAMES.add("ORGANISM");
        ALL_CATEGORY_NAMES.add("LINEAGE");
        ALL_CATEGORY_NAMES.add("%_P_CALLS_ON_ARRAY");
        ALL_CATEGORY_NAMES.add("COMMENTS");
    }
}

