/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.ColorMap$Columns;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelSdfColorStruc;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.sampledb.AbstractSample;
import edu.mit.broad.vdb.sampledb.AbstractSampleAnnot;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.SampleAnnotGnf$ColorMapImpl;
import edu.mit.broad.vdb.sampledb.SampleAnnotGnf$LineageComparator;
import edu.mit.broad.vdb.sampledb.SampleGnf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleAnnotGnf
extends AbstractSampleAnnot {
    private static List ALL_CATEGORY_NAMES = new ArrayList();
    private static Set CATEGORICAL_CATEGORY_NAMES = new HashSet();
    private ColorMap$Columns fColorMap;
    private Map fStateColorMap;

    public static final String[] getCommonCategoryNames() {
        return new String[0];
    }

    private SampleAnnotGnf(String string, Map map, SampleGnf[] sampleGnfArray) {
        this.initHere(string, map, sampleGnfArray);
    }

    private void initHere(String string, Map map, SampleGnf[] sampleGnfArray) {
        super.initialize(string);
        this.fSamples = sampleGnfArray;
        this.fStateColorMap = map;
        this.fColorMap = new SampleAnnotGnf$ColorMapImpl(this, map);
    }

    @Override
    public final SampleAnnot cloneDeep(String string, String[] stringArray) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(this.getSample(stringArray[i2]));
        }
        return new SampleAnnotGnf(string, this.fStateColorMap, arrayList.toArray(new SampleGnf[arrayList.size()]));
    }

    @Override
    public final String[] getAllCategoricalCategoryNames() {
        return CATEGORICAL_CATEGORY_NAMES.toArray(new String[CATEGORICAL_CATEGORY_NAMES.size()]);
    }

    @Override
    public final boolean isValidCategoricalCategory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param categoryName cannot be null");
        }
        return CATEGORICAL_CATEGORY_NAMES.contains(string.toUpperCase());
    }

    public static final String[] getAllCategoryNames() {
        return ALL_CATEGORY_NAMES.toArray(new String[ALL_CATEGORY_NAMES.size()]);
    }

    public static final boolean isCategoryName(String string) {
        return ALL_CATEGORY_NAMES.contains(string);
    }

    @Override
    public final Comparator createDefaultSampleComparator() {
        return new SampleAnnotGnf$LineageComparator(this);
    }

    @Override
    public final Comparator createDefaultStateComparator(String string) {
        throw new NotImplementedException();
    }

    public final String[] getSampleNames_OrderByLineage() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            arrayList.add(this.getSample(i2));
        }
        Collections.sort(arrayList, new SampleAnnotGnf$LineageComparator(this));
        return SampleAnnotGnf._toSampleNames(arrayList);
    }

    @Override
    public final ColorMap$Columns getColorMap() {
        return this.fColorMap;
    }

    public final String[] getLineages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            String string = this._getSample(i2).getLineage();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private SampleGnf _getSample(int n) {
        return (SampleGnf)this.getSample(n);
    }

    private SampleGnf _getSample(String string) {
        return (SampleGnf)this.getSample(string);
    }

    public final void saveBrief(Template template, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            SampleGnf sampleGnf = (SampleGnf)this.getSample(i2);
            stringBuffer.append(sampleGnf.getName()).append('\t');
            stringBuffer.append(sampleGnf.getLineage()).append('\t');
            stringBuffer.append(sampleGnf.getDataSource()).append('\t');
            stringBuffer.append(sampleGnf.getChipName()).append('\t');
            if (template != null) {
                stringBuffer.append(template.getItemByProfilePos(i2).getId()).append('\t');
            }
            if (template != null) {
                stringBuffer.append(template.getClassByProfilePos(i2).getName());
            }
            stringBuffer.append('\n');
        }
        FileUtils.write(stringBuffer.toString(), file);
    }

    public static final SampleAnnotGnf parse(File file) {
        return SampleAnnotGnf.parse(MiscParsers.excel2sdf_and_colors(file));
    }

    public static final SampleAnnotGnf parse(MiscParsers$ExcelSdfColorStruc miscParsers$ExcelSdfColorStruc) {
        StringDataframe stringDataframe = AbstractSampleAnnot.checkSdf_makeUC_and_remove_bad_qc_samples(miscParsers$ExcelSdfColorStruc);
        Sample[] sampleArray = new SampleGnf[stringDataframe.getNumRow()];
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            String string = SampleAnnotGnf.make_name_proper(stringDataframe.getRowName(i2));
            sampleArray[i2] = new SampleGnf(string);
        }
        AbstractSample.setCommonSampleProperties((AbstractSample[])sampleArray, stringDataframe);
        String[] stringArray = stringDataframe.getColumn("LINEAGE");
        for (int i3 = 0; i3 < sampleArray.length; ++i3) {
            ((SampleGnf)sampleArray[i3]).fLineage = stringArray[i3];
        }
        SampleAnnotGnf.checkForDuplicates_SampleNames_and_SampleCelFiles(sampleArray);
        return new SampleAnnotGnf(miscParsers$ExcelSdfColorStruc.sdf.getName(), miscParsers$ExcelSdfColorStruc.stateColorMap, (SampleGnf[])sampleArray);
    }

    static final /* synthetic */ SampleGnf access$000(SampleAnnotGnf sampleAnnotGnf, String string) {
        return sampleAnnotGnf._getSample(string);
    }

    static {
        ALL_CATEGORY_NAMES.add("SAMPLE_NAME");
        ALL_CATEGORY_NAMES.add("ORGANISM");
        ALL_CATEGORY_NAMES.add("LINEAGE");
        ALL_CATEGORY_NAMES.add("COMMENTS");
    }
}

