/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.RendererFactory2;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.genepattern.uiutil.FTPFile;

public class RendererFactory2$CommonLookListRenderer
extends DefaultListCellRenderer {
    private boolean ifFileOnlyShowName;

    public RendererFactory2$CommonLookListRenderer(boolean bl) {
        this.ifFileOnlyShowName = bl;
    }

    public RendererFactory2$CommonLookListRenderer() {
        this(false);
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof PersistentObject) {
            Comparable<StringBuffer> comparable;
            PersistentObject persistentObject = (PersistentObject)object;
            if (persistentObject.getQuickInfo() != null) {
                comparable = new StringBuffer("<html><body>").append(persistentObject.getName());
                ((StringBuffer)comparable).append("<font color=#666666> [").append(persistentObject.getQuickInfo()).append(']').append("</font></html></body>");
                this.setText(((StringBuffer)comparable).toString());
            } else {
                this.setText(persistentObject.getName());
            }
            comparable = null;
            if (ParserFactory.getCache().isCached(persistentObject)) {
                comparable = ParserFactory.getCache().getSourceFile(persistentObject);
            }
            if (comparable != null) {
                this.setToolTipText(((File)comparable).getAbsolutePath());
            } else {
                this.setToolTipText("Unknown origins of file: " + comparable);
            }
        } else if (object instanceof File) {
            if (this.ifFileOnlyShowName) {
                this.setText(((File)object).getName());
            } else {
                this.setText(((File)object).getAbsolutePath());
            }
            this.setIcon(DataFormat.getIcon(object));
            this.setToolTipText(((File)object).getAbsolutePath());
        } else if (object instanceof XChart) {
            this.setText(((XChart)object).getName());
            this.setIcon(XChart.ICON);
        } else if (object instanceof FTPFile) {
            String string = ((FTPFile)object).getPath();
            String string2 = string.toLowerCase();
            if (string2.indexOf("c1.") != -1) {
                string = string + " [Positional]";
            } else if (string2.indexOf("c2.") != -1) {
                string = string + " [Curated]";
            } else if (string2.indexOf("c3.") != -1) {
                string = string + " [Motif]";
            } else if (string2.indexOf("c4.") != -1) {
                string = string + " [Computational]";
            }
            this.setText(string);
            this.setIcon(RendererFactory2.FTP_FILE_ICON);
        }
        return this;
    }
}

