/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions;

import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.LongWidgetAction;
import edu.mit.broad.xbench.actions.ObjectAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import javax.swing.Icon;

public class ProxyObjectAction
extends LongWidgetAction {
    private ObjectAction fAction;
    private Object fFileOrObj;

    public ProxyObjectAction(ObjectAction objectAction, File file) {
        if (objectAction == null) {
            throw new IllegalArgumentException("Param action cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        this.fAction = objectAction;
        this.fFileOrObj = file;
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        Object object = this.fAction.getValue("ShortDescription");
        if (object != null) {
            this.putValue("ShortDescription", object);
        }
    }

    public ProxyObjectAction(ObjectAction objectAction, Object object) {
        if (objectAction == null) {
            throw new IllegalArgumentException("Param action cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Param obj cannot be null");
        }
        this.fAction = objectAction;
        this.fFileOrObj = object;
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        Object object2 = this.fAction.getValue("ShortDescription");
        if (object2 != null) {
            this.putValue("ShortDescription", object2);
        }
    }

    @Override
    public final String getName() {
        return this.fAction.getName();
    }

    @Override
    public final Icon getIcon() {
        return this.fAction.getIcon();
    }

    @Override
    public final String getDescription() {
        return this.fAction.getDescription();
    }

    @Override
    public final Widget getWidget() {
        try {
            Object object;
            if (this.fFileOrObj instanceof File) {
                File file = (File)this.fFileOrObj;
                this.log.debug("Reading file for action: " + file);
                object = ParserFactory.read(file, true);
            } else {
                object = this.fFileOrObj;
            }
            if (object != null) {
                this.fAction.setObject(object);
                return this.fAction.getWidget();
            }
            return null;
        }
        catch (Exception exception) {
            Application.getWindowManager().showError("Trouble making Proxy", exception);
            return null;
        }
    }

    @Override
    public final String getId() {
        return this.fAction.getId();
    }
}

