/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.ext;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.ext.SystemCall;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.prefs.FilePreference;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class ExcelAction
extends ExtAction {
    public ExcelAction() {
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
    }

    public ExcelAction(String string) {
        this();
        this.fPath = string;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        FilePreference filePreference = XPreferencesFactory.kExcel;
        String string = ExcelAction.getExePath(filePreference);
        try {
            if (this.fPath != null) {
                this.fPath = AuxUtils.getBasePathFromAuxPath(this.fPath);
                SystemCall.launchExternalApplication(this.fPath, string);
            } else {
                SystemCall.launchExternalApplication(filePreference.getFile().getPath());
            }
        }
        catch (Throwable throwable) {
            this.showHelpfulExtError(filePreference, "Microsoft Excel", throwable);
        }
    }

    @Override
    public final String getId() {
        return "ExcelAction";
    }

    @Override
    public final String getName() {
        return "Excel";
    }

    @Override
    public final String getDescription() {
        return "Launch Microsoft Excel in an External Process";
    }

    @Override
    public final Icon getIcon() {
        return JarResources.getIcon("Xls.gif");
    }
}

