/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.ApplicationDialog;
import edu.mit.broad.xbench.core.Window;
import edu.mit.broad.xbench.core.WindowComponent;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import edu.mit.broad.xbench.core.api.DialogDescriptorJide;
import edu.mit.broad.xbench.core.api.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public abstract class AbstractWindowManager
implements WindowManager {
    private JFrame fRootFrame;
    protected static final Logger klog = XLogger.getLogger(AbstractWindowManager.class);

    public AbstractWindowManager(JFrame jFrame) {
        if (jFrame == null) {
            throw new IllegalArgumentException("Param rootFrame cannot be null");
        }
        this.fRootFrame = jFrame;
    }

    @Override
    public JButton createHelpButton() {
        return new JButton("Help TODO");
    }

    @Override
    public Dimension getExpectedWindowSize() {
        return new Dimension(10, 10);
    }

    @Override
    public Window openWindow(WindowComponent windowComponent, Dimension dimension) {
        return this.openWindow(windowComponent);
    }

    @Override
    public void repaintRootWindow() {
        this.fRootFrame.repaint();
    }

    @Override
    public JFrame getRootFrame() {
        return this.fRootFrame;
    }

    @Override
    public double getDesktopWidth() {
        return this.fRootFrame.getSize().getWidth();
    }

    @Override
    public void showError(String string, Throwable throwable) {
        klog.error(string, throwable);
        ApplicationDialog.showError(string, throwable);
    }

    @Override
    public void showError(String string) {
        ApplicationDialog.showError(string);
    }

    @Override
    public void showError(Errors errors) {
        klog.error(errors.getErrors(false));
        ApplicationDialog.showError(errors);
    }

    @Override
    public void showError(Throwable throwable) {
        this.showError("Error", throwable);
    }

    @Override
    public void showError(String string, Throwable throwable, JButton[] jButtonArray) {
        klog.error(string);
        ApplicationDialog.showError(string, throwable);
        klog.debug("TO DO the customRemedyOptions: " + jButtonArray);
    }

    @Override
    public void showError(String string, String string2, JButton[] jButtonArray) {
        klog.error(string2);
        ApplicationDialog.showError(string, string2, new Throwable("No stack trace available"));
        klog.debug("TO DO the customRemedyOptions: " + jButtonArray);
    }

    @Override
    public void showError(String string, String string2) {
        klog.error(string2);
        ApplicationDialog.showError(string, string2, new Throwable("No stack trace available"));
    }

    @Override
    public boolean showConfirm(String string) {
        klog.info(string);
        return ApplicationDialog.showConfirm("Please confirm this action", string);
    }

    @Override
    public boolean showConfirm(String string, String string2) {
        klog.info(string2);
        return ApplicationDialog.showConfirm(string, string2);
    }

    @Override
    public void showMessage(String string) {
        klog.info(string);
        ApplicationDialog.showMessage(string);
    }

    @Override
    public void showMessage(String string, Component component) {
        klog.info(string);
        ApplicationDialog.showMessage(string, component);
    }

    @Override
    public void showMessage(String string, Component component, JButton[] jButtonArray, boolean bl) {
        klog.info(string);
        ApplicationDialog.showMessage(string, component, jButtonArray, bl);
    }

    @Override
    public void showMessage(String string, String string2) {
        klog.info(string2);
        ApplicationDialog.showMessage(string, string2);
    }

    @Override
    public String showInput(String string) {
        return ApplicationDialog.showInput(string);
    }

    @Override
    public String showInput(String string, Object object) {
        return ApplicationDialog.showInput(string, object);
    }

    @Override
    public DialogDescriptor createDialogDescriptor(String string, Component component, Action action) {
        return new DialogDescriptorJide(string, component, action);
    }

    @Override
    public DialogDescriptor createDialogDescriptor(String string, Component component) {
        return new DialogDescriptorJide(string, component, null);
    }
}

