/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.FileManager;
import edu.mit.broad.xbench.core.api.FileManagerImpl$ListCellRenderer;
import edu.mit.broad.xbench.core.api.FileManagerImpl$MyPropertyChangeListener;
import edu.mit.broad.xbench.core.api.XStore;
import edu.mit.broad.xbench.core.api.XStores$DirPathStore;
import edu.mit.broad.xbench.core.api.XStores$FilePathStore;
import edu.mit.broad.xbench.core.api.XStores$StringStore;
import edu.mit.broad.xbench.explorer.filemgr.RecentDirsModel;
import edu.mit.broad.xbench.explorer.filemgr.XDirChooser;
import edu.mit.broad.xbench.explorer.filemgr.XDirChooserJideImpl;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooser;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooserImpl;
import edu.mit.broad.xbench.explorer.filemgr.XTreeDirectoryPane;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileManagerImpl
implements FileManager {
    private static final Logger klog = XLogger.getLogger(FileManagerImpl.class);
    private XStore fRecentFilesStore_as_dirs;
    private XStore fRecentFilesStore_as_files;
    private XStore fRecentUrlsStore;
    private XStore fRecentDirsStore;
    public XDirChooser fDirChooser;
    private XFileChooserImpl fFileChooser;

    @Override
    public final File createFile(String string) {
        return new File(Application.getVdbManager().getDefaultOutputDir(), string);
    }

    private void initFC() {
        if (this.fFileChooser == null) {
            RecentDirsModel recentDirsModel = new RecentDirsModel((ComboBoxModel)this.getRecentFilesStore_as_dirs(), new String[0]);
            JList<Object> jList = new JList<Object>(recentDirsModel);
            jList.setCellRenderer(new FileManagerImpl$ListCellRenderer());
            this.fFileChooser = new XFileChooserImpl(jList);
            ParserFactory.getCache().addPathAdditionsListener(new FileManagerImpl$MyPropertyChangeListener(this));
        }
    }

    @Override
    public final void registerRecentlyOpenedDir(File file) {
        XStore xStore;
        if (file != null && file.isDirectory() && file.exists() && !(xStore = this.getRecentDirsStore()).contains(file.getPath())) {
            xStore.addAndSave(file.getPath());
        }
    }

    @Override
    public final void registerRecentlyOpenedFile(File file) {
        this.getRecentFilesStore().addAndSave(file.getPath());
    }

    @Override
    public final void registerRecentlyOpenedURL(String string) {
        this.getRecentUrlsStore().addAndSave(string);
    }

    @Override
    public final File[] getRecentDirs() {
        this.getRecentFilesStore();
        this.getRecentDirsStore();
        HashSet<File> hashSet = new HashSet<File>();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getRecentDirsStore().fLines);
        arrayList.addAll(this.getRecentFilesStore().fLines);
        klog.debug("# of lines: " + arrayList.size());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            File file;
            Object e2 = arrayList.get(i2);
            if (e2 == null || !(file = new File(e2.toString())).exists()) continue;
            if (file.isFile()) {
                hashSet.add(file.getParentFile());
                continue;
            }
            hashSet.add(file);
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    @Override
    public final File getLastDirAccesessed() {
        XStore xStore = this.getRecentDirsStore();
        if (xStore.getSize() == 0) {
            return null;
        }
        Object object = xStore.getElementAt(xStore.getSize() - 1);
        if (object != null) {
            return new File(object.toString());
        }
        return null;
    }

    @Override
    public final File getSecondLastBookmarkDirAccesessed() {
        XStore xStore = this.getRecentDirsStore();
        if (xStore.getSize() == 0) {
            return null;
        }
        if (xStore.getSize() == 1) {
            return this.getLastDirAccesessed();
        }
        Object object = xStore.getElementAt(xStore.getSize() - 2);
        if (object != null) {
            return new File(object.toString());
        }
        return null;
    }

    @Override
    public final XFileChooser getFileChooser() {
        this.initFC();
        return this.fFileChooser;
    }

    @Override
    public final XFileChooser getFileChooser(FileFilter fileFilter) {
        this.initFC();
        return this.fFileChooser;
    }

    @Override
    public final XFileChooser getFileChooser(FileFilter[] fileFilterArray) {
        this.initFC();
        return this.fFileChooser;
    }

    @Override
    public final XDirChooser getDirChooser(String string) {
        if (this.fDirChooser == null) {
            this.fDirChooser = new XDirChooserJideImpl();
            File file = this.getLastDirAccesessed();
            if (file != null && file.exists()) {
                this.fDirChooser.setCurrentLocation(file.getPath());
            }
        }
        this.fDirChooser.resetState();
        this.fDirChooser.setApproveButtonText(string);
        return this.fDirChooser;
    }

    @Override
    public final XTreeDirectoryPane createXTreeDirectoryPane(String string) {
        throw new NotImplementedException();
    }

    @Override
    public final XTreeDirectoryPane createXTreeDirectoryPane() {
        throw new NotImplementedException();
    }

    private XStore getRecentFilesStore_as_dirs() {
        if (this.fRecentFilesStore_as_dirs == null) {
            this.getRecentFilesStore();
            this.fRecentFilesStore_as_dirs = new XStores$DirPathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_files.txt"));
        }
        return this.fRecentFilesStore_as_dirs;
    }

    @Override
    public final XStore getRecentFilesStore() {
        if (this.fRecentFilesStore_as_files == null) {
            this.fRecentFilesStore_as_files = new XStores$FilePathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_files.txt"));
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i2 = 0; i2 < this.fRecentFilesStore_as_files.getSize(); ++i2) {
                    File file = new File(this.fRecentFilesStore_as_files.getElementAt(i2).toString());
                    if (file.exists()) continue;
                    arrayList.add(this.fRecentFilesStore_as_files.getElementAt(i2));
                }
                this.fRecentFilesStore_as_files.removeAndSave(arrayList);
                this.fRecentFilesStore_as_files.trim(30);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                klog.error("Recent file list initing error: " + throwable);
            }
        }
        return this.fRecentFilesStore_as_files;
    }

    @Override
    public final XStore getRecentDirsStore() {
        if (this.fRecentDirsStore == null) {
            this.fRecentDirsStore = new XStores$DirPathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_dirs.txt"));
            this.fRecentDirsStore.trim(50);
        }
        return this.fRecentDirsStore;
    }

    public final XStore getRecentUrlsStore() {
        if (this.fRecentUrlsStore == null) {
            this.fRecentUrlsStore = new XStores$StringStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_urls.txt"));
            this.fRecentUrlsStore.trim(50);
        }
        return this.fRecentUrlsStore;
    }
}

