/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.dataio;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.GuiHelper$Button;
import edu.mit.broad.genome.swing.dnd.DndTarget;
import edu.mit.broad.genome.swing.dnd.DropTargetDecorator;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.dataio.DataImportTable;
import edu.mit.broad.xbench.dataio.ParserWidget$1;
import edu.mit.broad.xbench.dataio.ParserWidget$2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ParserWidget
extends JPanel
implements Widget,
DndTarget {
    private static final Logger klog = XLogger.getLogger(ParserWidget.class);
    public static final Icon ICON = JarResources.getIcon("Parser16.gif");
    public static final String TITLE = "Import Data";
    private final DataImportTable fTable = new DataImportTable();
    private final JScrollPane tableScrollPane = new JScrollPane(this.fTable);
    private final JButton runButton = GuiHelper$Button.createStartButton("Start Import");
    private ParserWidget fInstance = this;
    private JProgressBar fSharedBar;

    public ParserWidget() {
        this(new File[0]);
    }

    public ParserWidget(File[] fileArray) {
        new DropTargetDecorator(this);
        this.init(fileArray);
    }

    private void init(File[] fileArray) {
        this.fTable.setFiles(fileArray);
        this.jbInit();
        this.runButton.addActionListener(new ParserWidget$1(this));
    }

    private Runnable createImportTask() {
        return new ParserWidget$2(this);
    }

    private void jbInit() {
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), "Import Data (drag files from the file explorer and drop them into this window): ");
        this.tableScrollPane.setBorder(titledBorder);
        this.tableScrollPane.setPreferredSize(new Dimension(GuiHelper.DIMENSION_STANDARD_WINDOW.width, 200));
        this.tableScrollPane.revalidate();
        this.fTable.setAutoResizeMode(3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tableScrollPane, "Center");
        this.fSharedBar = new JProgressBar();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.fSharedBar, "Center");
        jPanel.add((Component)this.runButton, "East");
        this.add((Component)jPanel, "South");
    }

    @Override
    public final String getTitle() {
        return TITLE;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    @Override
    public final boolean allowClose() {
        return true;
    }

    @Override
    public final JComponent getWindowUI() {
        return this;
    }

    @Override
    public final Icon getIcon() {
        return ICON;
    }

    @Override
    public final Component getDroppableIntoComponent() {
        return this;
    }

    @Override
    public final void setDropData(Object object) {
        if (object == null) {
            return;
        }
        List list = (List)object;
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!(list.get(i2) instanceof File)) continue;
            arrayList.add(list.get(i2));
        }
        this.fTable.addFiles(arrayList.toArray(new File[arrayList.size()]));
        this.fTable.revalidate();
        this.fTable.repaint();
        this.revalidate();
    }

    @Override
    public final DataFlavor[] getDroppableFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor};
    }

    static final /* synthetic */ Runnable access$000(ParserWidget parserWidget) {
        return parserWidget.createImportTask();
    }

    static final /* synthetic */ DataImportTable access$100(ParserWidget parserWidget) {
        return parserWidget.fTable;
    }

    static final /* synthetic */ Logger access$200() {
        return klog;
    }

    static final /* synthetic */ JProgressBar access$300(ParserWidget parserWidget) {
        return parserWidget.fSharedBar;
    }
}

