/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.objmgr;

import edu.mit.broad.genome.io.FileTransferable;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.swing.GPopupChecker;
import edu.mit.broad.genome.swing.GuiHelper$Tree;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.explorer.objmgr.AbstractObjectTree;
import edu.mit.broad.xbench.explorer.objmgr.ObjectTreePopup$1;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ObjectTreePopup
extends GPopupChecker {
    private AbstractObjectTree fTree;

    public ObjectTreePopup(AbstractObjectTree abstractObjectTree) {
        this.fTree = abstractObjectTree;
        this.fTree.addMouseListener(new ObjectTreePopup$1(this));
    }

    public final File getSelectedFile() {
        FileTransferable fileTransferable = this.fTree.getSelectedFiles();
        if (fileTransferable == null) {
            return null;
        }
        File[] fileArray = fileTransferable.getFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    @Override
    protected final void maybeShowPopup(MouseEvent mouseEvent) {
        if (this.isRootExpandClick(mouseEvent)) {
            this.expandAll();
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JTree) {
            PersistentObject persistentObject = this.getSelectedPob();
            if (persistentObject != null) {
                JPopupMenu jPopupMenu = Application.getWindowManager().createPopupMenu(persistentObject);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            System.out.println(">>>>  showPopup: " + object);
        }
    }

    private boolean isRootExpandClick(MouseEvent mouseEvent) {
        Object object;
        if (!mouseEvent.isShiftDown()) {
            return false;
        }
        TreePath[] treePathArray = this.fTree.getSelectionPaths();
        return treePathArray != null && treePathArray.length == 1 && (object = treePathArray[0].getLastPathComponent()) == this.fTree.getModel().getRoot();
    }

    private PersistentObject getSelectedPob() {
        PersistentObject[] persistentObjectArray = this.getSelectedPobs();
        if (persistentObjectArray == null || persistentObjectArray.length == 0) {
            return null;
        }
        return persistentObjectArray[0];
    }

    private PersistentObject[] getSelectedPobs() {
        TreePath[] treePathArray = this.fTree.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < treePathArray.length; ++i2) {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2 = treePathArray[i2].getLastPathComponent();
            if (!(object2 instanceof DefaultMutableTreeNode) || (defaultMutableTreeNode = (DefaultMutableTreeNode)object2).getAllowsChildren() || !((object = defaultMutableTreeNode.getUserObject()) instanceof PersistentObject)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new PersistentObject[arrayList.size()]);
    }

    private void expandAll() {
        try {
            TreePath treePath = this.fTree.getPathForRow(0);
            if (treePath == null) {
                return;
            }
            GuiHelper$Tree.expandAll(this.fTree, treePath);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static final /* synthetic */ void access$000(ObjectTreePopup objectTreePopup, MouseEvent mouseEvent) {
        objectTreePopup.showPopup(mouseEvent);
    }
}

