/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.heatmap;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.math.ColorScheme;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.xbench.heatmap.DisplayState;
import edu.mit.broad.xbench.heatmap.GramImager;
import java.awt.image.BufferedImage;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.image.DisplaySettings;
import org.genepattern.heatmap.image.HeatMap;

public class GramImagerImpl
implements GramImager {
    private DisplayState fDisplayState;

    public GramImagerImpl() {
        this(null);
    }

    public GramImagerImpl(DisplayState displayState) {
        this.fDisplayState = displayState == null ? new DisplayState() : displayState;
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, DisplaySettings displaySettings) {
        return this._xcoreCreateBpogImage(dataset, null, null, displaySettings);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset) {
        return this._xcoreCreateBpogImage(dataset, null, null, null);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, ColorScheme colorScheme) {
        return this._xcoreCreateBpogImage(dataset, null, colorScheme, null);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, Template template) {
        return this._xcoreCreateBpogImage(dataset, template, null, null);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, Template template, ColorScheme colorScheme, DisplaySettings displaySettings) {
        return this._xcoreCreateBpogImage(dataset, template, colorScheme, displaySettings);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, Template template, DisplaySettings displaySettings) {
        return this._xcoreCreateBpogImage(dataset, template, null, displaySettings);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, Template template, ColorScheme colorScheme) {
        return this._xcoreCreateBpogImage(dataset, template, colorScheme, null);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, Template template, GeneSet geneSet) {
        return this.createBpogImage(dataset, template, geneSet, null);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, Template template, GeneSet geneSet, DisplaySettings displaySettings) {
        Dataset dataset2 = new DatasetGenerators().extractRows(dataset, geneSet);
        return this._xcoreCreateBpogImage(dataset2, template, null, displaySettings);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, GeneSet geneSet) {
        return this.createBpogImage(dataset, null, geneSet, null);
    }

    @Override
    public final BufferedImage createBpogImage(Dataset dataset, GeneSet geneSet, DisplaySettings displaySettings) {
        return this.createBpogImage(dataset, null, geneSet, displaySettings);
    }

    @Override
    public final BufferedImage createBpogImage(ScoredDataset scoredDataset, Template template, GeneSet geneSet) {
        return this.createBpogImage(new DatasetGenerators().extractRowsSorted(scoredDataset, geneSet), template);
    }

    @Override
    public final DisplayState getDisplayState() {
        return this.fDisplayState;
    }

    private DisplaySettings _createDefaultDisplaySettings(Dataset dataset, ColorScheme colorScheme) {
        DisplaySettings displaySettings = new DisplaySettings();
        displaySettings.drawGrid = true;
        displaySettings.rowSize = 12;
        displaySettings.columnSize = 12;
        displaySettings.sampleAnnonationsHeight = 15;
        displaySettings.drawGrid = true;
        displaySettings.showFeatureGridLines = true;
        displaySettings.showSampleGridLines = true;
        displaySettings.drawRowDescriptions = dataset.getAnnot().getFeatureAnnot().hasNativeDescriptions();
        displaySettings.drawRowNames = true;
        if (this.fDisplayState != null && this.fDisplayState.getColorScheme() != null) {
            displaySettings.colorConverter = this.fDisplayState.getColorScheme();
        }
        if (colorScheme != null) {
            displaySettings.colorConverter = GPWrappers.createColorScheme(dataset, colorScheme);
        }
        return displaySettings;
    }

    private BufferedImage _xcoreCreateBpogImage(Dataset dataset, Template template, ColorScheme colorScheme, DisplaySettings displaySettings) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param origDs cannot be null");
        }
        if (displaySettings == null) {
            displaySettings = this._createDefaultDisplaySettings(dataset, colorScheme);
        }
        IExpressionData iExpressionData = GPWrappers.createIExpressionData(dataset);
        return HeatMap.createImage(iExpressionData, displaySettings, GPWrappers.createSampleAnnotator(dataset, template), GPWrappers.createFeatureAnnotator(dataset));
    }
}

