/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.prefs;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooserTable;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.prefs.Preference;
import edu.mit.broad.xbench.prefs.PreferenceCategory;
import edu.mit.broad.xbench.prefs.PreferencesWidget$1;
import edu.mit.broad.xbench.prefs.PreferencesWidget$2;
import edu.mit.broad.xbench.prefs.PreferencesWidget$3;
import edu.mit.broad.xbench.prefs.PreferencesWidget$PrefUI;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public class PreferencesWidget
extends JPanel
implements Widget {
    public static final String TITLE = "Preferences";
    public static final Icon ICON = JarResources.getIcon("Preferences16.gif");
    private final Logger log = XLogger.getLogger(PreferencesWidget.class);
    private PreferencesWidget fInstance;
    private Map fCategoryPrefTableMap = new WeakHashMap();
    private JButton[] fCatButtons;
    private JLabel labelRestart;
    Component curr = null;

    public PreferencesWidget() {
        this.init();
    }

    private void init() {
        this.fInstance = this;
        this.jbInit();
    }

    public final JButton createResetButton() {
        JButton jButton = new JButton("Reset", GuiHelper.ICON_RESTORE16);
        jButton.addActionListener(new PreferencesWidget$1(this));
        return jButton;
    }

    private void jbInit() {
        int n;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createBevelBorder(0));
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        PreferenceCategory[] preferenceCategoryArray = XPreferencesFactory.ALL_CATEGORIES;
        boolean bl = Conf.isDebugMode();
        int n2 = 0;
        for (n = 0; n < preferenceCategoryArray.length; ++n) {
            if (!bl && preferenceCategoryArray[n].isDebugCategory()) continue;
            ++n2;
        }
        this.fCatButtons = new JButton[n2];
        n2 = 0;
        for (n = 0; n < preferenceCategoryArray.length; ++n) {
            if (!bl && preferenceCategoryArray[n].isDebugCategory()) continue;
            this.fCatButtons[n2] = this.createCategoryButton(preferenceCategoryArray[n]);
            jToolBar.add(this.fCatButtons[n2++]);
        }
        JScrollPane jScrollPane = new JScrollPane(jToolBar);
        this.add((Component)jScrollPane, "West");
        this.labelRestart = new JLabel();
        this.add((Component)this.labelRestart, "South");
        this.add(Box.createVerticalStrut(5), "North");
        this.add(Box.createHorizontalStrut(5), "East");
    }

    private JButton createCategoryButton(PreferenceCategory preferenceCategory) {
        JButton jButton = new JButton(preferenceCategory.getName(), preferenceCategory.getIcon());
        jButton.setToolTipText(preferenceCategory.getDesc());
        jButton.setVerticalTextPosition(3);
        jButton.setVerticalAlignment(3);
        jButton.setHorizontalTextPosition(0);
        jButton.addActionListener(new PreferencesWidget$2(this, preferenceCategory, jButton));
        BevelBorder bevelBorder = new BevelBorder(0, GuiHelper.COLOR_DARK_BLUE, GuiHelper.COLOR_DARK_BLUE);
        jButton.setBorder(bevelBorder);
        jButton.setRolloverEnabled(false);
        jButton.setBorderPainted(false);
        jButton.addMouseListener(new PreferencesWidget$3(this, jButton));
        return jButton;
    }

    private void changePref(PreferenceCategory preferenceCategory) {
        if (this.curr != null) {
            this.remove(this.curr);
        }
        PreferencesWidget$PrefUI preferencesWidget$PrefUI = this.createPrefTable(preferenceCategory);
        this.curr = preferencesWidget$PrefUI.table;
        this.add(this.curr, "Center");
        this.revalidate();
        this.repaint();
    }

    private PreferencesWidget$PrefUI createPrefTable(PreferenceCategory preferenceCategory) {
        Object object = this.fCategoryPrefTableMap.get(preferenceCategory);
        if (object == null) {
            PreferencesWidget$PrefUI preferencesWidget$PrefUI = new PreferencesWidget$PrefUI(this, preferenceCategory.getName());
            Preference[] preferenceArray = preferenceCategory.getPreferences();
            for (int i2 = 0; i2 < preferenceArray.length; ++i2) {
                Preference preference = preferenceArray[i2];
                if (!Conf.isDebugMode() && preference.isDebugPreference()) continue;
                if (preference.needsRestart()) {
                    preferencesWidget$PrefUI.labels.add("<html><body><b>" + preference.getName() + "</b><font color=#FF6600>[Effective on restart]</font></body></html>");
                } else {
                    preferencesWidget$PrefUI.labels.add(preference.getName());
                }
                preferencesWidget$PrefUI.jfcs.add(preference.getSelectionComponent());
            }
            preferencesWidget$PrefUI.table = new GFieldPlusChooserTable(preferencesWidget$PrefUI.labels.toArray(new String[preferencesWidget$PrefUI.labels.size()]), preferencesWidget$PrefUI.jfcs.toArray(new GFieldPlusChooser[preferencesWidget$PrefUI.jfcs.size()]));
            object = preferencesWidget$PrefUI;
            this.fCategoryPrefTableMap.put(preferenceCategory, object);
        }
        return (PreferencesWidget$PrefUI)object;
    }

    private void resetAll() {
        PreferenceCategory[] preferenceCategoryArray = XPreferencesFactory.ALL_CATEGORIES;
        for (int i2 = 0; i2 < preferenceCategoryArray.length; ++i2) {
            Preference[] preferenceArray = preferenceCategoryArray[i2].getPreferences();
            for (int i3 = 0; i3 < preferenceArray.length; ++i3) {
                Object object = preferenceArray[i3].getSelectionComponent().getValue();
                if (object == null) continue;
                preferenceArray[i3].reset();
            }
        }
        this.fInstance.revalidate();
    }

    public final void saveAll() {
        PreferenceCategory[] preferenceCategoryArray = XPreferencesFactory.ALL_CATEGORIES;
        for (int i2 = 0; i2 < preferenceCategoryArray.length; ++i2) {
            Preference[] preferenceArray = preferenceCategoryArray[i2].getPreferences();
            for (int i3 = 0; i3 < preferenceArray.length; ++i3) {
                Object object = preferenceArray[i3].getSelectionComponent().getValue();
                if (object == null) continue;
                preferenceArray[i3].setValue(object);
            }
        }
        Preference.kPrefs.flush();
    }

    @Override
    public final JComponent getWindowUI() {
        return this;
    }

    @Override
    public final String getTitle() {
        return TITLE;
    }

    @Override
    public final boolean allowClose() {
        return true;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return Widget.EMPTY_MENU_BAR;
    }

    @Override
    public final Icon getIcon() {
        return ICON;
    }

    static final /* synthetic */ void access$000(PreferencesWidget preferencesWidget) {
        preferencesWidget.resetAll();
    }

    static final /* synthetic */ void access$100(PreferencesWidget preferencesWidget, PreferenceCategory preferenceCategory) {
        preferencesWidget.changePref(preferenceCategory);
    }

    static final /* synthetic */ JButton[] access$200(PreferencesWidget preferencesWidget) {
        return preferencesWidget.fCatButtons;
    }
}

